/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class CheckpointLogFileTest {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    private final long rotationThreshold = ByteUnit.kibiBytes((long)1L);
    private final DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(2L, 0, 0L, 0L, 0L);
    private CheckpointFile checkpointFile;

    CheckpointLogFileTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        LogFiles logFiles = this.buildLogFiles();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        this.checkpointFile = logFiles.getCheckpointFile();
    }

    @Test
    void failToWriteCheckpointAfterShutdown() {
        CheckpointAppender checkpointAppender = this.checkpointFile.getCheckpointAppender();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> checkpointAppender.checkPoint(LogCheckPointEvent.NULL, new LogPosition(1L, 2L), Instant.now(), "test"));
        this.life.shutdown();
        org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> checkpointAppender.checkPoint(LogCheckPointEvent.NULL, new LogPosition(1L, 2L), Instant.now(), "test"));
    }

    @Test
    void provideMatchedCheckpointFiles() throws IOException {
        Object[] matchedFiles = this.checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)matchedFiles[0], (Object)this.checkpointFile.getCurrentFile());
    }

    @Test
    void latestCheckpointLookupLastCheckpoint() throws IOException {
        CheckpointAppender checkpointAppender = this.checkpointFile.getCheckpointAppender();
        Assertions.assertThat((Optional)this.checkpointFile.findLatestCheckpoint()).isEmpty();
        LogPosition firstLogPosition = new LogPosition(1L, 2L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, firstLogPosition, Instant.now(), "test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstLogPosition, (Object)((CheckpointInfo)this.checkpointFile.findLatestCheckpoint().orElseThrow()).getTransactionLogPosition());
        LogPosition secondLogPosition = new LogPosition(2L, 3L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, secondLogPosition, Instant.now(), "test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)secondLogPosition, (Object)((CheckpointInfo)this.checkpointFile.findLatestCheckpoint().orElseThrow()).getTransactionLogPosition());
        LogPosition thirdLogPosition = new LogPosition(3L, 4L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, thirdLogPosition, Instant.now(), "test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)thirdLogPosition, (Object)((CheckpointInfo)this.checkpointFile.findLatestCheckpoint().orElseThrow()).getTransactionLogPosition());
        List checkpointInfos = this.checkpointFile.reachableCheckpoints();
        Assertions.assertThat((List)checkpointInfos).hasSize(3);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(0))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)firstLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(1))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)secondLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(2))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)thirdLogPosition);
    }

    @Test
    void reachableCheckpointsShouldBeSorted() throws IOException {
        CheckpointAppender checkpointAppender = this.checkpointFile.getCheckpointAppender();
        LogPosition firstLogPosition = new LogPosition(1L, 2L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, firstLogPosition, Instant.now(), "test");
        LogPosition secondLogPosition = new LogPosition(2L, 3L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, secondLogPosition, Instant.now(), "test");
        LogPosition thirdLogPosition = new LogPosition(3L, 4L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, thirdLogPosition, Instant.now(), "test");
        LogPosition fourthLogPosition = new LogPosition(4L, 5L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, fourthLogPosition, Instant.now(), "test");
        LogPosition fifthLogPosition = new LogPosition(5L, 6L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, fifthLogPosition, Instant.now(), "test");
        LogPosition sixthLogPosition = new LogPosition(6L, 7L);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, sixthLogPosition, Instant.now(), "test");
        List checkpointInfos = this.checkpointFile.reachableCheckpoints();
        Assertions.assertThat((List)checkpointInfos).hasSize(6);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(0))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)firstLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(1))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)secondLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(2))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)thirdLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(3))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)fourthLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(4))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)fifthLogPosition);
        Assertions.assertThat((Object)((CheckpointInfo)checkpointInfos.get(5))).hasFieldOrPropertyWithValue("transactionLogPosition", (Object)sixthLogPosition);
    }

    @Test
    void findAllCheckpoints() throws IOException {
        CheckpointAppender checkpointAppender = this.checkpointFile.getCheckpointAppender();
        Assertions.assertThat((List)this.checkpointFile.reachableCheckpoints()).isEmpty();
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, new LogPosition(1L, 2L), Instant.now(), "test");
        Assertions.assertThat((List)this.checkpointFile.reachableCheckpoints()).hasSize(1);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, new LogPosition(2L, 3L), Instant.now(), "test");
        Assertions.assertThat((List)this.checkpointFile.reachableCheckpoints()).hasSize(2);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, new LogPosition(3L, 4L), Instant.now(), "test");
        Assertions.assertThat((List)this.checkpointFile.reachableCheckpoints()).hasSize(3);
    }

    private LogFiles buildLogFiles() throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withDatabaseHealth(this.databaseHealth).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
    }
}

