/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.index.schema.TokenScan;

public class StubTokenIndexReader
implements TokenIndexReader {
    private final Map<Long, Set<Long>> index = new HashMap<Long, Set<Long>>();

    void index(int[] tokens, long entity) {
        int[] nArray = tokens;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long token = nArray[i];
            this.index.computeIfAbsent(token, k -> new TreeSet());
            this.index.get(token).add(entity);
        }
    }

    public void query(IndexProgressor.EntityTokenClient client, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) {
        this.index.forEach((token, entities) -> client.initialize((IndexProgressor)new StubIndexProgressor(client, (Set<Long>)entities), token.intValue(), IndexOrder.NONE));
    }

    public void query(IndexProgressor.EntityTokenClient client, IndexQueryConstraints constraints, TokenPredicate query, EntityRange range, CursorContext cursorContext) {
        this.index.forEach((token, entities) -> client.initialize((IndexProgressor)new StubIndexProgressor(client, (Set<Long>)entities), token.intValue(), IndexOrder.NONE));
    }

    public TokenScan entityTokenScan(int tokenId, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Stub implementation does not support this method.");
    }

    public void close() {
    }

    private static class StubIndexProgressor
    implements IndexProgressor {
        private final IndexProgressor.EntityTokenClient client;
        private final Iterator<Long> entities;

        StubIndexProgressor(IndexProgressor.EntityTokenClient client, Set<Long> entities) {
            this.client = client;
            this.entities = entities.iterator();
        }

        public boolean next() {
            if (this.entities.hasNext()) {
                this.client.acceptEntity(this.entities.next().longValue(), TokenSet.NONE);
                return true;
            }
            return false;
        }

        public void close() {
        }
    }
}

