/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.values.storable.Value;

public class TestPropertyScanConsumer
implements PropertyScanConsumer {
    public final List<List<Record>> batches = Collections.synchronizedList(new ArrayList());

    public PropertyScanConsumer.Batch newBatch() {
        return new PropertyScanConsumer.Batch(){
            final List<Record> batchEntityUpdates = new ArrayList<Record>();

            public void addRecord(long entityId, long[] tokens, Map<Integer, Value> properties) {
                this.batchEntityUpdates.add(new Record(entityId, tokens, properties));
            }

            public void process() {
                TestPropertyScanConsumer.this.batches.add(this.batchEntityUpdates);
            }
        };
    }

    public static class Record {
        private final long entityId;
        private final long[] tokens;
        private final Map<Integer, Value> properties;

        public Record(long entityId, long[] tokens, Map<Integer, Value> properties) {
            this.entityId = entityId;
            this.tokens = tokens;
            this.properties = properties;
        }

        public long getEntityId() {
            return this.entityId;
        }

        public long[] getTokens() {
            return this.tokens;
        }

        public Map<Integer, Value> getProperties() {
            return this.properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.entityId == record.entityId && Arrays.equals(this.tokens, record.tokens) && this.properties.equals(record.properties);
        }

        public int hashCode() {
            int result = Objects.hash(this.entityId, this.properties);
            result = 31 * result + Arrays.hashCode(this.tokens);
            return result;
        }
    }
}

