/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import java.util.Map;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.ValueCategory;

public class GenericNativeIndexProvider
extends NativeIndexProvider<GenericKey, NativeIndexValue, GenericLayout> {
    public static final String KEY = GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion());
    public static final IndexCapability CAPABILITY = new GenericIndexCapability();
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final boolean archiveFailedIndex;
    private final Config config;

    public GenericNativeIndexProvider(DatabaseIndexContext databaseIndexContext, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config) {
        super(databaseIndexContext, DESCRIPTOR, directoryStructureFactory, recoveryCleanupWorkCollector);
        this.configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        this.configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration(config);
        this.archiveFailedIndex = (Boolean)config.get(GraphDatabaseInternalSettings.archive_failed_index);
        this.config = config;
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        IndexConfig indexConfig = index.getIndexConfig();
        if ((index = index.withIndexConfig(indexConfig = this.completeSpatialConfiguration(indexConfig))).getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability(CAPABILITY);
        }
        return index;
    }

    private IndexConfig completeSpatialConfiguration(IndexConfig indexConfig) {
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            SpaceFillingCurveSettings spaceFillingCurveSettings = this.configuredSettings.forCRS(crs);
            indexConfig = SpatialIndexConfig.addSpatialConfig(indexConfig, crs, spaceFillingCurveSettings);
        }
        return indexConfig;
    }

    @Override
    GenericLayout layout(IndexDescriptor descriptor, Path storeFile) {
        int numberOfSlots = descriptor.schema().getPropertyIds().length;
        IndexConfig indexConfig = descriptor.getIndexConfig();
        Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = SpatialIndexConfig.extractSpatialConfig(indexConfig);
        return new GenericLayout(numberOfSlots, new IndexSpecificSpaceFillingCurveSettings(settings));
    }

    @Override
    protected IndexPopulator newIndexPopulator(IndexFiles indexFiles, GenericLayout layout, IndexDescriptor descriptor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        return new GenericBlockBasedIndexPopulator(this.databaseIndexContext, indexFiles, layout, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, this.archiveFailedIndex, bufferFactory, this.config, memoryTracker, tokenNameLookup);
    }

    @Override
    protected IndexAccessor newIndexAccessor(IndexFiles indexFiles, GenericLayout layout, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return new GenericNativeIndexAccessor(this.databaseIndexContext, indexFiles, layout, this.recoveryCleanupWorkCollector, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, tokenNameLookup);
    }

    public void validatePrototype(IndexPrototype prototype) {
        super.validatePrototype(prototype);
        if (!prototype.schema().isLabelSchemaDescriptor() && !prototype.schema().isRelationshipTypeSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + prototype.schema() + " index schema is not a btree index schema, which it is required to be for the '" + this.getProviderDescriptor().name() + "' index provider to be able to create an index.");
        }
        IndexConfig indexConfig = prototype.getIndexConfig();
        indexConfig = this.completeSpatialConfiguration(indexConfig);
        try {
            SpatialIndexConfig.validateSpatialConfig(indexConfig);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid spatial index settings.", e);
        }
    }

    private static class GenericIndexCapability
    implements IndexCapability {
        private final IndexBehaviour[] behaviours = new IndexBehaviour[]{IndexBehaviour.SLOW_CONTAINS};

        private GenericIndexCapability() {
        }

        public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
            boolean seenUnknown = false;
            for (ValueCategory valueCategory : valueCategories) {
                if (valueCategory == ValueCategory.GEOMETRY || valueCategory == ValueCategory.GEOMETRY_ARRAY) {
                    return IndexOrderCapability.NONE;
                }
                if (valueCategory != ValueCategory.UNKNOWN) continue;
                seenUnknown = true;
            }
            return seenUnknown ? IndexOrderCapability.BOTH_PARTIALLY_SORTED : IndexOrderCapability.BOTH_FULLY_SORTED;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.YES;
        }

        public IndexBehaviour[] behaviours() {
            return this.behaviours;
        }
    }
}

