/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;

class PopulatingIndexProxyTest {
    private final IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2})).withName("index").materialise(13L);
    private final IndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(this.index, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    private final IndexPopulationJob indexPopulationJob = (IndexPopulationJob)Mockito.mock(IndexPopulationJob.class);
    private final MultipleIndexPopulator.IndexPopulation indexPopulation = (MultipleIndexPopulator.IndexPopulation)Mockito.mock(MultipleIndexPopulator.IndexPopulation.class);
    private PopulatingIndexProxy populatingIndexProxy;

    PopulatingIndexProxyTest() {
    }

    @BeforeEach
    void setUp() {
        this.populatingIndexProxy = new PopulatingIndexProxy(this.indexProxyStrategy, this.indexPopulationJob, this.indexPopulation);
    }

    @Test
    void stopPopulationJobOnClose() {
        this.populatingIndexProxy.close(CursorContext.NULL);
        ((IndexPopulationJob)Mockito.verify((Object)this.indexPopulationJob)).stop(this.indexPopulation, CursorContext.NULL);
    }

    @Test
    void cancelPopulationJobOnDrop() {
        this.populatingIndexProxy.drop();
        ((IndexPopulationJob)Mockito.verify((Object)this.indexPopulationJob)).dropPopulation(this.indexPopulation);
    }
}

