/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class RelationshipChangesForNodeTest {
    @Inject
    private RandomRule random;

    RelationshipChangesForNodeTest() {
    }

    @Test
    void shouldGetRelationships() {
        RelationshipChangesForNode changes = RelationshipChangesForNode.createRelationshipChangesForNode((RelationshipChangesForNode.DiffStrategy)RelationshipChangesForNode.DiffStrategy.ADD, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int TYPE = 2;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        LongIterator rawRelationships = changes.getRelationships();
        Assertions.assertThat((long[])PrimitiveLongCollections.asArray((LongIterator)rawRelationships)).containsExactly(new long[]{1L, 2L, 3L, 4L, 5L, 6L});
    }

    @Test
    void shouldGetRelationshipsByTypeAndDirection() {
        RelationshipChangesForNode changes = RelationshipChangesForNode.createRelationshipChangesForNode((RelationshipChangesForNode.DiffStrategy)RelationshipChangesForNode.DiffStrategy.ADD, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int TYPE = 2;
        int DECOY_TYPE = 666;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(10L, 666, RelationshipDirection.INCOMING);
        changes.addRelationship(11L, 666, RelationshipDirection.OUTGOING);
        changes.addRelationship(12L, 666, RelationshipDirection.LOOP);
        LongIterator rawIncoming = changes.getRelationships(Direction.INCOMING, 2);
        Assertions.assertThat((long[])PrimitiveLongCollections.asArray((LongIterator)rawIncoming)).containsExactly(new long[]{1L, 4L, 5L, 6L});
        LongIterator rawOutgoing = changes.getRelationships(Direction.OUTGOING, 2);
        Assertions.assertThat((long[])PrimitiveLongCollections.asArray((LongIterator)rawOutgoing)).containsExactly(new long[]{2L, 3L, 4L, 5L, 6L});
    }

    @Test
    void shouldVisitRelationshipIds() {
        RelationshipChangesForNode changes = RelationshipChangesForNode.createRelationshipChangesForNode((RelationshipChangesForNode.DiffStrategy)RelationshipChangesForNode.DiffStrategy.REMOVE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        MutableIntObjectMap expected = IntObjectMaps.mutable.empty();
        MutableLongSet allExpected = LongSets.mutable.empty();
        for (int id = 0; id < 100; ++id) {
            int type = this.random.nextInt(5);
            RelationshipDirection direction = this.random.nextBoolean() ? (this.random.nextBoolean() ? RelationshipDirection.OUTGOING : RelationshipDirection.INCOMING) : RelationshipDirection.LOOP;
            changes.addRelationship((long)id, type, direction);
            ((Map)expected.getIfAbsentPut(type, HashMap::new)).computeIfAbsent(direction, d -> LongSets.mutable.empty()).add((long)id);
            allExpected.add((long)id);
        }
        MutableLongSet allChangedIds = LongSets.mutable.empty();
        changes.visitIds(arg_0 -> ((MutableLongSet)allChangedIds).add(arg_0));
        Assertions.assertThat((Object)allChangedIds).isEqualTo((Object)allExpected);
        changes.visitIdsSplit(typeIds -> {
            Map dirMap = (Map)expected.remove(typeIds.type());
            RelationshipChangesForNodeTest.visitExpectedIds(typeIds, dirMap, RelationshipDirection.OUTGOING, RelationshipModifications.NodeRelationshipTypeIds::out);
            RelationshipChangesForNodeTest.visitExpectedIds(typeIds, dirMap, RelationshipDirection.INCOMING, RelationshipModifications.NodeRelationshipTypeIds::in);
            RelationshipChangesForNodeTest.visitExpectedIds(typeIds, dirMap, RelationshipDirection.LOOP, RelationshipModifications.NodeRelationshipTypeIds::loop);
            Assertions.assertThat((Map)dirMap).isEmpty();
            return false;
        }, RelationshipModifications.noAdditionalDataDecorator());
        Assertions.assertThat((Iterable)expected).isEmpty();
    }

    @Test
    void shouldReportHasRelationshipsOfType() {
        int type = 1;
        RelationshipChangesForNode changes = RelationshipChangesForNode.createRelationshipChangesForNode((RelationshipChangesForNode.DiffStrategy)RelationshipChangesForNode.DiffStrategy.ADD, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((boolean)changes.hasRelationships(type)).isFalse();
        long relId = 123L;
        RelationshipDirection[] directions = new RelationshipDirection[]{RelationshipDirection.OUTGOING, RelationshipDirection.INCOMING, RelationshipDirection.LOOP};
        for (int i = 0; i < directions.length; ++i) {
            changes.addRelationship(relId + (long)i, type, directions[i]);
            Assertions.assertThat((boolean)changes.hasRelationships(type)).isTrue();
        }
        for (RelationshipDirection direction : directions) {
            Assertions.assertThat((boolean)changes.hasRelationships(type)).isTrue();
            changes.removeRelationship(relId++, type, direction);
        }
        Assertions.assertThat((boolean)changes.hasRelationships(type)).isFalse();
    }

    private static void visitExpectedIds(RelationshipModifications.NodeRelationshipTypeIds typeIds, Map<RelationshipDirection, MutableLongSet> dirMap, RelationshipDirection direction, Function<RelationshipModifications.NodeRelationshipTypeIds, RelationshipModifications.RelationshipBatch> dude) {
        if (dirMap.containsKey(direction)) {
            dude.apply(typeIds).forEach((id, type, startNode, endNode) -> Assertions.assertThat((boolean)((MutableLongSet)dirMap.get(direction)).remove(id)).isTrue());
            Assertions.assertThat((int)dirMap.remove(direction).size()).isEqualTo(0);
        }
    }
}

