/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.factory.list.primitive.MutableLongListFactory;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexUtility;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.rule.TestDirectory;

public class TokenIndexAccessorTest
extends IndexAccessorTests<TokenScanKey, TokenScanValue, TokenScanLayout> {
    @Override
    IndexAccessor createAccessor(PageCache pageCache) {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").withReadOnlyChecker(DatabaseReadOnlyChecker.writable()).build();
        return new TokenIndexAccessor(context, DatabaseLayout.ofFlat((Path)this.directory.homePath()), this.indexFiles, Config.defaults(), this.indexDescriptor, cleanup);
    }

    @Override
    IndexFiles createIndexFiles(FileSystemAbstraction fs, TestDirectory directory, IndexDescriptor indexDescriptor) {
        return new IndexFiles.SingleFile(fs, directory.homePath().resolve(DatabaseFile.LABEL_SCAN_STORE.getName()));
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
    }

    @Override
    TokenScanLayout createLayout() {
        return new TokenScanLayout();
    }

    @Test
    void processMustThrowAfterClose() throws Exception {
        IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
        updater.close();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> updater.process(this.simpleUpdate()));
    }

    @Test
    void shouldAddWithUpdater() throws IndexEntryConflictException, IOException {
        MutableLongObjectMap entityTokens = LongObjectMaps.mutable.empty();
        List<TokenIndexEntryUpdate<?>> updates = TokenIndexUtility.generateSomeRandomUpdates((MutableLongObjectMap<long[]>)entityTokens, this.random);
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            for (TokenIndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
        this.forceAndCloseAccessor();
        TokenIndexUtility.verifyUpdates((MutableLongObjectMap<long[]>)entityTokens, (TokenScanLayout)this.layout, this::getTree);
    }

    @Test
    void updaterShouldHandleRandomizedUpdates() throws Throwable {
        Executable additionalOperation = () -> {};
        this.updaterShouldHandleRandomizedUpdates(additionalOperation);
    }

    @Test
    void updaterShouldHandleRandomizedUpdatesWithRestart() throws Throwable {
        Executable additionalOperation = this::maybeRestartAccessor;
        this.updaterShouldHandleRandomizedUpdates(additionalOperation);
    }

    @Test
    void updaterShouldHandleRandomizedUpdatesWithCheckpoint() throws Throwable {
        Executable additionalOperation = this::maybeCheckpoint;
        this.updaterShouldHandleRandomizedUpdates(additionalOperation);
    }

    private void updaterShouldHandleRandomizedUpdates(Executable additionalOperation) throws Throwable {
        MutableLongObjectMap entityTokens = LongObjectMaps.mutable.empty();
        this.doRandomizedUpdatesWithAdditionalOperation(additionalOperation, (MutableLongObjectMap<long[]>)entityTokens);
        this.forceAndCloseAccessor();
        TokenIndexUtility.verifyUpdates((MutableLongObjectMap<long[]>)entityTokens, (TokenScanLayout)this.layout, this::getTree);
    }

    @Test
    void newValueReaderShouldThrow() {
        Assertions.assertThatThrownBy(() -> ((IndexAccessor)this.accessor).newValueReader()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void readerShouldFindNothingOnEmptyIndex() throws Exception {
        this.assertReaderFindsExpected(1L, (LongList)LongLists.immutable.empty());
    }

    @Test
    void readerShouldFindNothingBecauseNoMatchingToken() throws Exception {
        int tokenId = 1;
        int otherTokenId = 2;
        this.addToIndex(otherTokenId, 1L);
        this.assertReaderFindsExpected(tokenId, (LongList)LongLists.immutable.empty());
    }

    @Test
    void readerShouldFindSingleWithNoOtherTokens() throws Exception {
        int tokenId = 1;
        long entityId = 1L;
        this.addToIndex(tokenId, entityId);
        ImmutableLongList expectedIds = LongLists.immutable.of(entityId);
        this.assertReaderFindsExpected(tokenId, (LongList)expectedIds);
    }

    @Test
    void readerShouldFindSingleWithOtherTokens() throws Exception {
        int tokenId = 1;
        long entityId = 1L;
        this.addToIndex(tokenId, entityId);
        this.addToIndex(2, 2L);
        ImmutableLongList expectedIds = LongLists.immutable.of(entityId);
        this.assertReaderFindsExpected(tokenId, (LongList)expectedIds);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void readerShouldFindManyWithNoOtherTokens(IndexOrder indexOrder) throws Exception {
        int tokenId = 1;
        long[] entityIds = new long[]{1L, 2L, 3L, 64L, 65L, 1000L, 2000L};
        this.addToIndex(tokenId, entityIds);
        ImmutableLongList expectedIds = LongLists.immutable.of(entityIds);
        this.assertReaderFindsExpected(indexOrder, tokenId, (LongList)expectedIds);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void readerShouldFindManyWithOtherTokens(IndexOrder indexOrder) throws Exception {
        int tokenId = 1;
        long[] entityIds = new long[]{1L, 2L, 3L, 64L, 65L, 1000L, 2001L};
        long[] otherEntityIds = new long[]{1L, 2L, 4L, 64L, 66L, 1000L, 2000L};
        this.addToIndex(tokenId, entityIds);
        this.addToIndex(2, otherEntityIds);
        ImmutableLongList expectedIds = LongLists.immutable.of(entityIds);
        this.assertReaderFindsExpected(indexOrder, tokenId, (LongList)expectedIds);
    }

    @ParameterizedTest
    @MethodSource(value={"orderCombinations"})
    void readerShouldHandleNestedQueries(IndexOrder outerOrder, IndexOrder innerOrder) throws Exception {
        int outerTokenId = 1;
        int innerTokenId = 2;
        long[] outerIds = new long[]{1L, 2L, 3L, 64L, 65L, 1000L, 2001L};
        long[] innerIds = new long[]{1L, 2L, 4L, 64L, 66L, 1000L, 2000L};
        ImmutableLongList outerExpectedIds = LongLists.immutable.of(outerIds);
        ImmutableLongList innerExpectedIds = LongLists.immutable.of(innerIds);
        this.addToIndex(outerTokenId, outerIds);
        this.addToIndex(innerTokenId, innerIds);
        try (TokenIndexReader reader = this.accessor.newTokenReader();){
            TokenIndexAccessorTest.assertReaderFindsExpected(reader, outerOrder, outerTokenId, (LongList)outerExpectedIds, (ThrowingConsumer<TokenIndexReader, Exception>)((ThrowingConsumer)arg_0 -> TokenIndexAccessorTest.lambda$readerShouldHandleNestedQueries$2(innerOrder, innerTokenId, (LongList)innerExpectedIds, arg_0)));
        }
    }

    @Test
    void readerShouldFindRandomizedUpdates() throws Throwable {
        Executable additionalOperation = () -> {};
        this.readerShouldFindRandomizedUpdates(additionalOperation);
    }

    @Test
    void readerShouldFindRandomizedUpdatesWithCheckpoint() throws Throwable {
        Executable additionalOperation = this::maybeCheckpoint;
        this.readerShouldFindRandomizedUpdates(additionalOperation);
    }

    @Test
    void readerShouldFindRandomizedUpdatesWithRestart() throws Throwable {
        Executable additionalOperation = this::maybeRestartAccessor;
        this.readerShouldFindRandomizedUpdates(additionalOperation);
    }

    @Test
    void readingAfterDropShouldThrow() {
        this.accessor.drop();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newTokenReader());
    }

    @Test
    void readingAfterCloseShouldThrow() {
        this.accessor.close();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newTokenReader());
    }

    private void readerShouldFindRandomizedUpdates(Executable additionalOperation) throws Throwable {
        MutableLongObjectMap entityTokens = LongObjectMaps.mutable.empty();
        this.doRandomizedUpdatesWithAdditionalOperation(additionalOperation, (MutableLongObjectMap<long[]>)entityTokens);
        this.verifyReaderSeesAllUpdates(TokenIndexAccessorTest.convertToExpectedEntitiesPerToken((MutableLongObjectMap<long[]>)entityTokens));
    }

    private void doRandomizedUpdatesWithAdditionalOperation(Executable additionalOperation, MutableLongObjectMap<long[]> trackingStructure) throws Throwable {
        int numberOfEntities = 1000;
        long currentMaxEntityId = 0L;
        while (currentMaxEntityId < (long)numberOfEntities) {
            int i;
            try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                for (i = 0; i < 100; ++i) {
                    long[] afterTokens = TokenIndexUtility.generateRandomTokens(this.random);
                    if (afterTokens.length != 0) {
                        trackingStructure.put(currentMaxEntityId, (Object)Arrays.copyOf(afterTokens, afterTokens.length));
                        updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)currentMaxEntityId, null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])afterTokens));
                    }
                    ++currentMaxEntityId;
                }
            }
            additionalOperation.execute();
            updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
            try {
                for (i = 0; i < 100; ++i) {
                    long entityId = this.random.nextLong(currentMaxEntityId);
                    long[] beforeTokens = (long[])trackingStructure.get(entityId);
                    if (beforeTokens == null) {
                        beforeTokens = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
                    }
                    long[] afterTokens = TokenIndexUtility.generateRandomTokens(this.random);
                    trackingStructure.put(entityId, (Object)Arrays.copyOf(afterTokens, afterTokens.length));
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entityId, null, (long[])beforeTokens, (long[])afterTokens));
                }
            }
            finally {
                if (updater != null) {
                    updater.close();
                }
            }
            additionalOperation.execute();
        }
    }

    private static MutableLongObjectMap<MutableLongList> convertToExpectedEntitiesPerToken(MutableLongObjectMap<long[]> trackingStructure) {
        MutableLongObjectMap entitiesPerToken = LongObjectMaps.mutable.empty();
        trackingStructure.forEachKeyValue((LongObjectProcedure & Serializable)(entityId, tokens) -> {
            for (long token : tokens) {
                MutableLongList entities = (MutableLongList)entitiesPerToken.getIfAbsentPut(token, (Object)LongLists.mutable.empty());
                entities.add(entityId);
            }
        });
        return entitiesPerToken;
    }

    private void addToIndex(int tokenId, long ... entityIds) throws IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            for (long entityId : entityIds) {
                updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)this.indexDescriptor, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{tokenId}));
            }
        }
    }

    private void verifyReaderSeesAllUpdates(MutableLongObjectMap<MutableLongList> entitiesPerToken) throws Exception {
        for (long token : TokenIndexUtility.TOKENS) {
            MutableLongList expectedEntities = (MutableLongList)entitiesPerToken.getIfAbsent(token, () -> ((MutableLongListFactory)LongLists.mutable).empty());
            this.assertReaderFindsExpected(token, (LongList)expectedEntities);
        }
    }

    private void assertReaderFindsExpected(long tokenId, LongList expectedIds) throws Exception {
        this.assertReaderFindsExpected(IndexOrder.NONE, tokenId, expectedIds);
    }

    private void assertReaderFindsExpected(IndexOrder indexOrder, long tokenId, LongList expectedIds) throws Exception {
        try (TokenIndexReader indexReader = this.accessor.newTokenReader();){
            TokenIndexAccessorTest.assertReaderFindsExpected(indexReader, indexOrder, tokenId, expectedIds, (ThrowingConsumer<TokenIndexReader, Exception>)ThrowingConsumer.noop());
        }
    }

    private static void assertReaderFindsExpected(TokenIndexReader reader, IndexOrder indexOrder, long tokenId, LongList expectedIds, ThrowingConsumer<TokenIndexReader, Exception> innerCalling) throws Exception {
        if (indexOrder.equals((Object)IndexOrder.DESCENDING)) {
            expectedIds = expectedIds.toReversed();
        }
        try (CollectingEntityTokenClient collectingEntityTokenClient = new CollectingEntityTokenClient(tokenId);){
            IndexQueryConstraints constraint = IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)false);
            TokenPredicate query = new TokenPredicate((int)tokenId);
            reader.query((IndexProgressor.EntityTokenClient)collectingEntityTokenClient, constraint, query, CursorContext.NULL);
            int count = 0;
            while (collectingEntityTokenClient.next()) {
                innerCalling.accept((Object)reader);
                ++count;
            }
            Assertions.assertThat((int)count).isEqualTo(expectedIds.size());
            Assertions.assertThat((Object)collectingEntityTokenClient.actualIds).isEqualTo((Object)expectedIds);
        }
    }

    private void maybeRestartAccessor() throws IOException {
        if (this.random.nextDouble() < 0.1) {
            this.forceAndCloseAccessor();
            this.setupAccessor();
        }
    }

    private void maybeCheckpoint() {
        if (this.random.nextBoolean()) {
            this.accessor.force(CursorContext.NULL);
        }
    }

    private void forceAndCloseAccessor() {
        this.accessor.force(CursorContext.NULL);
        this.accessor.close();
    }

    private TokenIndexEntryUpdate<IndexDescriptor> simpleUpdate() {
        return TokenIndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)this.indexDescriptor, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{0L});
    }

    private static Stream<Arguments> orderCombinations() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (IndexOrder outer : IndexOrder.values()) {
            for (IndexOrder inner : IndexOrder.values()) {
                arguments.add(Arguments.of((Object[])new Object[]{outer, inner}));
            }
        }
        return arguments.stream();
    }

    private static /* synthetic */ void lambda$readerShouldHandleNestedQueries$2(IndexOrder innerOrder, int innerTokenId, LongList innerExpectedIds, TokenIndexReader indexReader) throws Exception {
        TokenIndexAccessorTest.assertReaderFindsExpected(indexReader, innerOrder, innerTokenId, innerExpectedIds, (ThrowingConsumer<TokenIndexReader, Exception>)ThrowingConsumer.noop());
    }

    private static class CollectingEntityTokenClient
    implements IndexProgressor.EntityTokenClient,
    Closeable {
        private final long expectedToken;
        private final MutableLongList actualIds = LongLists.mutable.empty();
        private IndexProgressor progressor;

        private CollectingEntityTokenClient(long expectedToken) {
            this.expectedToken = expectedToken;
        }

        public void initialize(IndexProgressor progressor, int token, IndexOrder order) {
            Assertions.assertThat((int)token).isEqualTo(this.expectedToken);
            this.progressor = progressor;
        }

        public void initialize(IndexProgressor progressor, int token, LongIterator added, LongSet removed) {
            throw new UnsupportedOperationException("Did not expect to use this method");
        }

        public boolean acceptEntity(long reference, TokenSet tokens) {
            this.actualIds.add(reference);
            return true;
        }

        boolean next() {
            return this.progressor.next();
        }

        @Override
        public void close() {
            if (this.progressor != null) {
                this.progressor.close();
            }
        }
    }
}

