/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexProviderTests;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;

public class TokenIndexProviderTest
extends IndexProviderTests {
    private static final IndexProviderTests.ProviderFactory factory = (pageCache, fs, dir, monitors, collector, readOnlyChecker, databaseLayout) -> {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)fs, (String)databaseLayout.getDatabaseName()).withMonitors(monitors).withReadOnlyChecker(readOnlyChecker).build();
        return new TokenIndexProvider(context, dir, collector, Config.defaults(), databaseLayout);
    };

    TokenIndexProviderTest() {
        super(factory);
    }

    @Override
    void setupIndexFolders(FileSystemAbstraction fs) {
    }

    @Override
    IndexDescriptor descriptor() {
        return this.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE)).withName("labelIndex").materialise(1L));
    }

    @Override
    IndexDescriptor otherDescriptor() {
        return this.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP)).withName("relTypeIndex").materialise(1L));
    }

    @Override
    IndexPrototype validPrototype() {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withIndexType(IndexType.LOOKUP).withName("index");
    }

    @Override
    List<IndexPrototype> invalidPrototypes() {
        return List.of(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withIndexType(IndexType.BTREE).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)GenericNativeIndexProvider.DESCRIPTOR).withIndexType(IndexType.LOOKUP).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withIndexType(IndexType.LOOKUP).withName("unsupported"), IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withIndexType(IndexType.LOOKUP).withName("unsupported"));
    }
}

