/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.forseti.SharedLock;
import org.neo4j.lock.LockType;

class SharedLockTest {
    SharedLockTest() {
    }

    @Test
    void shouldUpgradeToUpdateLock() {
        ForsetiClient clientA = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        ForsetiClient clientB = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        SharedLock lock = new SharedLock(clientA);
        lock.acquire(clientB);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lock.tryAcquireUpdateLock(clientA));
        Assertions.assertThat((int)lock.numberOfHolders()).isEqualTo(2);
        Assertions.assertThat((boolean)lock.isUpdateLock()).isEqualTo(true);
    }

    @Test
    void shouldReleaseSharedLock() {
        ForsetiClient clientA = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        SharedLock lock = new SharedLock(clientA);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lock.release(clientA));
        Assertions.assertThat((int)lock.numberOfHolders()).isEqualTo(0);
        Assertions.assertThat((boolean)lock.isUpdateLock()).isEqualTo(false);
    }

    @Test
    void lockTypeChangesToBeExclusiveAfterUpdate() {
        ForsetiClient client = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        SharedLock lock = new SharedLock(client);
        org.junit.jupiter.api.Assertions.assertEquals((Object)LockType.SHARED, (Object)lock.type());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lock.tryAcquireUpdateLock(client));
        org.junit.jupiter.api.Assertions.assertEquals((Object)LockType.EXCLUSIVE, (Object)lock.type());
    }
}

