/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class SchemaIndexMigratorTest {
    @Inject
    private TestDirectory testDirectory;
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final ProgressReporter progressReporter = (ProgressReporter)Mockito.mock(ProgressReporter.class);
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private DatabaseLayout databaseLayout;
    private DatabaseLayout migrationLayout;

    SchemaIndexMigratorTest() {
    }

    @BeforeEach
    void setup() {
        this.databaseLayout = Neo4jLayout.of((Path)this.testDirectory.directory("store")).databaseLayout("neo4j");
        this.migrationLayout = Neo4jLayout.of((Path)this.testDirectory.directory("migrationDir")).databaseLayout("neo4j");
    }

    @Test
    void schemaAndLabelIndexesRemovedAfterSuccessfulMigration() throws IOException {
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        StoreVersion version = (StoreVersion)Mockito.mock(StoreVersion.class);
        Mockito.when((Object)version.hasCompatibleCapabilities((StoreVersion)ArgumentMatchers.any(), (CapabilityType)ArgumentMatchers.eq((Object)CapabilityType.INDEX))).thenReturn((Object)false);
        Mockito.when((Object)storageEngineFactory.versionInformation(ArgumentMatchers.anyString())).thenReturn((Object)version);
        IndexImporterFactory indexImporterFactory = (IndexImporterFactory)Mockito.mock(IndexImporterFactory.class);
        IndexDirectoryStructure directoryStructure = (IndexDirectoryStructure)Mockito.mock(IndexDirectoryStructure.class);
        Path indexProviderRootDirectory = this.databaseLayout.file("just-some-directory");
        Mockito.when((Object)directoryStructure.rootDirectory()).thenReturn((Object)indexProviderRootDirectory);
        SchemaIndexMigrator migrator = new SchemaIndexMigrator("Test migrator", this.fs, this.pageCache, directoryStructure, storageEngineFactory, true);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)new IndexProviderDescriptor("key", "version"));
        migrator.migrate(this.databaseLayout, this.migrationLayout, this.progressReporter, "from", "to", indexImporterFactory);
        migrator.moveMigratedFiles(this.migrationLayout, this.databaseLayout, "from", "to");
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(indexProviderRootDirectory);
    }

    @Test
    void shouldDeleteRelationshipIndexesAfterCrossFormatFamilyMigration() throws IOException {
        IndexProviderDescriptor provider = new IndexProviderDescriptor("k", "v");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.databaseLayout.databaseDirectory()).forProvider(provider);
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        StoreVersion fromVersion = (StoreVersion)Mockito.mock(StoreVersion.class);
        StoreVersion toVersion = (StoreVersion)Mockito.mock(StoreVersion.class);
        Mockito.when((Object)fromVersion.hasCompatibleCapabilities(toVersion, CapabilityType.FORMAT)).thenReturn((Object)false);
        Mockito.when((Object)storageEngineFactory.versionInformation("from")).thenReturn((Object)fromVersion);
        Mockito.when((Object)storageEngineFactory.versionInformation("to")).thenReturn((Object)toVersion);
        ArrayList<IndexDescriptor> schemaRules = new ArrayList<IndexDescriptor>();
        schemaRules.add(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2, 3})).withName("n1").materialise(1L));
        schemaRules.add(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)5, (int[])new int[]{3})).withName("r1").materialise(2L));
        schemaRules.add(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1, 2, 3}, (int[])new int[]{4, 5, 6})).withName("r2").materialise(3L));
        schemaRules.add(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{1, 2, 3}, (int[])new int[]{4, 5, 6})).withName("n2").materialise(4L));
        Mockito.when((Object)storageEngineFactory.loadSchemaRules((FileSystemAbstraction)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any())).thenReturn(schemaRules);
        SchemaIndexMigrator migrator = new SchemaIndexMigrator("Test migrator", this.fs, this.pageCache, directoryStructure, storageEngineFactory, false);
        migrator.migrate(this.databaseLayout, this.migrationLayout, this.progressReporter, "from", "to", IndexImporterFactory.EMPTY);
        migrator.moveMigratedFiles(this.databaseLayout, this.migrationLayout, "from", "to");
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).deleteRecursively(directoryStructure.directoryForIndex(1L));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(directoryStructure.directoryForIndex(2L));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(directoryStructure.directoryForIndex(3L));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).deleteRecursively(directoryStructure.directoryForIndex(4L));
    }
}

