/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.block.factory.primitive.IntPredicates;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.ProcessorAssignmentStrategies;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityScanCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreScanStage;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.test.DoubleLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class StoreScanStageTest {
    private static final int WORKERS = 8;
    private static final int LABEL = 1;
    private static final String KEY = "key";
    private static final int NUMBER_OF_BATCHES = 4;
    private final Config dbConfig = Config.defaults((Setting)GraphDatabaseInternalSettings.index_population_workers, (Object)8);
    private final Configuration config = new Configuration(){

        public int maxNumberOfProcessors() {
            return 8;
        }

        public int batchSize() {
            return 10;
        }
    };
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();

    StoreScanStageTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest(name="parallelWrite={0}")
    void shouldGenerateUpdatesInParallel(boolean parallelWrite) {
        StubStorageCursors data = this.someData();
        PropertyAwareEntityStoreScan.CursorEntityIdIterator entityIdIterator = new PropertyAwareEntityStoreScan.CursorEntityIdIterator((StorageEntityScanCursor)data.allocateNodeCursor(CursorContext.NULL));
        ThreadCapturingPropertyConsumer propertyConsumer = new ThreadCapturingPropertyConsumer();
        ThreadCapturingTokenConsumer tokenConsumer = new ThreadCapturingTokenConsumer();
        ControlledLockFunction lockFunction = new ControlledLockFunction();
        StoreScanStage scan = new StoreScanStage(this.dbConfig, this.config, arg_0 -> StoreScanStageTest.lambda$shouldGenerateUpdatesInParallel$0((EntityIdIterator)entityIdIterator, arg_0), StoreScan.NO_EXTERNAL_UPDATES, new AtomicBoolean(true), (StorageReader)data, new int[]{1}, (IntPredicate)IntPredicates.alwaysTrue(), (PropertyScanConsumer)propertyConsumer, (TokenScanConsumer)tokenConsumer, (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), (LongFunction)lockFunction, parallelWrite, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        StoreScanStageTest.runScan((StoreScanStage<StorageNodeCursor>)scan);
        Assertions.assertThat((int)lockFunction.seenThreads.size()).isGreaterThan(1);
        if (parallelWrite) {
            Assertions.assertThat((int)propertyConsumer.seenThreads.size()).isGreaterThan(1);
            Assertions.assertThat((int)tokenConsumer.seenThreads.size()).isGreaterThan(1);
        } else {
            Assertions.assertThat((int)propertyConsumer.seenThreads.size()).isEqualTo(1);
            Assertions.assertThat((int)tokenConsumer.seenThreads.size()).isEqualTo(1);
        }
    }

    @Test
    void shouldPanicAndExitStageOnWriteFailure() {
        StubStorageCursors data = this.someData();
        PropertyAwareEntityStoreScan.CursorEntityIdIterator entityIdIterator = new PropertyAwareEntityStoreScan.CursorEntityIdIterator((StorageEntityScanCursor)data.allocateNodeCursor(CursorContext.NULL));
        PropertyConsumer failingWriter = new PropertyConsumer(() -> {
            throw new IllegalStateException("Failed to write");
        });
        StoreScanStage scan = new StoreScanStage(this.dbConfig, this.config, arg_0 -> StoreScanStageTest.lambda$shouldPanicAndExitStageOnWriteFailure$2((EntityIdIterator)entityIdIterator, arg_0), StoreScan.NO_EXTERNAL_UPDATES, new AtomicBoolean(true), (StorageReader)data, new int[]{1}, (IntPredicate)IntPredicates.alwaysTrue(), (PropertyScanConsumer)failingWriter, null, (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), id -> null, true, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StoreScanStageTest.runScan((StoreScanStage<StorageNodeCursor>)scan)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Failed to write");
    }

    @Test
    void shouldApplyExternalUpdatesIfThereAreSuch() {
        StubStorageCursors data = this.someData();
        PropertyAwareEntityStoreScan.CursorEntityIdIterator entityIdIterator = new PropertyAwareEntityStoreScan.CursorEntityIdIterator((StorageEntityScanCursor)data.allocateNodeCursor(CursorContext.NULL));
        AtomicInteger numBatchesProcessed = new AtomicInteger();
        ControlledExternalUpdatesCheck externalUpdatesCheck = new ControlledExternalUpdatesCheck(this.config.batchSize(), 2, numBatchesProcessed);
        PropertyConsumer writer = new PropertyConsumer(() -> numBatchesProcessed.incrementAndGet());
        StoreScanStage scan = new StoreScanStage(this.dbConfig, this.config, arg_0 -> StoreScanStageTest.lambda$shouldApplyExternalUpdatesIfThereAreSuch$6((EntityIdIterator)entityIdIterator, arg_0), (StoreScan.ExternalUpdatesCheck)externalUpdatesCheck, new AtomicBoolean(true), (StorageReader)data, new int[]{1}, (IntPredicate)IntPredicates.alwaysTrue(), (PropertyScanConsumer)writer, null, (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), id -> null, true, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        StoreScanStageTest.runScan((StoreScanStage<StorageNodeCursor>)scan);
        Assertions.assertThat((int)externalUpdatesCheck.applyCallCount).isEqualTo(1);
    }

    @Test
    void shouldAbortScanOnStopped() {
        StubStorageCursors data = this.someData();
        PropertyAwareEntityStoreScan.CursorEntityIdIterator entityIdIterator = new PropertyAwareEntityStoreScan.CursorEntityIdIterator((StorageEntityScanCursor)data.allocateNodeCursor(CursorContext.NULL));
        AtomicInteger numBatchesProcessed = new AtomicInteger();
        AtomicBoolean continueScanning = new AtomicBoolean(true);
        AbortingExternalUpdatesCheck externalUpdatesCheck = new AbortingExternalUpdatesCheck(1, continueScanning);
        PropertyConsumer writer = new PropertyConsumer(() -> numBatchesProcessed.incrementAndGet());
        StoreScanStage scan = new StoreScanStage(this.dbConfig, this.config, arg_0 -> StoreScanStageTest.lambda$shouldAbortScanOnStopped$9((EntityIdIterator)entityIdIterator, arg_0), (StoreScan.ExternalUpdatesCheck)externalUpdatesCheck, continueScanning, (StorageReader)data, new int[]{1}, (IntPredicate)IntPredicates.alwaysTrue(), (PropertyScanConsumer)writer, null, (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), id -> null, true, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        StoreScanStageTest.runScan((StoreScanStage<StorageNodeCursor>)scan);
        Assertions.assertThat((int)numBatchesProcessed.get()).isEqualTo(2);
    }

    @Test
    void shouldReportCorrectNumberOfEntitiesProcessed() {
        StubStorageCursors data = this.someData();
        final AtomicReference<StoreScanStage> stage = new AtomicReference<StoreScanStage>();
        PropertyAwareEntityStoreScan.CursorEntityIdIterator<StorageNodeCursor> entityIdIterator = new PropertyAwareEntityStoreScan.CursorEntityIdIterator<StorageNodeCursor>(data.allocateNodeCursor(CursorContext.NULL)){
            private long manualCounter;

            protected boolean fetchNext() {
                Assertions.assertThat((long)((StoreScanStage)stage.get()).numberOfIteratedEntities()).isEqualTo(this.manualCounter / (long)StoreScanStageTest.this.config.batchSize() * (long)StoreScanStageTest.this.config.batchSize());
                ++this.manualCounter;
                return super.fetchNext();
            }
        };
        StoreScanStage scan = new StoreScanStage(this.dbConfig, this.config, arg_0 -> StoreScanStageTest.lambda$shouldReportCorrectNumberOfEntitiesProcessed$11((EntityIdIterator)entityIdIterator, arg_0), StoreScan.NO_EXTERNAL_UPDATES, new AtomicBoolean(true), (StorageReader)data, new int[]{1}, (IntPredicate)IntPredicates.alwaysTrue(), (PropertyScanConsumer)new ThreadCapturingPropertyConsumer(), (TokenScanConsumer)new ThreadCapturingTokenConsumer(), (EntityScanCursorBehaviour)new NodeCursorBehaviour((StorageReader)data), l -> LockService.NO_LOCK, true, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        stage.set(scan);
        StoreScanStageTest.runScan((StoreScanStage<StorageNodeCursor>)scan);
        Assertions.assertThat((long)scan.numberOfIteratedEntities()).isEqualTo((long)this.config.batchSize() * 4L);
    }

    private static void runScan(StoreScanStage<StorageNodeCursor> scan) {
        ExecutionSupervisors.superviseDynamicExecution((ExecutionMonitor)ProcessorAssignmentStrategies.saturateSpecificStep((int)1), scan);
    }

    private StubStorageCursors someData() {
        StubStorageCursors data = new StubStorageCursors();
        for (int i = 0; i < this.config.batchSize() * 4; ++i) {
            data.withNode(i).labels(1L).properties(new Object[]{KEY, Values.stringValue((String)("name_" + i))});
        }
        return data;
    }

    private static /* synthetic */ Object lambda$shouldReportCorrectNumberOfEntitiesProcessed$11(EntityIdIterator entityIdIterator, Object ct) {
        return entityIdIterator;
    }

    private static /* synthetic */ Object lambda$shouldAbortScanOnStopped$9(EntityIdIterator entityIdIterator, Object ct) {
        return entityIdIterator;
    }

    private static /* synthetic */ Object lambda$shouldApplyExternalUpdatesIfThereAreSuch$6(EntityIdIterator entityIdIterator, Object ct) {
        return entityIdIterator;
    }

    private static /* synthetic */ EntityIdIterator lambda$shouldPanicAndExitStageOnWriteFailure$2(EntityIdIterator entityIdIterator, CursorContext ct) {
        return entityIdIterator;
    }

    private static /* synthetic */ EntityIdIterator lambda$shouldGenerateUpdatesInParallel$0(EntityIdIterator entityIdIterator, CursorContext ct) {
        return entityIdIterator;
    }

    private static class AbortingExternalUpdatesCheck
    implements StoreScan.ExternalUpdatesCheck {
        private final int abortAfterBatch;
        private final AtomicBoolean continueScanning;
        private int callCount;

        AbortingExternalUpdatesCheck(int abortAfterBatch, AtomicBoolean continueScanning) {
            this.abortAfterBatch = abortAfterBatch;
            this.continueScanning = continueScanning;
        }

        public boolean needToApplyExternalUpdates() {
            if (this.callCount++ == this.abortAfterBatch) {
                this.continueScanning.set(false);
            }
            return false;
        }

        public void applyExternalUpdates(long currentlyIndexedNodeId) {
            throw new IllegalStateException("Should not be called");
        }
    }

    private static class ThreadCapturingTokenConsumer
    implements TokenScanConsumer {
        private final Set<Thread> seenThreads = ConcurrentHashMap.newKeySet();

        private ThreadCapturingTokenConsumer() {
        }

        public TokenScanConsumer.Batch newBatch() {
            return new TokenScanConsumer.Batch(){

                public void addRecord(long entityId, long[] tokens) {
                }

                public void process() {
                    seenThreads.add(Thread.currentThread());
                }
            };
        }
    }

    private static class ThreadCapturingPropertyConsumer
    implements PropertyScanConsumer {
        private final Set<Thread> seenThreads = ConcurrentHashMap.newKeySet();

        private ThreadCapturingPropertyConsumer() {
        }

        public PropertyScanConsumer.Batch newBatch() {
            return new PropertyScanConsumer.Batch(){

                public void addRecord(long entityId, long[] tokens, Map<Integer, Value> properties) {
                }

                public void process() {
                    seenThreads.add(Thread.currentThread());
                }
            };
        }
    }

    private static class PropertyConsumer
    implements PropertyScanConsumer {
        private final Runnable action;

        PropertyConsumer(Runnable action) {
            this.action = action;
        }

        public PropertyScanConsumer.Batch newBatch() {
            return new PropertyScanConsumer.Batch(){

                public void addRecord(long entityId, long[] tokens, Map<Integer, Value> properties) {
                }

                public void process() {
                    action.run();
                }
            };
        }
    }

    private static class ControlledExternalUpdatesCheck
    implements StoreScan.ExternalUpdatesCheck {
        private final int expectedNodeId;
        private final int applyOnBatchIndex;
        private final AtomicInteger numBatchesProcessed;
        private int checkCallCount;
        private volatile int applyCallCount;

        ControlledExternalUpdatesCheck(int batchSize, int applyOnBatchIndex, AtomicInteger numBatchesProcessed) {
            this.applyOnBatchIndex = applyOnBatchIndex;
            this.numBatchesProcessed = numBatchesProcessed;
            this.expectedNodeId = batchSize * applyOnBatchIndex - 1;
        }

        public boolean needToApplyExternalUpdates() {
            return this.checkCallCount++ == this.applyOnBatchIndex;
        }

        public void applyExternalUpdates(long currentlyIndexedNodeId) {
            Assertions.assertThat((long)currentlyIndexedNodeId).isEqualTo((long)this.expectedNodeId);
            Assertions.assertThat((int)this.numBatchesProcessed.get()).isEqualTo(this.applyOnBatchIndex);
            ++this.applyCallCount;
        }
    }

    private static class ControlledLockFunction
    implements LongFunction<Lock> {
        private final Set<Thread> seenThreads = ConcurrentHashMap.newKeySet();
        private final CountDownLatch latch = new CountDownLatch(2);

        private ControlledLockFunction() {
        }

        @Override
        public Lock apply(long id) {
            this.seenThreads.add(Thread.currentThread());
            this.latch.countDown();
            DoubleLatch.awaitLatch((CountDownLatch)this.latch);
            return null;
        }
    }
}

