/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.DateType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class DateArrayType
extends AbstractArrayType<LocalDate> {
    DateArrayType(byte typeId) {
        super(ValueGroup.DATE_ARRAY, typeId, (o1, o2, i) -> DateType.compare(o1.long0Array[i], o2.long0Array[i]), (k, i) -> DateType.asValueRaw(k.long0Array[i]), (c, k, i) -> DateType.put(c, k.long0Array[i]), DateType::read, LocalDate[]::new, ValueWriter.ArrayType.DATE);
    }

    @Override
    int valueSize(GenericKey state) {
        return DateArrayType.arrayKeySize(state, 8);
    }

    @Override
    void copyValue(GenericKey to, GenericKey from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
    }

    @Override
    void initializeArray(GenericKey key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = DateArrayType.ensureBigEnough(key.long0Array, length);
    }

    public static void write(GenericKey state, int offset, long epochDay) {
        state.long0Array[offset] = epochDay;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

