/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.RangeLongIterator;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.util.Preconditions;

abstract class BaseCursorScan<C extends Cursor, S>
implements Scan<C> {
    final S storageScan;
    final Read read;
    final boolean hasChanges;
    final CursorContext cursorContext;
    private volatile boolean addedItemsConsumed;
    private final long[] addedItemsArray;
    private final AtomicInteger addedChunk = new AtomicInteger(0);

    BaseCursorScan(S storageScan, Read read, Supplier<long[]> addedInTransaction, CursorContext cursorContext) {
        this.storageScan = storageScan;
        this.read = read;
        this.hasChanges = read.hasTxStateWithChanges();
        this.addedItemsArray = this.hasChanges ? addedInTransaction.get() : PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        this.cursorContext = cursorContext;
        this.addedItemsConsumed = this.addedItemsArray.length == 0;
    }

    public boolean reserveBatch(C cursor, int sizeHint) {
        Preconditions.requirePositive((int)sizeHint);
        ImmutableEmptyLongIterator addedItems = ImmutableEmptyLongIterator.INSTANCE;
        if (this.hasChanges && !this.addedItemsConsumed) {
            int addedStart = this.addedChunk.getAndAdd(sizeHint);
            if (addedStart < this.addedItemsArray.length) {
                int batchSize = Math.min(sizeHint, this.addedItemsArray.length - addedStart);
                sizeHint -= batchSize;
                addedItems = new RangeLongIterator(this.addedItemsArray, addedStart, batchSize);
            } else {
                this.addedItemsConsumed = true;
            }
        }
        return this.scanStore(cursor, sizeHint, (LongIterator)addedItems);
    }

    abstract boolean scanStore(C var1, int var2, LongIterator var3);
}

