/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;

class IndexMapTest {
    private IndexMap indexMap;
    private final LabelSchemaDescriptor schema3_4 = SchemaDescriptors.forLabel((int)3, (int[])new int[]{4});
    private final IndexDescriptor index3_4 = IndexPrototype.forSchema((SchemaDescriptor)this.schema3_4).withName("index_1").materialise(1L);
    private final LabelSchemaDescriptor schema5_6_7 = SchemaDescriptors.forLabel((int)5, (int[])new int[]{6, 7});
    private final IndexDescriptor index5_6_7 = IndexPrototype.forSchema((SchemaDescriptor)this.schema5_6_7).withName("index_2").materialise(2L);
    private final LabelSchemaDescriptor schema5_8 = SchemaDescriptors.forLabel((int)5, (int[])new int[]{8});
    private final IndexDescriptor index5_8 = IndexPrototype.forSchema((SchemaDescriptor)this.schema5_8).withName("index_3").materialise(3L);
    private final SchemaDescriptor node35_8 = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{3, 5}, (int[])new int[]{8});
    private final IndexDescriptor index_node35_8 = IndexPrototype.forSchema((SchemaDescriptor)this.node35_8).withName("index_4").materialise(4L);
    private final SchemaDescriptor rel35_8 = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{3, 5}, (int[])new int[]{8});
    private final IndexDescriptor index_rel35_8 = IndexPrototype.forSchema((SchemaDescriptor)this.rel35_8).withName("index_5").materialise(5L);

    IndexMapTest() {
    }

    @BeforeEach
    void setup() {
        this.indexMap = new IndexMap();
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(this.index3_4));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(this.index5_6_7));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(this.index5_8));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(this.index_node35_8));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(this.index_rel35_8));
    }

    @Test
    void shouldGetById() {
        Assertions.assertEquals((Object)this.schema3_4, (Object)this.indexMap.getIndexProxy(1L).getDescriptor().schema());
        Assertions.assertEquals((Object)this.schema5_6_7, (Object)this.indexMap.getIndexProxy(2L).getDescriptor().schema());
    }

    @Test
    void shouldGetByDescriptor() {
        Assertions.assertEquals((Object)this.schema5_8, (Object)this.indexMap.getIndexProxy(this.index5_8).getDescriptor().schema());
        Assertions.assertEquals((Object)this.node35_8, (Object)this.indexMap.getIndexProxy(this.index_node35_8).getDescriptor().schema());
    }

    private static class TestIndexProxy
    extends IndexProxyAdapter {
        private final IndexDescriptor descriptor;

        private TestIndexProxy(IndexDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public IndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

