/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.api.state.AppendOnlyValuesContainer;
import org.neo4j.kernel.impl.api.state.TestMemoryAllocator;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapMemoryAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class AppendOnlyValuesContainerTest {
    @Inject
    private RandomSupport rnd;
    private final CachingOffHeapBlockAllocator blockAllocator = new CachingOffHeapBlockAllocator();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final AppendOnlyValuesContainer container = new AppendOnlyValuesContainer((MemoryAllocator)new OffHeapMemoryAllocator((OffHeapBlockAllocator)this.blockAllocator), this.memoryTracker);

    AppendOnlyValuesContainerTest() {
    }

    @AfterAll
    static void afterAll() {
    }

    @AfterEach
    void afterEach() {
        this.container.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory(), (String)"Got memory leak");
        this.blockAllocator.release();
    }

    @TestFactory
    Stream<DynamicTest> addGet() {
        List<Pair> inputs = Arrays.asList(AppendOnlyValuesContainerTest.testInput("NoValue", Function.identity(), Values.NO_VALUE), AppendOnlyValuesContainerTest.testInput("Boolean", Values::booleanValue, true, false, true, false), AppendOnlyValuesContainerTest.testInput("BooleanArray", Values::booleanArray, {false, true, false}, ArrayUtils.EMPTY_BOOLEAN_ARRAY), AppendOnlyValuesContainerTest.testInput("Byte", Values::byteValue, (byte)0, (byte)1, (byte)-1, (byte)-128, (byte)127), AppendOnlyValuesContainerTest.testInput("ByteArray", Values::byteArray, {0, 1, -1, -128, 127}, ArrayUtils.EMPTY_BYTE_ARRAY), AppendOnlyValuesContainerTest.testInput("Short", Values::shortValue, (short)0, (short)1, (short)-1, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE), AppendOnlyValuesContainerTest.testInput("ShortArray", Values::shortArray, {0, 1, -1, Short.MIN_VALUE, Short.MAX_VALUE}, ArrayUtils.EMPTY_SHORT_ARRAY), AppendOnlyValuesContainerTest.testInput("Char", Values::charValue, Character.valueOf('a'), Character.valueOf('\uffff'), Character.valueOf('\u2202'), Character.valueOf('\u00a9')), AppendOnlyValuesContainerTest.testInput("CharArray", Values::charArray, {'a', '\uffff', '\u2202', '\u00a9'}, ArrayUtils.EMPTY_CHAR_ARRAY), AppendOnlyValuesContainerTest.testInput("Int", Values::intValue, 0, 1, -1, Integer.MIN_VALUE, Integer.MAX_VALUE), AppendOnlyValuesContainerTest.testInput("IntArray", Values::intArray, {0, 1, -1, Integer.MIN_VALUE, Integer.MAX_VALUE}, ArrayUtils.EMPTY_INT_ARRAY), AppendOnlyValuesContainerTest.testInput("Long", Values::longValue, 0L, 1L, -1L, Long.MIN_VALUE, Long.MAX_VALUE), AppendOnlyValuesContainerTest.testInput("LongArray", Values::longArray, {0L, 1L, -1L, Long.MIN_VALUE, Long.MAX_VALUE}, ArrayUtils.EMPTY_LONG_ARRAY), AppendOnlyValuesContainerTest.testInput("Double", Values::doubleValue, 0.0, 1.0, -1.0, Double.MIN_VALUE, Double.MAX_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), AppendOnlyValuesContainerTest.testInput("DoubleArray", Values::doubleArray, {0.0, 1.0, -1.0, Double.MIN_VALUE, Double.MAX_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}, ArrayUtils.EMPTY_DOUBLE_ARRAY), AppendOnlyValuesContainerTest.testInput("Float", Values::floatValue, Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY)), AppendOnlyValuesContainerTest.testInput("FloatArray", Values::floatArray, {0.0f, 1.0f, -1.0f, Float.MIN_VALUE, Float.MAX_VALUE, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY}, ArrayUtils.EMPTY_FLOAT_ARRAY), AppendOnlyValuesContainerTest.testInput("String", Values::stringValue, "", "x", "foobar"), AppendOnlyValuesContainerTest.testInput("StringArray", Values::stringArray, {"", "x", "foobar"}, ArrayUtils.EMPTY_STRING_ARRAY), AppendOnlyValuesContainerTest.testInput("Point", input -> Values.pointValue((CoordinateReferenceSystem)((CoordinateReferenceSystem)input.getOne()), (double[])((double[])input.getTwo())), Tuples.pair((Object)CoordinateReferenceSystem.WGS84, (Object)new double[]{1.0, 2.0}), Tuples.pair((Object)CoordinateReferenceSystem.WGS84_3D, (Object)new double[]{1.0, 2.0, 3.0}), Tuples.pair((Object)CoordinateReferenceSystem.Cartesian, (Object)new double[]{1.0, 2.0}), Tuples.pair((Object)CoordinateReferenceSystem.Cartesian_3D, (Object)new double[]{1.0, 2.0, 3.0})), AppendOnlyValuesContainerTest.testInput("PointArray", Values::pointArray, {Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{1.0, 2.0, 3.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 2.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 2.0, 3.0})}, new Point[0]), AppendOnlyValuesContainerTest.testInput("Duration", Values::durationValue, Duration.parse("P2DT3H4M"), Period.parse("P1Y2M3W4D")), AppendOnlyValuesContainerTest.testInput("DurationArray", Values::durationArray, {Duration.parse("P2DT3H4M"), Period.parse("P1Y2M3W4D")}, new TemporalAmount[0]), AppendOnlyValuesContainerTest.testInput("Date", DateValue::date, LocalDate.now(), LocalDate.parse("1977-05-25")), AppendOnlyValuesContainerTest.testInput("DateArray", Values::dateArray, {LocalDate.now(), LocalDate.parse("1977-05-25")}, new LocalDate[0]), AppendOnlyValuesContainerTest.testInput("Time", TimeValue::time, OffsetTime.now(), OffsetTime.parse("19:28:34.123+02:00")), AppendOnlyValuesContainerTest.testInput("TimeArray", Values::timeArray, {OffsetTime.now(), OffsetTime.parse("19:28:34.123+02:00")}, new OffsetTime[0]), AppendOnlyValuesContainerTest.testInput("LocalTime", LocalTimeValue::localTime, LocalTime.now(), LocalTime.parse("19:28:34.123")), AppendOnlyValuesContainerTest.testInput("LocalTimeArray", Values::localTimeArray, {LocalTime.now(), LocalTime.parse("19:28:34.123")}, new LocalTime[0]), AppendOnlyValuesContainerTest.testInput("LocalDateTime", LocalDateTimeValue::localDateTime, LocalDateTime.now(), LocalDateTime.parse("1956-10-04T19:28:34.123")), AppendOnlyValuesContainerTest.testInput("LocalDateTimeArray", Values::localDateTimeArray, {LocalDateTime.now(), LocalDateTime.parse("1956-10-04T19:28:34.123")}, new LocalDateTime[0]), AppendOnlyValuesContainerTest.testInput("DateTime", DateTimeValue::datetime, ZonedDateTime.now(), ZonedDateTime.parse("1956-10-04T19:28:34.123+01:00[Europe/Paris]"), ZonedDateTime.parse("1956-10-04T19:28:34.123+01:15"), ZonedDateTime.parse("2018-09-13T16:12:16.12345+14:00[Pacific/Kiritimati]"), ZonedDateTime.parse("2018-09-13T16:12:16.12345-12:00[Etc/GMT+12]"), ZonedDateTime.parse("2018-09-13T16:12:16.12345-18:00"), ZonedDateTime.parse("2018-09-13T16:12:16.12345+18:00")), AppendOnlyValuesContainerTest.testInput("DateTimeArray", Values::dateTimeArray, {ZonedDateTime.parse("1956-10-04T19:28:34.123+01:00[Europe/Paris]"), ZonedDateTime.parse("1956-10-04T19:28:34.123+01:15"), ZonedDateTime.parse("2018-09-13T16:12:16.12345+14:00[Pacific/Kiritimati]"), ZonedDateTime.parse("2018-09-13T16:12:16.12345-12:00[Etc/GMT+12]"), ZonedDateTime.parse("2018-09-13T16:12:16.12345-18:00"), ZonedDateTime.parse("2018-09-13T16:12:16.12345+18:00")}, new ZonedDateTime[0]));
        return DynamicTest.stream(inputs.iterator(), Pair::getOne, pair -> {
            Value[] values = (Value[])pair.getTwo();
            long[] refs = Arrays.stream(values).mapToLong(arg_0 -> ((AppendOnlyValuesContainer)this.container).add(arg_0)).toArray();
            for (int i = 0; i < values.length; ++i) {
                Assertions.assertEquals((Object)values[i], (Object)this.container.get(refs[i]));
            }
        });
    }

    private static <T> Pair<String, Value[]> testInput(String name, Function<T, Value> ctor, T ... values) {
        return Tuples.pair((Object)name, (Object)((Value[])Arrays.stream(values).map(ctor).toArray(Value[]::new)));
    }

    @Test
    void getFailsOnInvalidRef() {
        long ref = this.container.add((Value)Values.intValue((int)42));
        this.container.get(ref);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.container.get(128L), (String)"invalid chunk offset");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.container.get(0x100000000L), (String)"invalid chunk index");
    }

    @Test
    void remove() {
        long ref = this.container.add((Value)Values.intValue((int)42));
        this.container.remove(ref);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.container.get(ref));
    }

    @Test
    void valueSizeExceedsChunkSize() {
        AppendOnlyValuesContainer container2 = new AppendOnlyValuesContainer(4, (MemoryAllocator)new TestMemoryAllocator(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long ref1 = container2.add((Value)Values.longValue((long)42L));
        long ref2 = container2.add((Value)Values.stringValue((String)"1234567890ABCDEF"));
        Assertions.assertEquals((Object)Values.longValue((long)42L), (Object)container2.get(ref1));
        Assertions.assertEquals((Object)Values.stringValue((String)"1234567890ABCDEF"), (Object)container2.get(ref2));
        container2.close();
    }

    @Test
    void close() {
        AppendOnlyValuesContainer container2 = new AppendOnlyValuesContainer(4, (MemoryAllocator)new TestMemoryAllocator(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long ref = container2.add((Value)Values.intValue((int)42));
        container2.close();
        Assertions.assertThrows(IllegalStateException.class, () -> container2.add((Value)Values.intValue((int)1)));
        Assertions.assertThrows(IllegalStateException.class, () -> container2.get(ref));
        Assertions.assertThrows(IllegalStateException.class, () -> container2.remove(ref));
        Assertions.assertThrows(IllegalStateException.class, () -> ((AppendOnlyValuesContainer)container2).close());
    }

    @Test
    void randomizedTest() {
        int count = 10000 + this.rnd.nextInt(1000);
        ArrayList<ObjectLongPair> valueRefPairs = new ArrayList<ObjectLongPair>();
        FastList toRemove = new FastList();
        for (int i = 0; i < count; ++i) {
            Value value = this.rnd.randomValues().nextValue();
            long ref = this.container.add(value);
            ObjectLongPair pair = PrimitiveTuples.pair((Object)value, (long)ref);
            if (this.rnd.nextBoolean()) {
                toRemove.add((Object)pair);
                continue;
            }
            valueRefPairs.add(pair);
        }
        toRemove.shuffleThis(this.rnd.random());
        for (ObjectLongPair valueRefPair : toRemove) {
            Value removed = this.container.remove(valueRefPair.getTwo());
            Assertions.assertEquals((Object)valueRefPair.getOne(), (Object)removed);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.container.remove(valueRefPair.getTwo()));
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.container.get(valueRefPair.getTwo()));
        }
        for (ObjectLongPair valueRefPair : valueRefPairs) {
            Value actualValue = this.container.get(valueRefPair.getTwo());
            Assertions.assertEquals((Object)valueRefPair.getOne(), (Object)actualValue);
        }
    }
}

