/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.concurrent.Callable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
public abstract class IndexTestUtil<KEY, VALUE, LAYOUT extends Layout<KEY, VALUE>> {
    static final long NON_EXISTENT_ENTITY_ID = 1000000000L;
    @RegisterExtension
    static PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    protected DefaultFileSystemAbstraction fs;
    @Inject
    protected TestDirectory directory;
    @Inject
    protected PageCache pageCache;
    @Inject
    protected RandomSupport random;
    IndexDescriptor indexDescriptor;
    LAYOUT layout;
    IndexFiles indexFiles;
    JobScheduler jobScheduler;
    IndexPopulator.PopulationWorkScheduler populationWorkScheduler;
    TokenNameLookup tokenNameLookup;

    @BeforeEach
    void setup() {
        this.indexDescriptor = this.indexDescriptor();
        this.layout = this.layout();
        this.indexFiles = this.createIndexFiles((FileSystemAbstraction)this.fs, this.directory, this.indexDescriptor);
        this.indexFiles.ensureDirectoryExist();
        this.tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return IndexTestUtil.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.shutdown();
    }

    abstract IndexFiles createIndexFiles(FileSystemAbstraction var1, TestDirectory var2, IndexDescriptor var3);

    abstract IndexDescriptor indexDescriptor();

    abstract LAYOUT layout();

    GBPTree<KEY, VALUE> getTree() {
        return new GBPTreeBuilder(this.pageCache, this.indexFiles.getStoreFile(), this.layout).build();
    }

    void assertFilePresent() {
        Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getStoreFile()));
    }

    void assertFileNotPresent() {
        Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getStoreFile()));
    }

    void setSeed(long seed) {
        this.random.setSeed(seed);
        this.random.reset();
    }
}

