/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeValueIndexUtility;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class NativeIndexAccessorTests<KEY extends NativeIndexKey<KEY>>
extends IndexAccessorTests<KEY, NullValue, IndexLayout<KEY>> {
    NativeValueIndexUtility<KEY> valueUtil;
    ValueCreatorUtil<KEY> valueCreatorUtil;

    NativeIndexAccessorTests() {
    }

    @BeforeEach
    void setupValueUtil() {
        this.valueCreatorUtil = this.createValueCreatorUtil();
        this.valueUtil = new NativeValueIndexUtility<KEY>(this.valueCreatorUtil, this.layout);
    }

    @Override
    IndexFiles createIndexFiles(FileSystemAbstraction fs, TestDirectory directory, IndexDescriptor indexDescriptor) {
        IndexDirectoryStructure indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)directory.directory("root")).forProvider(indexDescriptor.getIndexProvider());
        return new IndexFiles.Directory(fs, indexDirectoryStructure, indexDescriptor.getId());
    }

    abstract ValueCreatorUtil<KEY> createValueCreatorUtil();

    abstract boolean supportsGeometryRangeQueries();

    @Test
    void processMustThrowAfterClose() throws Exception {
        IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
        updater.close();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> updater.process(this.simpleUpdate()));
    }

    @Test
    void shouldIndexAdd() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            NativeIndexAccessorTests.processAll(updater, updates);
        }
        this.forceAndCloseAccessor();
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void shouldIndexChange() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        Iterator generator = Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random));
        for (int i = 0; i < updates.length; ++i) {
            ValueIndexEntryUpdate<IndexDescriptor> update = updates[i];
            Value newValue = ((ValueIndexEntryUpdate)generator.next()).values()[0];
            updates[i] = IndexEntryUpdate.change((long)update.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value)update.values()[0], (Value)newValue);
        }
        this.processAll(updates);
        this.forceAndCloseAccessor();
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void shouldIndexRemove() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        for (int i = 0; i < updates.length; ++i) {
            ValueIndexEntryUpdate<IndexDescriptor> update = updates[i];
            ValueIndexEntryUpdate remove = IndexEntryUpdate.remove((long)update.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])update.values());
            this.processAll(remove);
            this.forceAndCloseAccessor();
            this.valueUtil.verifyUpdates(Arrays.copyOfRange(updates, i + 1, updates.length), this::getTree);
            this.setupAccessor();
        }
    }

    @Test
    void shouldHandleRandomUpdates() throws Exception {
        HashSet<ValueIndexEntryUpdate<IndexDescriptor>> expectedData = new HashSet<ValueIndexEntryUpdate<IndexDescriptor>>();
        Iterator<ValueIndexEntryUpdate<IndexDescriptor>> newDataGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        int rounds = 50;
        for (int round = 0; round < rounds; ++round) {
            ValueIndexEntryUpdate<IndexDescriptor>[] batch = this.generateRandomUpdates(expectedData, newDataGenerator, this.random.nextInt(5, 20), (float)round / (float)rounds * 2.0f);
            this.processAll(batch);
            this.applyUpdatesToExpectedData(expectedData, batch);
            this.forceAndCloseAccessor();
            this.valueUtil.verifyUpdates(expectedData.toArray(new ValueIndexEntryUpdate[0]), this::getTree);
            this.setupAccessor();
        }
    }

    @Test
    void tokenReaderShouldThrow() {
        Assertions.assertThatThrownBy(() -> ((IndexAccessor)this.accessor).newTokenReader()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void readingAfterDropShouldThrow() {
        this.accessor.drop();
        Assertions.assertThatThrownBy(() -> this.accessor.newValueReader()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void readingAfterCloseShouldThrow() {
        this.accessor.close();
        Assertions.assertThatThrownBy(() -> this.accessor.newValueReader()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void shouldReturnZeroCountForEmptyIndex() {
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            ValueIndexEntryUpdate<IndexDescriptor> update = this.valueCreatorUtil.randomUpdateGenerator(this.random).next();
            long count = reader.countIndexedEntities(123L, CursorContext.NULL, this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds(), new Value[]{update.values()[0]});
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    void shouldReturnCountOneForExistingData() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
                long count = reader.countIndexedEntities(update.getEntityId(), CursorContext.NULL, this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds(), update.values());
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)count);
            }
            Iterator generator = Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random));
            long count = reader.countIndexedEntities(123L, CursorContext.NULL, this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds(), new Value[]{((ValueIndexEntryUpdate)generator.next()).values()[0]});
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    void shouldReturnCountZeroForMismatchingData() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates();
        this.processAll(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
            int[] propKeys = this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds();
            long countWithMismatchingData = reader.countIndexedEntities(update.getEntityId() + 1L, CursorContext.NULL, propKeys, update.values());
            long countWithNonExistentEntityId = reader.countIndexedEntities(1000000000L, CursorContext.NULL, propKeys, update.values());
            long countWithNonExistentValue = reader.countIndexedEntities(update.getEntityId(), CursorContext.NULL, propKeys, new Value[]{this.generateUniqueValue(updates)});
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)countWithMismatchingData);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)countWithNonExistentEntityId);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)countWithNonExistentValue);
        }
    }

    @Test
    void shouldReturnAllEntriesForAllEntriesPredicate() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        long[] expectedIds = Stream.of(updates).mapToLong(IndexEntryUpdate::getEntityId).toArray();
        try (ValueIndexReader reader = this.accessor.newValueReader();
             NodeValueIterator result = NativeIndexAccessorTests.query(reader, (PropertyIndexQuery)PropertyIndexQuery.allEntries());){
            NativeIndexAccessorTests.assertEntityIdHits(expectedIds, (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForExactPredicate() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
            Value value = update.values()[0];
            try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, (PropertyIndexQuery)PropertyIndexQuery.exact((int)0, (Object)value));){
                NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(updates, Predicates.in((Object[])new Value[]{value})), (LongIterator)result);
            }
        }
    }

    @Test
    void shouldReturnNoEntriesForMismatchingExactPredicate() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        Value value = this.generateUniqueValue(updates);
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, (PropertyIndexQuery)PropertyIndexQuery.exact((int)0, (Object)value));){
            NativeIndexAccessorTests.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, (LongIterator)result);
        }
    }

    @Test
    void shouldHandleMultipleConsecutiveUpdaters() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates;
        for (ValueIndexEntryUpdate<IndexDescriptor> update : updates = this.someUpdatesSingleType()) {
            try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                updater.process(update);
            }
        }
        this.forceAndCloseAccessor();
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void forceShouldCheckpointTree() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] data = this.someUpdatesSingleType();
        this.processAll(data);
        this.accessor.force(CursorContext.NULL);
        this.accessor.close();
        this.valueUtil.verifyUpdates(data, this::getTree);
    }

    @Test
    void closeShouldCloseTreeWithoutCheckpoint() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] data = this.someUpdatesSingleType();
        this.processAll(data);
        this.accessor.close();
        this.valueUtil.verifyUpdates(new ValueIndexEntryUpdate[0], this::getTree);
    }

    @Test
    void shouldSampleIndex() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        try (ValueIndexReader reader = this.accessor.newValueReader();
             IndexSampler sampler = reader.createSampler();){
            IndexSample sample = sampler.sampleIndex(CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertEquals((long)updates.length, (long)sample.indexSize());
            org.junit.jupiter.api.Assertions.assertEquals((long)updates.length, (long)sample.sampleSize());
            org.junit.jupiter.api.Assertions.assertEquals((long)ValueCreatorUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        }
    }

    @Test
    void shouldSeeAllEntriesInAllEntriesReader() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesValueReader(CursorContext.NULL));
        Set expectedIds = Stream.of(updates).map(IndexEntryUpdate::getEntityId).collect(Collectors.toCollection(HashSet::new));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedIds, (Object)ids);
    }

    @Test
    void shouldSeeNoEntriesInAllEntriesReaderOnEmptyIndex() {
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesValueReader(CursorContext.NULL));
        Set expectedIds = Collections.emptySet();
        org.junit.jupiter.api.Assertions.assertEquals(expectedIds, (Object)ids);
    }

    @Test
    void getValues() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        List expectedValues;
        PropertyIndexQuery.RangePredicate supportedQuery;
        Value value;
        int nUpdates = 10000;
        Iterator<ValueIndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        ValueIndexEntryUpdate[] someUpdates = new ValueIndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Object[] allValues = ValueCreatorUtil.extractValuesFromUpdates(someUpdates);
        while (Values.isGeometryValue((Value)(value = (Value)this.random.among(allValues))) && !this.supportsGeometryRangeQueries()) {
        }
        ValueGroup valueGroup = value.valueGroup();
        if (Values.isGeometryValue((Value)value)) {
            CoordinateReferenceSystem crs = ((PointValue)value).getCoordinateReferenceSystem();
            supportedQuery = PropertyIndexQuery.range((int)0, (CoordinateReferenceSystem)crs);
            expectedValues = Arrays.stream(allValues).filter(v -> v.valueGroup() == ValueGroup.GEOMETRY).filter(v -> ((PointValue)v).getCoordinateReferenceSystem() == crs).collect(Collectors.toList());
        } else {
            supportedQuery = PropertyIndexQuery.range((int)0, (ValueGroup)valueGroup);
            expectedValues = Arrays.stream(allValues).filter(v -> v.valueGroup() == valueGroup).collect(Collectors.toList());
        }
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            SimpleEntityValueClient client = new SimpleEntityValueClient();
            reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{supportedQuery});
            while (client.next()) {
                Value foundValue = client.values[0];
                org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedValues.remove(foundValue), (String)("found value that was not expected " + foundValue));
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)expectedValues.size()).as("did not find all expected values", new Object[0])).isEqualTo(0);
        }
    }

    @Test
    void dropShouldDeleteEntireIndexFolder() {
        this.assertFilePresent();
        this.accessor.drop();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getBase()));
    }

    private Value generateUniqueValue(ValueIndexEntryUpdate<IndexDescriptor>[] updates) {
        return ((ValueIndexEntryUpdate)Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random)).next()).values()[0];
    }

    private static Predicate<ValueIndexEntryUpdate<IndexDescriptor>> skipExisting(ValueIndexEntryUpdate<IndexDescriptor>[] existing) {
        return update -> {
            for (ValueIndexEntryUpdate e : existing) {
                if (!Arrays.equals(e.values(), update.values())) continue;
                return false;
            }
            return true;
        };
    }

    static NodeValueIterator query(ValueIndexReader reader, PropertyIndexQuery query) throws IndexNotApplicableKernelException {
        NodeValueIterator client = new NodeValueIterator();
        reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
        return client;
    }

    static void assertEntityIdHits(long[] expected, LongIterator result) {
        long[] actual = PrimitiveLongCollections.asArray((LongIterator)result);
        NativeIndexAccessorTests.assertSameContent(expected, actual);
    }

    static void assertSameContent(long[] expected, long[] actual) {
        Arrays.sort(actual);
        Arrays.sort(expected);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expected, (long[])actual, (String)String.format("Expected arrays to be equal but wasn't.%nexpected:%s%n  actual:%s%n", Arrays.toString(expected), Arrays.toString(actual)));
    }

    static long[] extractEntityIds(ValueIndexEntryUpdate<?>[] updates, Predicate<Value> valueFilter) {
        long[] entityIds = new long[updates.length];
        int cursor = 0;
        for (ValueIndexEntryUpdate<?> update : updates) {
            if (!valueFilter.test(update.values()[0])) continue;
            entityIds[cursor++] = update.getEntityId();
        }
        return Arrays.copyOf(entityIds, cursor);
    }

    private void applyUpdatesToExpectedData(Set<ValueIndexEntryUpdate<IndexDescriptor>> expectedData, ValueIndexEntryUpdate<IndexDescriptor>[] batch) {
        for (ValueIndexEntryUpdate<IndexDescriptor> update : batch) {
            ValueIndexEntryUpdate<IndexDescriptor> addition = null;
            ValueIndexEntryUpdate<IndexDescriptor> removal = null;
            switch (update.updateMode()) {
                case ADDED: {
                    addition = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                case CHANGED: {
                    addition = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    removal = this.valueCreatorUtil.add(update.getEntityId(), update.beforeValues()[0]);
                    break;
                }
                case REMOVED: {
                    removal = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(update.updateMode().name());
                }
            }
            if (removal != null) {
                expectedData.remove(removal);
            }
            if (addition == null) continue;
            expectedData.add(addition);
        }
    }

    private ValueIndexEntryUpdate<IndexDescriptor>[] generateRandomUpdates(Set<ValueIndexEntryUpdate<IndexDescriptor>> expectedData, Iterator<ValueIndexEntryUpdate<IndexDescriptor>> newDataGenerator, int count, float removeFactor) {
        ValueIndexEntryUpdate[] updates = new ValueIndexEntryUpdate[count];
        float addChangeRatio = 0.5f;
        for (int i = 0; i < count; ++i) {
            float factor = this.random.nextFloat();
            if (!expectedData.isEmpty() && factor < removeFactor) {
                ValueIndexEntryUpdate<IndexDescriptor> toRemove = this.selectRandomItem(expectedData);
                updates[i] = IndexEntryUpdate.remove((long)toRemove.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])toRemove.values());
                continue;
            }
            if (!expectedData.isEmpty() && factor < (1.0f - removeFactor) * addChangeRatio) {
                ValueIndexEntryUpdate<IndexDescriptor> toChange = this.selectRandomItem(expectedData);
                ValueIndexEntryUpdate<IndexDescriptor> updateContainingValue = newDataGenerator.next();
                updates[i] = IndexEntryUpdate.change((long)toChange.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])toChange.values(), (Value[])updateContainingValue.values());
                continue;
            }
            updates[i] = newDataGenerator.next();
        }
        return updates;
    }

    private ValueIndexEntryUpdate<IndexDescriptor> selectRandomItem(Set<ValueIndexEntryUpdate<IndexDescriptor>> expectedData) {
        return expectedData.toArray(new ValueIndexEntryUpdate[0])[this.random.nextInt(expectedData.size())];
    }

    @SafeVarargs
    final void processAll(ValueIndexEntryUpdate<IndexDescriptor> ... updates) throws IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
    }

    private void forceAndCloseAccessor() {
        this.accessor.force(CursorContext.NULL);
        this.closeAccessor();
    }

    private static void processAll(IndexUpdater updater, ValueIndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException {
        for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
    }

    private ValueIndexEntryUpdate<IndexDescriptor> simpleUpdate() {
        return ValueIndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)0)});
    }

    ValueIndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleType() {
        ValueType type = (ValueType)this.random.randomValues().among((Object[])this.valueCreatorUtil.supportedTypes());
        return this.valueCreatorUtil.someUpdates(this.random, new ValueType[]{type}, true);
    }

    private ValueIndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleTypeNoDuplicates() {
        return this.someUpdatesSingleTypeNoDuplicates(this.valueCreatorUtil.supportedTypes());
    }

    ValueIndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleTypeNoDuplicates(ValueType ... types) {
        ValueType type;
        while ((type = (ValueType)this.random.randomValues().among((Object[])types)) == ValueType.BOOLEAN) {
        }
        return this.valueCreatorUtil.someUpdates(this.random, new ValueType[]{type}, false);
    }
}

