/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.time.Clocks;

class ForsetiMemoryTrackingTest {
    private static final AtomicLong TRANSACTION_ID = new AtomicLong();
    private static final int ONE_LOCK_SIZE_ESTIMATE = 56;
    private GlobalMemoryGroupTracker memoryPool;
    private MemoryTracker memoryTracker;
    private ForsetiLockManager forsetiLockManager;

    ForsetiMemoryTrackingTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker((MemoryPool)this.memoryPool);
        this.forsetiLockManager = new ForsetiLockManager(Config.defaults(), Clocks.nanoClock(), (ResourceType[])ResourceTypes.values());
    }

    @AfterEach
    void tearDown() {
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
        this.memoryTracker.close();
        Assertions.assertThat((long)this.memoryPool.getPoolMemoryTracker().estimatedHeapMemory()).isEqualTo(0L);
    }

    @Test
    void trackMemoryOnSharedLockAcquire() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)twoLocksAllocatedMemory).isGreaterThan(0L).isEqualTo(oneLockAllocatedMemory + 56L);
        }
    }

    @Test
    void trackMemoryOnExclusiveLockAcquire() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)twoLocksAllocatedMemory).isGreaterThan(0L).isEqualTo(oneLockAllocatedMemory + 56L);
        }
    }

    @Test
    void sharedLockReAcquireDoesNotAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            org.junit.jupiter.api.Assertions.assertEquals((long)oneLockAllocatedMemory, (long)twoLocksAllocatedMemory);
        }
    }

    @Test
    void exclusiveLockReAcquireDoesNotAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            org.junit.jupiter.api.Assertions.assertEquals((long)oneLockAllocatedMemory, (long)twoLocksAllocatedMemory);
        }
    }

    @Test
    void exclusiveLockOverSharedDoesNotAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long sharedAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)sharedAllocatedMemory).isGreaterThan(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            org.junit.jupiter.api.Assertions.assertEquals((long)sharedAllocatedMemory, (long)twoLocksAllocatedMemory);
        }
    }

    @Test
    void sharedLockOverExclusiveAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long exclusiveAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)exclusiveAllocatedMemory).isGreaterThan(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)twoLocksAllocatedMemory).isGreaterThan(exclusiveAllocatedMemory);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long threeLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)threeLocksAllocatedMemory).isEqualTo(twoLocksAllocatedMemory);
        }
    }

    @Test
    void releaseMemoryOfSharedLock() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long sharedAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)sharedAllocatedMemory).isGreaterThan(0L);
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noLocksClientMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noLocksClientMemory).isGreaterThan(0L).isEqualTo(sharedAllocatedMemory - 56L);
        }
    }

    @Test
    void releaseMemoryOfExclusiveLock() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long exclusiveAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)exclusiveAllocatedMemory).isGreaterThan(0L);
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noLocksClientMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noLocksClientMemory).isGreaterThan(0L).isEqualTo(exclusiveAllocatedMemory - 56L);
        }
    }

    @Test
    void releaseExclusiveLockWhyHoldingSharedDoNotReleaseAnyMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long locksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)locksMemory).isGreaterThan(0L);
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noExclusiveLockMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noExclusiveLockMemory).isGreaterThan(0L).isEqualTo(locksMemory);
        }
    }

    @Test
    void releaseLocksReleasingMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noLocksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noLocksMemory).isGreaterThan(0L);
            int lockNumber = 10;
            for (int i = 0; i < lockNumber; ++i) {
                client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{i});
            }
            long exclusiveLocksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)exclusiveLocksMemory).isEqualTo(noLocksMemory + (long)(lockNumber * 56));
            for (int i = 0; i < lockNumber; ++i) {
                client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{i});
            }
            long sharedLocksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)sharedLocksMemory).isEqualTo(exclusiveLocksMemory);
            for (int i = 0; i < lockNumber; ++i) {
                client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{i});
                client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{i});
            }
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(noLocksMemory);
        }
    }

    @Test
    void trackMemoryOnLocksAcquire() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isGreaterThan(0L);
        }
    }

    @Test
    void releaseMemoryOnUnlock() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            long lockedSize = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)lockedSize).isGreaterThan(0L);
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{2L});
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isLessThan(lockedSize);
        }
    }

    @Test
    void upgradingLockShouldNotLeakMemory() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
    }

    @Test
    void closeShouldReleaseAllMemory() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
    }

    @Test
    void concurrentMemoryShouldEndUpZero() throws Throwable {
        int i;
        Race race = new Race();
        int numThreads = 4;
        LocalMemoryTracker[] trackers = new LocalMemoryTracker[numThreads];
        for (i = 0; i < numThreads; ++i) {
            trackers[i] = new LocalMemoryTracker((MemoryPool)this.memoryPool);
            Locks.Client client = this.forsetiLockManager.newClient();
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, (long)i, (MemoryTracker)trackers[i], Config.defaults());
            race.addContestant((Runnable)new SimulatedTransaction(client));
        }
        race.go();
        for (i = 0; i < numThreads; ++i) {
            try (LocalMemoryTracker tracker = trackers[i];){
                ((AbstractLongAssert)Assertions.assertThat((long)tracker.estimatedHeapMemory()).describedAs("Tracker " + tracker, new Object[0])).isGreaterThanOrEqualTo(0L);
                continue;
            }
        }
    }

    private Locks.Client getClient() {
        Locks.Client client = this.forsetiLockManager.newClient();
        client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, TRANSACTION_ID.getAndIncrement(), this.memoryTracker, Config.defaults());
        return client;
    }

    private static class SimulatedTransaction
    implements Runnable {
        private final Deque<LockEvent> heldLocks = new ArrayDeque<LockEvent>();
        private final Locks.Client client;

        SimulatedTransaction(Locks.Client client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            try {
                for (int i = 0; i < 100; ++i) {
                    if (this.heldLocks.isEmpty() || (double)random.nextFloat() > 0.33) {
                        int nodeId = random.nextInt(10);
                        if (random.nextBoolean()) {
                            if (random.nextBoolean()) {
                                this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
                                this.heldLocks.push(new LockEvent(true, nodeId));
                                continue;
                            }
                            if (!this.client.tryExclusiveLock((ResourceType)ResourceTypes.NODE, (long)nodeId)) continue;
                            this.heldLocks.push(new LockEvent(true, nodeId));
                            continue;
                        }
                        if (random.nextBoolean()) {
                            this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
                            this.heldLocks.push(new LockEvent(false, nodeId));
                            continue;
                        }
                        if (!this.client.trySharedLock((ResourceType)ResourceTypes.NODE, (long)nodeId)) continue;
                        this.heldLocks.push(new LockEvent(false, nodeId));
                        continue;
                    }
                    LockEvent pop = this.heldLocks.pop();
                    if (pop.isExclusive) {
                        this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{pop.nodeId});
                        continue;
                    }
                    this.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{pop.nodeId});
                }
            }
            catch (DeadlockDetectedException deadlockDetectedException) {
            }
            finally {
                this.client.close();
            }
        }

        private static class LockEvent {
            final boolean isExclusive;
            final long nodeId;

            LockEvent(boolean isExclusive, long nodeId) {
                this.isExclusive = isExclusive;
                this.nodeId = nodeId;
            }
        }
    }
}

