/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.impl.newapi.PrimitiveSortedMergeJoin;

class PrimitiveSortedMergeJoinTest {
    PrimitiveSortedMergeJoinTest() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithEmptyLists(IndexOrder indexOrder) {
        PrimitiveSortedMergeJoinTest.assertThatItWorksOneWay(Collections.emptyList(), Collections.emptyList(), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithAList(IndexOrder indexOrder) {
        PrimitiveSortedMergeJoinTest.assertThatItWorks(Arrays.asList(1L, 3L, 5L, 7L), Collections.emptyList(), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWith2Lists(IndexOrder indexOrder) {
        PrimitiveSortedMergeJoinTest.assertThatItWorks(Arrays.asList(1L, 3L, 5L, 7L), Arrays.asList(2L, 4L, 6L, 8L), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithSameElements(IndexOrder indexOrder) {
        PrimitiveSortedMergeJoinTest.assertThatItWorks(Arrays.asList(1L, 3L, 5L), Arrays.asList(2L, 3L, 6L), indexOrder);
    }

    private static void assertThatItWorks(List<Long> listA, List<Long> listB, IndexOrder indexOrder) {
        PrimitiveSortedMergeJoinTest.assertThatItWorksOneWay(listA, listB, indexOrder);
        PrimitiveSortedMergeJoinTest.assertThatItWorksOneWay(listB, listA, indexOrder);
    }

    private static void assertThatItWorksOneWay(List<Long> listA, List<Long> listB, IndexOrder indexOrder) {
        PrimitiveSortedMergeJoin sortedMergeJoin = new PrimitiveSortedMergeJoin();
        sortedMergeJoin.initialize(indexOrder);
        Comparator comparator = indexOrder == IndexOrder.ASCENDING ? Comparator.naturalOrder() : Comparator.reverseOrder();
        listA.sort(comparator);
        listB.sort(comparator);
        List<Long> result = PrimitiveSortedMergeJoinTest.process(sortedMergeJoin, listA.iterator(), listB.iterator());
        ArrayList<Long> expected = new ArrayList<Long>();
        expected.addAll(listA);
        expected.addAll(listB);
        expected.sort(comparator);
        Assertions.assertThat(result).isEqualTo(expected);
    }

    private static List<Long> process(PrimitiveSortedMergeJoin sortedMergeJoin, Iterator<Long> iteratorA, Iterator<Long> iteratorB) {
        ArrayList<Long> result = new ArrayList<Long>();
        long node = 0L;
        while (node != -1L) {
            if (iteratorA.hasNext() && sortedMergeJoin.needsA()) {
                long a = iteratorA.next();
                sortedMergeJoin.setA(a);
            }
            if (iteratorB.hasNext() && sortedMergeJoin.needsB()) {
                long b = iteratorB.next();
                sortedMergeJoin.setB(b);
            }
            if ((node = sortedMergeJoin.next()) == -1L) continue;
            result.add(node);
        }
        return result;
    }
}

