/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.DistinctSet;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;

class DistinctSetTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final DistinctSet<LongValue> distinctSet = DistinctSet.createDistinctSet((MemoryTracker)this.memoryTracker);

    DistinctSetTest() {
    }

    @AfterEach
    void tearDown() {
        this.distinctSet.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void emptySize() {
        long actual = this.meter.measureDeep(this.distinctSet) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actual, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void countInternalStructure() {
        boolean added1 = this.distinctSet.add((Measurable)Values.longValue((long)0L));
        boolean added2 = this.distinctSet.add((Measurable)Values.longValue((long)0L));
        boolean added3 = this.distinctSet.add((Measurable)Values.longValue((long)1L));
        long actualSize = this.meter.measureDeep(this.distinctSet) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actualSize, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertTrue((boolean)added1);
        Assertions.assertFalse((boolean)added2);
        Assertions.assertTrue((boolean)added3);
    }

    @Test
    void closeShouldReleaseEverything() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        this.distinctSet.add((Measurable)Values.longValue((long)0L));
        this.distinctSet.add((Measurable)Values.longValue((long)0L));
        this.distinctSet.add((Measurable)Values.longValue((long)1L));
        long actualSize = this.meter.measureDeep(this.distinctSet) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)(actualSize + externalAllocation), (long)this.memoryTracker.estimatedHeapMemory());
        this.distinctSet.close();
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }
}

