/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseIdRepository
implements DatabaseIdRepository.Caching {
    private static final Optional<NamedDatabaseId> OPT_SYS_DB = Optional.of(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
    private final DatabaseIdRepository delegate;
    private volatile Map<String, NamedDatabaseId> databaseIdsByName;
    private volatile Map<DatabaseId, NamedDatabaseId> databaseIdsByUuid;

    public MapCachingDatabaseIdRepository(DatabaseIdRepository delegate) {
        this.delegate = delegate;
        this.databaseIdsByName = new ConcurrentHashMap<String, NamedDatabaseId>();
        this.databaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
        if (NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.name().equals(databaseName.name())) {
            return OPT_SYS_DB;
        }
        Optional<NamedDatabaseId> dbId = Optional.ofNullable(this.databaseIdsByName.computeIfAbsent(databaseName.name(), name -> this.delegate.getByName(name).orElse(null)));
        dbId.ifPresent(id -> this.databaseIdsByUuid.put(id.databaseId(), (NamedDatabaseId)id));
        return dbId;
    }

    public Optional<NamedDatabaseId> getById(DatabaseId uuid) {
        if (NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.databaseId().equals((Object)uuid)) {
            return OPT_SYS_DB;
        }
        Optional<NamedDatabaseId> dbId = Optional.ofNullable(this.databaseIdsByUuid.computeIfAbsent(uuid, id -> this.delegate.getById(id).orElse(null)));
        dbId.ifPresent(id -> this.databaseIdsByName.put(id.name(), (NamedDatabaseId)id));
        return dbId;
    }

    public Map<NormalizedDatabaseName, NamedDatabaseId> getAllDatabaseAliases() {
        return this.delegate.getAllDatabaseAliases();
    }

    public Set<NamedDatabaseId> getAllDatabaseIds() {
        return this.delegate.getAllDatabaseIds();
    }

    public void invalidateAll() {
        this.databaseIdsByName = new ConcurrentHashMap<String, NamedDatabaseId>();
        this.databaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
    }
}

