/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class TracerCompatibility
extends LockCompatibilityTestSupport {
    TracerCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void shouldTraceWaitTimeWhenTryingToAcquireExclusiveLockAndExclusiveIsHeld() throws Exception {
        Tracer tracerA = new Tracer();
        Tracer tracerB = new Tracer();
        this.clientA.acquireExclusive((LockTracer)tracerA, (ResourceType)ResourceTypes.NODE, new long[]{17L});
        Future<Void> future = this.acquireExclusive(this.clientB, tracerB, (ResourceType)ResourceTypes.NODE, 17L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{17L});
        future.get();
        tracerA.assertCalls(0);
        tracerB.assertCalls(1);
    }

    @Test
    void shouldTraceWaitTimeWhenTryingToAcquireSharedLockAndExclusiveIsHeld() throws Exception {
        Tracer tracerA = new Tracer();
        Tracer tracerB = new Tracer();
        this.clientA.acquireExclusive((LockTracer)tracerA, (ResourceType)ResourceTypes.NODE, new long[]{17L});
        Future<Void> future = this.acquireShared(this.clientB, tracerB, (ResourceType)ResourceTypes.NODE, 17L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{17L});
        future.get();
        tracerA.assertCalls(0);
        tracerB.assertCalls(1);
    }

    @Test
    void shouldTraceWaitTimeWhenTryingToAcquireExclusiveLockAndSharedIsHeld() throws Exception {
        Tracer tracerA = new Tracer();
        Tracer tracerB = new Tracer();
        this.clientA.acquireShared((LockTracer)tracerA, (ResourceType)ResourceTypes.NODE, new long[]{17L});
        Future<Void> future = this.acquireExclusive(this.clientB, tracerB, (ResourceType)ResourceTypes.NODE, 17L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{17L});
        future.get();
        tracerA.assertCalls(0);
        tracerB.assertCalls(1);
    }

    static class Tracer
    implements LockTracer,
    LockWaitEvent {
        int done;
        final List<StackTraceElement[]> waitCalls = new ArrayList<StackTraceElement[]>();

        Tracer() {
        }

        public LockWaitEvent waitForLock(LockType lockType, ResourceType resourceType, long transactionId, long ... resourceIds) {
            this.waitCalls.add(Thread.currentThread().getStackTrace());
            return this;
        }

        public void close() {
            ++this.done;
        }

        void assertCalls(int expected) {
            if (this.waitCalls.size() != this.done) {
                throw this.withCallTraces(new AssertionError((Object)"Should complete waiting as many times as started."));
            }
            if (this.done != expected) {
                throw this.withCallTraces(new AssertionError((Object)String.format("Expected %d calls, but got %d", expected, this.done)));
            }
        }

        private <EX extends Throwable> EX withCallTraces(EX failure) {
            for (StackTraceElement[] waitCall : this.waitCalls) {
                RuntimeException call = new RuntimeException("Wait called");
                call.setStackTrace(waitCall);
                failure.addSuppressed(call);
            }
            return failure;
        }
    }
}

