/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.time.Clocks;

@ExtendWith(value={RandomExtension.class})
class ForsetiMemoryTrackingTest {
    @Inject
    private RandomSupport random;
    private static final AtomicLong TRANSACTION_ID = new AtomicLong();
    private static final int ONE_LOCK_SIZE_ESTIMATE = 56;
    private GlobalMemoryGroupTracker memoryPool;
    private MemoryTracker memoryTracker;
    private ForsetiLockManager forsetiLockManager;

    ForsetiMemoryTrackingTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker((MemoryPool)this.memoryPool);
        this.forsetiLockManager = new ForsetiLockManager(Config.defaults(), Clocks.nanoClock(), (ResourceType[])ResourceTypes.values());
    }

    @AfterEach
    void tearDown() {
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
        this.memoryTracker.close();
        Assertions.assertThat((long)this.memoryPool.getPoolMemoryTracker().estimatedHeapMemory()).isEqualTo(0L);
    }

    @Test
    void trackMemoryOnSharedLockAcquire() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)twoLocksAllocatedMemory).isGreaterThan(0L).isEqualTo(oneLockAllocatedMemory + 56L);
        }
    }

    @Test
    void trackMemoryOnExclusiveLockAcquire() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)twoLocksAllocatedMemory).isGreaterThan(0L).isEqualTo(oneLockAllocatedMemory + 56L);
        }
    }

    @Test
    void sharedLockReAcquireDoesNotAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            org.junit.jupiter.api.Assertions.assertEquals((long)oneLockAllocatedMemory, (long)twoLocksAllocatedMemory);
        }
    }

    @Test
    void exclusiveLockReAcquireDoesNotAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long oneLockAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)oneLockAllocatedMemory).isGreaterThan(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            org.junit.jupiter.api.Assertions.assertEquals((long)oneLockAllocatedMemory, (long)twoLocksAllocatedMemory);
        }
    }

    @Test
    void exclusiveLockOverSharedDoesNotAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long sharedAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)sharedAllocatedMemory).isGreaterThan(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            org.junit.jupiter.api.Assertions.assertEquals((long)sharedAllocatedMemory, (long)twoLocksAllocatedMemory);
        }
    }

    @Test
    void sharedLockOverExclusiveAllocateMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long exclusiveAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)exclusiveAllocatedMemory).isGreaterThan(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long twoLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)twoLocksAllocatedMemory).isGreaterThan(exclusiveAllocatedMemory);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long threeLocksAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)threeLocksAllocatedMemory).isEqualTo(twoLocksAllocatedMemory);
        }
    }

    @Test
    void releaseMemoryOfSharedLock() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long sharedAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)sharedAllocatedMemory).isGreaterThan(0L);
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noLocksClientMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noLocksClientMemory).isGreaterThan(0L).isEqualTo(sharedAllocatedMemory - 56L);
        }
    }

    @Test
    void releaseMemoryOfExclusiveLock() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long exclusiveAllocatedMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)exclusiveAllocatedMemory).isGreaterThan(0L);
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noLocksClientMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noLocksClientMemory).isGreaterThan(0L).isEqualTo(exclusiveAllocatedMemory - 56L);
        }
    }

    @Test
    void releaseExclusiveLockWhyHoldingSharedDoNotReleaseAnyMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            long locksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)locksMemory).isGreaterThan(0L);
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noExclusiveLockMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noExclusiveLockMemory).isGreaterThan(0L).isEqualTo(locksMemory);
        }
    }

    @Test
    void releaseLocksReleasingMemory() {
        try (Locks.Client client = this.getClient();){
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            long noLocksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)noLocksMemory).isGreaterThan(0L);
            int lockNumber = 10;
            for (int i = 0; i < lockNumber; ++i) {
                client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{i});
            }
            long exclusiveLocksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)exclusiveLocksMemory).isEqualTo(noLocksMemory + (long)(lockNumber * 56));
            for (int i = 0; i < lockNumber; ++i) {
                client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{i});
            }
            long sharedLocksMemory = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)sharedLocksMemory).isEqualTo(exclusiveLocksMemory);
            for (int i = 0; i < lockNumber; ++i) {
                client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{i});
                client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{i});
            }
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(noLocksMemory);
        }
    }

    @Test
    void trackMemoryOnLocksAcquire() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isGreaterThan(0L);
        }
    }

    @Test
    void releaseMemoryOnUnlock() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
            long lockedSize = this.memoryTracker.estimatedHeapMemory();
            Assertions.assertThat((long)lockedSize).isGreaterThan(0L);
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{2L});
            Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isLessThan(lockedSize);
        }
    }

    @Test
    void upgradingLockShouldNotLeakMemory() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
    }

    @Test
    void closeShouldReleaseAllMemory() {
        try (Locks.Client client = this.getClient();){
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        }
    }

    @Test
    void concurrentMemoryShouldEndUpZero() throws Throwable {
        int i;
        Race race = new Race();
        int numThreads = 4;
        LocalMemoryTracker[] trackers = new LocalMemoryTracker[numThreads];
        for (i = 0; i < numThreads; ++i) {
            trackers[i] = new LocalMemoryTracker((MemoryPool)this.memoryPool);
            Locks.Client client = this.forsetiLockManager.newClient();
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, (long)i, (MemoryTracker)trackers[i], Config.defaults());
            race.addContestant((Runnable)new SimulatedTransaction(client));
        }
        race.go();
        for (i = 0; i < numThreads; ++i) {
            try (LocalMemoryTracker tracker = trackers[i];){
                ((AbstractLongAssert)Assertions.assertThat((long)tracker.estimatedHeapMemory()).describedAs("Tracker " + tracker, new Object[0])).isGreaterThanOrEqualTo(0L);
                continue;
            }
        }
    }

    @RepeatedTest(value=20)
    void shouldReleaseLocksAndMemoryWhenMemoryLimited() throws Throwable {
        long maxUsedHeap;
        try (HighWaterMarkTracker tracker = new HighWaterMarkTracker((MemoryPool)this.memoryPool, Long.MAX_VALUE, 1024L, "forsetiClientLimitTest");){
            this.lockSomeNodes((MemoryTracker)tracker, (Locks)this.forsetiLockManager);
            maxUsedHeap = tracker.maxUsedHeap;
        }
        Assertions.assertThat((long)maxUsedHeap).isGreaterThan(0L);
        tracker = new LocalMemoryTracker((MemoryPool)this.memoryPool, this.random.nextLong(maxUsedHeap), 1024L, "forsetiClientLimitTest");
        try {
            this.lockSomeNodes((MemoryTracker)tracker, (Locks)this.forsetiLockManager);
        }
        finally {
            tracker.close();
        }
    }

    private void lockSomeNodes(MemoryTracker tracker, Locks lockManager) {
        int nodesPerBatch = 30;
        AtomicReference<String> message = new AtomicReference<String>("No MemoryLimitExceededException observed");
        try (Locks.Client client = lockManager.newClient();){
            int i;
            long extraExclusive;
            int i2;
            long nodeId;
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 1L, tracker, Config.defaults());
            long extraSharedStart = nodeId = 0L;
            int doubleBatch = nodesPerBatch * 2;
            for (long i3 = extraSharedStart; i3 < extraSharedStart + (long)doubleBatch; i3 += 3L) {
                client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{i3});
            }
            for (i2 = 0; i2 < nodesPerBatch; ++i2) {
                client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId++});
            }
            for (i2 = 0; i2 < nodesPerBatch; ++i2) {
                client.tryExclusiveLock((ResourceType)ResourceTypes.NODE, nodeId++);
            }
            for (long i4 = extraSharedStart; i4 < extraSharedStart + (long)doubleBatch; i4 += 3L) {
                client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{i4});
            }
            for (long i5 = extraExclusive = nodeId; i5 < extraExclusive + (long)doubleBatch; i5 += 3L) {
                client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{i5});
            }
            for (i = 0; i < nodesPerBatch; ++i) {
                client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId++});
            }
            for (i = 0; i < nodesPerBatch; ++i) {
                client.trySharedLock((ResourceType)ResourceTypes.NODE, nodeId++);
            }
            for (long i6 = extraExclusive; i6 < extraExclusive + (long)doubleBatch; i6 += 3L) {
                client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{i6});
            }
        }
        catch (MemoryLimitExceededException mlee) {
            message.set("Observed exception: " + Exceptions.stringify((Throwable)mlee));
        }
        this.verifyNoLocks(lockManager, message);
        ((AbstractLongAssert)Assertions.assertThat((long)tracker.estimatedHeapMemory()).as(message.get(), new Object[0])).isZero();
    }

    private void verifyNoLocks(Locks lockManager, AtomicReference<String> message) {
        lockManager.accept((lockType, resourceType, transactionId, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> Assertions.fail((String)"Leaked global lock after client is closed for resource id %d transaction id %d. %s", (Object[])new Object[]{resourceId, transactionId, message}));
    }

    @RepeatedTest(value=20)
    void shouldBeAbleToTrackMemoryCorrectlyWhenTakingExclusiveLockOnSharedLockedObject() throws ExecutionException, InterruptedException {
        long maxUsedHeap;
        try (HighWaterMarkTracker tracker = new HighWaterMarkTracker((MemoryPool)this.memoryPool, Long.MAX_VALUE, 1024L, "forsetiClientLimitTest");){
            this.raceSharedAndExclusiveLock(tracker, (Locks)this.forsetiLockManager);
            maxUsedHeap = tracker.maxUsedHeap;
        }
        Assertions.assertThat((long)maxUsedHeap).isGreaterThan(0L);
        tracker = new LocalMemoryTracker((MemoryPool)this.memoryPool, this.random.nextLong(maxUsedHeap), 1024L, "forsetiClientLimitTest");
        try {
            this.raceSharedAndExclusiveLock(tracker, (Locks)this.forsetiLockManager);
        }
        finally {
            tracker.close();
        }
    }

    private void raceSharedAndExclusiveLock(LocalMemoryTracker memoryTracker1, Locks lockManager) throws InterruptedException, ExecutionException {
        try (LocalMemoryTracker memoryTracker2 = new LocalMemoryTracker();){
            AtomicReference<String> message = new AtomicReference<String>("No MemoryLimitExceededException observed");
            try (OtherThreadExecutor executor1 = new OtherThreadExecutor("test1");
                 OtherThreadExecutor executor2 = new OtherThreadExecutor("test2");){
                CountDownLatch acquireSharedLockLatch = new CountDownLatch(1);
                CountDownLatch releaseSharedLockLatch = new CountDownLatch(1);
                Future future2 = executor2.executeDontWait(() -> {
                    try (Locks.Client otherClient = lockManager.newClient();){
                        otherClient.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 2L, (MemoryTracker)memoryTracker2, Config.defaults());
                        otherClient.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
                        acquireSharedLockLatch.countDown();
                        releaseSharedLockLatch.await();
                    }
                    return null;
                });
                acquireSharedLockLatch.await();
                Future future1 = executor1.executeDontWait(() -> {
                    try (Locks.Client client = lockManager.newClient();){
                        client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 1L, (MemoryTracker)memoryTracker1, Config.defaults());
                        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
                    }
                    catch (MemoryLimitExceededException mlee) {
                        message.set("Observed exception: " + Exceptions.stringify((Throwable)mlee));
                    }
                    return null;
                });
                Thread.sleep(100L);
                releaseSharedLockLatch.countDown();
                future2.get();
                future1.get();
            }
            this.verifyNoLocks(lockManager, message);
            ((AbstractLongAssert)Assertions.assertThat((long)memoryTracker1.estimatedHeapMemory()).as(message.get(), new Object[0])).isZero();
            Assertions.assertThat((long)memoryTracker2.estimatedHeapMemory()).isZero();
        }
    }

    private Locks.Client getClient() {
        Locks.Client client = this.forsetiLockManager.newClient();
        client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, TRANSACTION_ID.getAndIncrement(), this.memoryTracker, Config.defaults());
        return client;
    }

    private static class HighWaterMarkTracker
    extends LocalMemoryTracker {
        private long maxUsedHeap;

        private HighWaterMarkTracker(MemoryPool memoryPool, long localBytesLimit, long grabSize, String limitSettingName) {
            super(memoryPool, localBytesLimit, grabSize, limitSettingName);
        }

        public void allocateHeap(long bytes) {
            super.allocateHeap(bytes);
            long heapMemroy = this.estimatedHeapMemory();
            this.maxUsedHeap = Math.max(this.maxUsedHeap, heapMemroy);
        }
    }

    private static class SimulatedTransaction
    implements Runnable {
        private final Deque<LockEvent> heldLocks = new ArrayDeque<LockEvent>();
        private final Locks.Client client;

        SimulatedTransaction(Locks.Client client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            try {
                for (int i = 0; i < 100; ++i) {
                    if (this.heldLocks.isEmpty() || (double)random.nextFloat() > 0.33) {
                        int nodeId = random.nextInt(10);
                        if (random.nextBoolean()) {
                            if (random.nextBoolean()) {
                                this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
                                this.heldLocks.push(new LockEvent(true, nodeId));
                                continue;
                            }
                            if (!this.client.tryExclusiveLock((ResourceType)ResourceTypes.NODE, (long)nodeId)) continue;
                            this.heldLocks.push(new LockEvent(true, nodeId));
                            continue;
                        }
                        if (random.nextBoolean()) {
                            this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
                            this.heldLocks.push(new LockEvent(false, nodeId));
                            continue;
                        }
                        if (!this.client.trySharedLock((ResourceType)ResourceTypes.NODE, (long)nodeId)) continue;
                        this.heldLocks.push(new LockEvent(false, nodeId));
                        continue;
                    }
                    LockEvent pop = this.heldLocks.pop();
                    if (pop.isExclusive) {
                        this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{pop.nodeId});
                        continue;
                    }
                    this.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{pop.nodeId});
                }
            }
            catch (DeadlockDetectedException deadlockDetectedException) {
            }
            finally {
                this.client.close();
            }
        }

        private static class LockEvent {
            final boolean isExclusive;
            final long nodeId;

            LockEvent(boolean isExclusive, long nodeId) {
                this.isExclusive = isExclusive;
                this.nodeId = nodeId;
            }
        }
    }
}

