/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AutoCloseableSoftAssertions;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;

class TransactionCountersChecker {
    private final TransactionCounters counts;
    private final long started;
    private final long peakConcurrent;
    private final long activeRead;
    private final long activeWrite;
    private final long totalActive;
    private final long committedRead;
    private final long committedWrite;
    private final long totalCommitted;
    private final long rolledBackRead;
    private final long rolledBackWrite;
    private final long totalRolledBack;
    private final long terminatedRead;
    private final long terminatedWrite;
    private final long totalTerminated;

    static TransactionCountersChecker checkerFor(TransactionCounters counts) {
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            TransactionCountersChecker transactionCountersChecker = TransactionCountersChecker.checkerFor((SoftAssertions)softly, counts);
            return transactionCountersChecker;
        }
    }

    static TransactionCountersChecker checkerFor(SoftAssertions softly, TransactionCounters counts) {
        return new TransactionCountersChecker(softly, counts);
    }

    private TransactionCountersChecker(SoftAssertions softly, TransactionCounters counts) {
        this.counts = counts;
        this.started = TransactionCountersChecker.verifyNonNegative(softly, "started", this.counts.getNumberOfStartedTransactions());
        this.peakConcurrent = TransactionCountersChecker.verifyNonNegative(softly, "peak concurrent", this.counts.getPeakConcurrentNumberOfTransactions());
        this.activeRead = TransactionCountersChecker.verifyNonNegative(softly, "active read", this.counts.getNumberOfActiveReadTransactions());
        this.activeWrite = TransactionCountersChecker.verifyNonNegative(softly, "active write", this.counts.getNumberOfActiveWriteTransactions());
        this.totalActive = TransactionCountersChecker.verifyNonNegative(softly, "total active", this.counts.getNumberOfActiveTransactions());
        TransactionCountersChecker.verifyTotal(softly, "active", this.activeRead, this.activeWrite, this.totalActive);
        this.committedRead = TransactionCountersChecker.verifyNonNegative(softly, "committed read", this.counts.getNumberOfCommittedReadTransactions());
        this.committedWrite = TransactionCountersChecker.verifyNonNegative(softly, "committed write", this.counts.getNumberOfCommittedWriteTransactions());
        this.totalCommitted = TransactionCountersChecker.verifyNonNegative(softly, "total committed", this.counts.getNumberOfCommittedTransactions());
        TransactionCountersChecker.verifyTotal(softly, "committed", this.committedRead, this.committedWrite, this.totalCommitted);
        this.rolledBackRead = TransactionCountersChecker.verifyNonNegative(softly, "rolled back read", this.counts.getNumberOfRolledBackReadTransactions());
        this.rolledBackWrite = TransactionCountersChecker.verifyNonNegative(softly, "rolled back write", this.counts.getNumberOfRolledBackWriteTransactions());
        this.totalRolledBack = TransactionCountersChecker.verifyNonNegative(softly, "total rolled back", this.counts.getNumberOfRolledBackTransactions());
        TransactionCountersChecker.verifyTotal(softly, "rolled back", this.rolledBackRead, this.rolledBackWrite, this.totalRolledBack);
        this.terminatedRead = TransactionCountersChecker.verifyNonNegative(softly, "terminated read", this.counts.getNumberOfTerminatedReadTransactions());
        this.terminatedWrite = TransactionCountersChecker.verifyNonNegative(softly, "terminated write", this.counts.getNumberOfTerminatedWriteTransactions());
        this.totalTerminated = TransactionCountersChecker.verifyNonNegative(softly, "total terminated", this.counts.getNumberOfTerminatedTransactions());
        TransactionCountersChecker.verifyTotal(softly, "terminated", this.terminatedRead, this.terminatedWrite, this.totalTerminated);
    }

    public void verify(SoftAssertions softly, ExpectedDifference expectedDifference) {
        this.verifyStartedAndPeak(softly, expectedDifference);
        this.verifyActive(softly, expectedDifference);
        this.verifyCommitted(softly, expectedDifference);
        this.verifyRolledBack(softly, expectedDifference);
        this.verifyTerminated(softly, expectedDifference);
    }

    private void verifyStartedAndPeak(SoftAssertions softly, ExpectedDifference expectedDifference) {
        ((LongAssert)TransactionCountersChecker.assertNonNegative(softly, "started", this.counts.getNumberOfStartedTransactions()).as(TransactionCountersChecker.increasedBy("started", expectedDifference.started))).isEqualTo(this.started + (long)expectedDifference.started);
        ((LongAssert)((LongAssert)((LongAssert)((LongAssert)((LongAssert)TransactionCountersChecker.assertNonNegative(softly, "peak concurrent", this.counts.getPeakConcurrentNumberOfTransactions()).as("number of peak concurrent transactions expected to be no less than it was", new Object[0])).isGreaterThanOrEqualTo(this.peakConcurrent)).as("number of peak concurrent transactions expected to be no less than the total number committed and rolled back transactions", new Object[0])).isGreaterThanOrEqualTo((long)(expectedDifference.committed + expectedDifference.rolledBack))).as("number of peak concurrent transactions expected to be no less than the total number committed and terminated transactions", new Object[0])).isGreaterThanOrEqualTo((long)(expectedDifference.committed + expectedDifference.terminated));
    }

    private void verifyActive(SoftAssertions softly, ExpectedDifference expectedDifference) {
        LongAssert assertActiveRead = TransactionCountersChecker.assertNonNegative(softly, "active read", this.counts.getNumberOfActiveReadTransactions());
        LongAssert assertActiveWrite = TransactionCountersChecker.assertNonNegative(softly, "active write", this.counts.getNumberOfActiveWriteTransactions());
        LongAssert assertTotalActive = TransactionCountersChecker.assertNonNegative(softly, "total active", this.counts.getNumberOfActiveTransactions());
        ((LongAssert)assertTotalActive.as(TransactionCountersChecker.increasedBy("total active", expectedDifference.active))).isEqualTo(this.totalActive + (long)expectedDifference.active);
        if (expectedDifference.isWriteTx) {
            ((LongAssert)assertActiveRead.as(TransactionCountersChecker.unchanged("active read"))).isEqualTo(this.activeRead);
            ((LongAssert)assertActiveWrite.as(TransactionCountersChecker.increasedBy("active write", expectedDifference.active))).isEqualTo(this.activeWrite + (long)expectedDifference.active);
        } else {
            ((LongAssert)assertActiveRead.as(TransactionCountersChecker.increasedBy("active read", expectedDifference.active))).isEqualTo(this.activeRead + (long)expectedDifference.active);
            ((LongAssert)assertActiveWrite.as(TransactionCountersChecker.unchanged("active write"))).isEqualTo(this.activeWrite);
        }
    }

    private void verifyCommitted(SoftAssertions softly, ExpectedDifference expectedDifference) {
        LongAssert assertCommittedRead = TransactionCountersChecker.assertNonNegative(softly, "committed read", this.counts.getNumberOfCommittedReadTransactions());
        LongAssert assertCommittedWrite = TransactionCountersChecker.assertNonNegative(softly, "committed write", this.counts.getNumberOfCommittedWriteTransactions());
        LongAssert assertTotalCommitted = TransactionCountersChecker.assertNonNegative(softly, "total committed", this.counts.getNumberOfCommittedTransactions());
        ((LongAssert)assertTotalCommitted.as(TransactionCountersChecker.increasedBy("total committed", expectedDifference.committed))).isEqualTo(this.totalCommitted + (long)expectedDifference.committed);
        if (expectedDifference.isWriteTx) {
            ((LongAssert)assertCommittedRead.as(TransactionCountersChecker.unchanged("committed read"))).isEqualTo(this.committedRead);
            ((LongAssert)assertCommittedWrite.as(TransactionCountersChecker.increasedBy("committed write", expectedDifference.committed))).isEqualTo(this.committedWrite + (long)expectedDifference.committed);
        } else {
            ((LongAssert)assertCommittedRead.as(TransactionCountersChecker.increasedBy("committed read", expectedDifference.committed))).isEqualTo(this.committedRead + (long)expectedDifference.committed);
            ((LongAssert)assertCommittedWrite.as(TransactionCountersChecker.unchanged("committed write"))).isEqualTo(this.committedWrite);
        }
    }

    private void verifyRolledBack(SoftAssertions softly, ExpectedDifference expectedDifference) {
        LongAssert assertRolledBackRead = TransactionCountersChecker.assertNonNegative(softly, "rolled back read", this.counts.getNumberOfRolledBackReadTransactions());
        LongAssert assertRolledBackWrite = TransactionCountersChecker.assertNonNegative(softly, "rolled back write", this.counts.getNumberOfRolledBackWriteTransactions());
        LongAssert assertTotalRolledBack = TransactionCountersChecker.assertNonNegative(softly, "total rolled back", this.counts.getNumberOfRolledBackTransactions());
        ((LongAssert)assertTotalRolledBack.as(TransactionCountersChecker.increasedBy("total rolled back", expectedDifference.rolledBack))).isEqualTo(this.totalRolledBack + (long)expectedDifference.rolledBack);
        if (expectedDifference.isWriteTx) {
            ((LongAssert)assertRolledBackRead.as(TransactionCountersChecker.unchanged("rolled back read"))).isEqualTo(this.rolledBackRead);
            ((LongAssert)assertRolledBackWrite.as(TransactionCountersChecker.increasedBy("rolled back write", expectedDifference.rolledBack))).isEqualTo(this.rolledBackWrite + (long)expectedDifference.rolledBack);
        } else {
            ((LongAssert)assertRolledBackRead.as(TransactionCountersChecker.increasedBy("rolled back read", expectedDifference.rolledBack))).isEqualTo(this.rolledBackRead + (long)expectedDifference.rolledBack);
            ((LongAssert)assertRolledBackWrite.as(TransactionCountersChecker.unchanged("rolled back read"))).isEqualTo(this.rolledBackWrite);
        }
    }

    private void verifyTerminated(SoftAssertions softly, ExpectedDifference expectedDifference) {
        LongAssert assertTerminatedRead = TransactionCountersChecker.assertNonNegative(softly, "terminated read", this.counts.getNumberOfTerminatedReadTransactions());
        LongAssert assertTerminatedWrite = TransactionCountersChecker.assertNonNegative(softly, "terminated write", this.counts.getNumberOfTerminatedWriteTransactions());
        LongAssert assertTotalTerminated = TransactionCountersChecker.assertNonNegative(softly, "total terminated", this.counts.getNumberOfTerminatedTransactions());
        ((LongAssert)assertTotalTerminated.as(TransactionCountersChecker.increasedBy("total terminated", expectedDifference.terminated))).isEqualTo(this.totalTerminated + (long)expectedDifference.terminated);
        if (expectedDifference.isWriteTx) {
            ((LongAssert)assertTerminatedRead.as(TransactionCountersChecker.unchanged("terminated read"))).isEqualTo(this.terminatedRead);
            ((LongAssert)assertTerminatedWrite.as(TransactionCountersChecker.increasedBy("terminated write", expectedDifference.terminated))).isEqualTo(this.terminatedWrite + (long)expectedDifference.terminated);
        } else {
            ((LongAssert)assertTerminatedRead.as(TransactionCountersChecker.increasedBy("terminated read", expectedDifference.terminated))).isEqualTo(this.terminatedRead + (long)expectedDifference.terminated);
            ((LongAssert)assertTerminatedWrite.as(TransactionCountersChecker.unchanged("terminated write"))).isEqualTo(this.terminatedWrite);
        }
    }

    private static long verifyNonNegative(SoftAssertions softly, String name, long value) {
        TransactionCountersChecker.assertNonNegative(softly, name, value);
        return value;
    }

    private static LongAssert assertNonNegative(SoftAssertions softly, String name, long value) {
        return (LongAssert)((LongAssert)softly.assertThat(value).as(TransactionCountersChecker.nonNegative(name))).isGreaterThanOrEqualTo(0L);
    }

    private static void verifyTotal(SoftAssertions softly, String name, long read, long write, long total) {
        ((LongAssert)softly.assertThat(read + write).as("total of read and write %s transactions should be the total number of %s transactions", new Object[]{name, name})).isEqualTo(total);
    }

    private static Description nonNegative(String name) {
        return new TextDescription("number of %s transactions is expected to be non-negative", new Object[]{name});
    }

    private static Description unchanged(String name) {
        return new TextDescription("number of %s transactions expected to not change", new Object[]{name});
    }

    private static Description increasedBy(String name, long value) {
        ((AbstractLongAssert)Assertions.assertThat((long)value).as("given value expected to be non-negative", new Object[0])).isGreaterThanOrEqualTo(0L);
        if (value == 0L) {
            return TransactionCountersChecker.unchanged(name);
        }
        return new TextDescription("number of %s transactions expected to increase by %d", new Object[]{name, value});
    }

    static final class ExpectedDifference {
        static final ExpectedDifference NONE = new ExpectedDifference(false, 0, 0, 0, 0, 0);
        final boolean isWriteTx;
        final int started;
        final int active;
        final int committed;
        final int rolledBack;
        final int terminated;

        ExpectedDifference(boolean isWriteTx, int started, int active, int committed, int rolledBack, int terminated) {
            this.isWriteTx = isWriteTx;
            this.started = started;
            this.active = active;
            this.committed = committed;
            this.rolledBack = rolledBack;
            this.terminated = terminated;
        }

        ExpectedDifference isWriteTx(boolean isWriteTx) {
            return new ExpectedDifference(isWriteTx, this.started, this.active, this.committed, this.rolledBack, this.terminated);
        }

        ExpectedDifference withStarted(int started) {
            return new ExpectedDifference(this.isWriteTx, started, this.active, this.committed, this.rolledBack, this.terminated);
        }

        ExpectedDifference withActive(int active) {
            return new ExpectedDifference(this.isWriteTx, this.started, active, this.committed, this.rolledBack, this.terminated);
        }

        ExpectedDifference withCommitted(int committed) {
            return new ExpectedDifference(this.isWriteTx, this.started, this.active, committed, this.rolledBack, this.terminated);
        }

        ExpectedDifference withRolledBack(int rolledBack) {
            return new ExpectedDifference(this.isWriteTx, this.started, this.active, this.committed, rolledBack, this.terminated);
        }

        ExpectedDifference withTerminated(int terminated) {
            return new ExpectedDifference(this.isWriteTx, this.started, this.active, this.committed, this.rolledBack, terminated);
        }

        ExpectedDifference verifyWith(TransactionCountersChecker checker) {
            try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
                ExpectedDifference expectedDifference = this.verifyWith((SoftAssertions)softly, checker);
                return expectedDifference;
            }
        }

        ExpectedDifference verifyWith(SoftAssertions softly, TransactionCountersChecker checker) {
            String type = this.isWriteTx ? "write" : "read";
            TransactionCountersChecker.verifyNonNegative(softly, "started " + type, this.started);
            TransactionCountersChecker.verifyNonNegative(softly, "active " + type, this.active);
            TransactionCountersChecker.verifyNonNegative(softly, "committed " + type, this.committed);
            TransactionCountersChecker.verifyNonNegative(softly, "rolledBack " + type, this.rolledBack);
            TransactionCountersChecker.verifyNonNegative(softly, "terminated " + type, this.terminated);
            checker.verify(softly, this);
            return this;
        }
    }
}

