/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexKeyStateFormatTest;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class GenericKeyStateFormatTest<KEY extends GenericKey<KEY>>
extends IndexKeyStateFormatTest<KEY> {
    static final int NUMBER_OF_SLOTS = 2;

    GenericKeyStateFormatTest() {
    }

    @Override
    void populateValues(List<Value> values) {
        values.add((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.of(2018, 10, 9, 8, 7, 6, 5, ZoneId.of("UTC")), ZonedDateTime.of(2017, 9, 8, 7, 6, 5, 4, ZoneId.of("UTC"))}));
        values.add((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5), LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5)}));
        values.add((Value)Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.of(1, 12, 28), LocalDate.of(1, 12, 28)}));
        values.add((Value)Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.of(19, 8, 7, 6, ZoneOffset.UTC), OffsetTime.of(19, 8, 7, 6, ZoneOffset.UTC)}));
        values.add((Value)Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.of(19, 28), LocalTime.of(19, 28)}));
        values.add((Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((long)99L, (long)10L, (long)10L, (long)10L), DurationValue.duration((long)99L, (long)10L, (long)10L, (long)10L)}));
        values.add(Values.of((Object)new String[]{"someString1", "someString2"}));
        values.add(Values.of((Object)new boolean[]{true, true}));
        values.add(Values.of((Object)new byte[]{1, 12}));
        values.add(Values.of((Object)new short[]{314, 1337}));
        values.add(Values.of((Object)new int[]{3140, 13370}));
        values.add(Values.of((Object)new long[]{31400L, 133700L}));
        values.add(Values.of((Object)new float[]{0.5654f, 13432.14f}));
        values.add(Values.of((Object)new double[]{4.3245325443243E8, 4354.7888}));
        values.add(Values.of((Object)new char[]{'a', 'z'}));
        values.add((Value)DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"UTC"));
        values.add((Value)LocalDateTimeValue.localDateTime((int)2018, (int)3, (int)1, (int)13, (int)50, (int)42, (int)1337));
        values.add((Value)DateValue.epochDate((long)2L));
        values.add((Value)TimeValue.time((long)43200000000000L, (ZoneOffset)ZoneOffset.UTC));
        values.add((Value)LocalTimeValue.localTime((long)100000L));
        values.add((Value)DurationValue.duration((long)10L, (long)20L, (long)30L, (long)40L));
        values.add(Values.of((Object)"string1"));
        values.add(Values.of((Object)true));
        values.add(Values.of((Object)127));
        values.add(Values.of((Object)Short.MAX_VALUE));
        values.add(Values.of((Object)Integer.MAX_VALUE));
        values.add(Values.of((Object)Long.MAX_VALUE));
        values.add(Values.of((Object)Float.valueOf(Float.MAX_VALUE)));
        values.add(Values.of((Object)Double.MAX_VALUE));
        values.add(Values.of((Object)Character.valueOf('\uffff')));
        values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.78, 56.7}));
        values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.7566548, 56.7163465}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.13413478, 56.1343457})}));
        values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.78, 56.7, 666.0}));
        values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.7566548, 56.7163465, 666.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.13413478, 56.1343457, 555.0})}));
        values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{4.3E-6, -1.2341025786543E-9}));
        values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{4.3E-6, -1.2341025786543E-9}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.2000043, -0.03000000123410258})}));
        values.add((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{4.3E-6, -1.2341025786543E-9, 666.0}));
        values.add((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{4.3E-6, -1.2341025786543E-9, 666.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{0.2000043, -0.03000000123410258, 555.0})}));
    }

    @Override
    String toDetailedString(KEY key) {
        return key.toDetailedString();
    }
}

