/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import inet.ipaddr.IPAddressString;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.impl.security.URLAccessRules;

class WebURLAccessRuleTest {
    WebURLAccessRuleTest() {
    }

    @Test
    void shouldThrowWhenUrlIsWithinBlockedRange() throws MalformedURLException {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.0/8");
        IPAddressString blockedIpv6Range = new IPAddressString("0:0:0:0:0:0:0:1/8");
        List<String> urlAddresses = List.of("http://localhost/test.csv", "https://localhost/test.csv", "ftp://localhost/test.csv", "http://[::1]/test.csv");
        for (String urlAddress : urlAddresses) {
            URL url = new URL(urlAddress);
            Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range, blockedIpv6Range));
            URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
            Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"});
        }
    }

    @Test
    void validationShouldPassWhenUrlIsNotWithinBlockedRange() throws MalformedURLException, URLAccessValidationError {
        List<String> urlAddresses = List.of("http://localhost/test.csv", "https://localhost/test.csv", "ftp://localhost/test.csv", "http://[::1]/test.csv");
        for (String urlAddress : urlAddresses) {
            URL url = new URL(urlAddress);
            Config config = Config.defaults();
            URL result = URLAccessRules.webAccess().validate((Configuration)config, url);
            assert (result == url);
        }
    }

    @Test
    void shouldWorkWithNonRangeIps() throws MalformedURLException {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.1");
        URL url = new URL("http://localhost/test.csv");
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"});
    }

    @Test
    void shouldFailForInvalidIps() throws Exception {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.1");
        URL url = new URL("http://always.invalid/test.csv");
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"Unable to verify access to always.invalid"});
    }

    @Test
    void shouldFailForRedirectedInvalidIps() throws Exception {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.1");
        final HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)302);
        Mockito.when((Object)connection.getHeaderField("Location")).thenReturn((Object)"http://127.0.0.1");
        URLStreamHandler urlStreamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                return connection;
            }
        };
        URL url = new URL("http", "127.0.0.0", 8000, "", urlStreamHandler);
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"access to /127.0.0.1 is blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"});
    }

    @Test
    void shouldNotFollowChangeInProtocols() throws Exception {
        IPAddressString blockedIpv4Range = new IPAddressString("127.168.0.1");
        final HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)306);
        Mockito.when((Object)connection.getHeaderField("Location")).thenReturn((Object)"http://127.0.0.1");
        URLStreamHandler urlStreamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                return connection;
            }
        };
        URL url = new URL("https", "127.0.0.0", 8000, "", urlStreamHandler);
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        URL validatedURL = URLAccessRules.webAccess().validate((Configuration)config, url);
        org.junit.jupiter.api.Assertions.assertEquals((Object)url, (Object)validatedURL);
    }

    @Test
    void shouldFailForExceedingRedirectLimit() throws Exception {
        IPAddressString blockedIpv4Range = new IPAddressString("127.168.0.1");
        final HttpURLConnection connectionA = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)connectionA.getResponseCode()).thenReturn((Object)302);
        Mockito.when((Object)connectionA.getHeaderField("Location")).thenReturn((Object)"/b");
        final HttpURLConnection connectionB = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)connectionB.getResponseCode()).thenReturn((Object)302);
        Mockito.when((Object)connectionB.getHeaderField("Location")).thenReturn((Object)"/a");
        final MutableInt counter = new MutableInt(0);
        URLStreamHandler urlStreamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                return counter.getAndIncrement() % 2 == 0 ? connectionA : connectionB;
            }
        };
        URL urlA = new URL("http", "127.0.0.0", 8000, "/a", urlStreamHandler);
        URL urlB = new URL("http", "127.0.0.0", 8000, "/b", urlStreamHandler);
        Mockito.when((Object)connectionA.getURL()).thenReturn((Object)urlA);
        Mockito.when((Object)connectionB.getURL()).thenReturn((Object)urlB);
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> URLAccessRules.webAccess().validate((Configuration)config, urlA)).isInstanceOf(URLAccessValidationError.class)).hasMessageContaining("Redirect limit exceeded");
    }
}

