/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.storemigration.IndexMigration;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;

public class IndexConfigMigrator
extends AbstractStoreMigrationParticipant {
    private static final String INDEX_CONFIG_MIGRATION_TAG = "indexConfigMigration";
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCache pageCache;
    private final LogService logService;
    private final StorageEngineFactory storageEngineFactory;
    private final IndexProviderMap indexProviderMap;
    private final Log log;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;

    IndexConfigMigrator(FileSystemAbstraction fs, Config config, PageCache pageCache, LogService logService, StorageEngineFactory storageEngineFactory, IndexProviderMap indexProviderMap, Log log, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        super("Index config");
        this.fs = fs;
        this.config = config;
        this.pageCache = pageCache;
        this.logService = logService;
        this.storageEngineFactory = storageEngineFactory;
        this.indexProviderMap = indexProviderMap;
        this.log = log;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
    }

    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) throws IOException, KernelException {
        if (this.needConfigMigration(versionToMigrateFrom, versionToMigrateTo)) {
            this.migrateIndexConfigs(directoryLayout, migrationLayout, versionToMigrateTo);
        }
    }

    private void migrateIndexConfigs(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, String versionToMigrateTo) throws IOException, KernelException {
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(INDEX_CONFIG_MIGRATION_TAG));
             SchemaRuleMigrationAccess ruleAccess = this.storageEngineFactory.schemaRuleMigrationAccess(this.fs, this.pageCache, this.config, migrationLayout, this.logService, versionToMigrateTo, this.pageCacheTracer, cursorContext, this.memoryTracker);){
            for (SchemaRule rule : ruleAccess.getAll()) {
                SchemaRule upgraded = IndexConfigMigrator.migrateIndexConfig(rule, directoryLayout, this.fs, this.pageCache, this.indexProviderMap, this.log, cursorContext);
                if (upgraded == rule) continue;
                ruleAccess.writeSchemaRule(upgraded);
            }
        }
    }

    public static SchemaRule migrateIndexConfig(SchemaRule rule, DatabaseLayout directoryLayout, FileSystemAbstraction fs, PageCache pageCache, IndexProviderMap indexProviderMap, Log log, CursorContext cursorContext) throws IOException {
        if (rule instanceof IndexDescriptor) {
            IndexDescriptor old = (IndexDescriptor)rule;
            long indexId = old.getId();
            IndexProviderDescriptor provider = old.getIndexProvider();
            IndexMigration indexMigration = IndexMigration.migrationFromOldProvider(provider.getKey(), provider.getVersion());
            IndexConfig indexConfig = indexMigration.extractIndexConfig(fs, pageCache, directoryLayout, indexId, cursorContext, log);
            IndexDescriptor newIndexReference = old.withIndexConfig(indexConfig);
            IndexProvider indexProvider = indexProviderMap.lookup(indexMigration.desiredAlternativeProvider);
            return indexProvider.completeConfiguration(newIndexReference);
        }
        return rule;
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.needConfigMigration(versionToMigrateFrom, versionToMigrateTo)) {
            for (IndexMigration indexMigration : IndexMigration.nonRetired()) {
                for (Path nonRetiredRootDirectory : indexMigration.providerRootDirectories(directoryLayout)) {
                    this.fs.deleteRecursively(nonRetiredRootDirectory);
                }
            }
        }
    }

    public void cleanup(DatabaseLayout migrationLayout) {
    }

    private boolean needConfigMigration(String versionToMigrateFrom, String versionToMigrateTo) {
        StoreVersion toVersionInformation;
        StoreVersion fromVersionInformation = this.storageEngineFactory.versionInformation(versionToMigrateFrom);
        return !fromVersionInformation.hasCompatibleCapabilities(toVersionInformation = this.storageEngineFactory.versionInformation(versionToMigrateTo), CapabilityType.INDEX_CONFIG);
    }
}

