/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.dbms.database.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;

public class CommunityTopologyGraphDbmsModel
implements TopologyGraphDbmsModel {
    protected final Transaction tx;

    public CommunityTopologyGraphDbmsModel(Transaction tx) {
        this.tx = tx;
    }

    public Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> getAllDatabaseAccess() {
        return this.tx.findNodes(DATABASE_LABEL).stream().collect(Collectors.toMap(CommunityTopologyGraphDbmsModel::getDatabaseId, CommunityTopologyGraphDbmsModel::getDatabaseAccess));
    }

    private static TopologyGraphDbmsModel.DatabaseAccess getDatabaseAccess(Node databaseNode) {
        String accessString = (String)databaseNode.getProperty("access", (Object)TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        return Enum.valueOf(TopologyGraphDbmsModel.DatabaseAccess.class, accessString);
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String databaseName) {
        return this.getDatabaseIdByAlias0(databaseName).or(() -> this.getDatabaseIdBy("name", databaseName));
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid) {
        return this.getDatabaseIdBy("uuid", uuid.toString());
    }

    @Override
    public Map<String, NamedDatabaseId> getAllDatabaseAliases() {
        Map allDbNames = this.getAllDatabaseIds().stream().collect(Collectors.toMap(NamedDatabaseId::name, Function.identity()));
        Map<String, NamedDatabaseId> allDbAliases = this.getAllDatabaseAliases0();
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.putAll(allDbNames);
        all.putAll(allDbAliases);
        return Map.copyOf(all);
    }

    @Override
    public Set<NamedDatabaseId> getAllDatabaseIds() {
        return this.tx.findNodes(DATABASE_LABEL).stream().map(CommunityTopologyGraphDbmsModel::getDatabaseId).collect(Collectors.toUnmodifiableSet());
    }

    private Map<String, NamedDatabaseId> getAllDatabaseAliases0() {
        return this.tx.findNodes(DATABASE_NAME_LABEL).stream().flatMap(alias -> CommunityTopologyGraphDbmsModel.getTargetedDatabase(alias).flatMap(db -> this.aliasDatabaseIdPair((Node)alias, (NamedDatabaseId)db)).stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Map.Entry<String, NamedDatabaseId>> aliasDatabaseIdPair(Node alias, NamedDatabaseId targetedDatabase) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            String aliasName = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_NAME, alias, "name");
            return Optional.of(Map.entry(aliasName, targetedDatabase));
        });
    }

    private Optional<NamedDatabaseId> getDatabaseIdByAlias0(String databaseName) {
        Optional<Node> node = Optional.ofNullable(this.tx.findNode(DATABASE_NAME_LABEL, "name", (Object)databaseName));
        return node.flatMap(CommunityTopologyGraphDbmsModel::getTargetedDatabase);
    }

    private Optional<NamedDatabaseId> getDatabaseIdBy(String propertyKey, String propertyValue) {
        try {
            Node node = this.tx.findNode(DATABASE_LABEL, propertyKey, (Object)propertyValue);
            if (node == null) {
                return Optional.empty();
            }
            String databaseName = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_LABEL.name(), node, "name");
            String databaseUuid = CommunityTopologyGraphDbmsModel.getPropertyOnNode(DATABASE_LABEL.name(), node, "uuid");
            return Optional.of(DatabaseIdFactory.from((String)databaseName, (UUID)UUID.fromString(databaseUuid)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<NamedDatabaseId> getTargetedDatabase(Node aliasNode) {
        return CommunityTopologyGraphDbmsModel.ignoreConcurrentDeletes(() -> {
            List targetDatabases = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TARGETS_RELATIONSHIP}).spliterator(), false).collect(Collectors.toList());
            return targetDatabases.stream().findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModel::getDatabaseId);
        });
    }

    private static NamedDatabaseId getDatabaseId(Node databaseNode) {
        String name = (String)databaseNode.getProperty("name");
        UUID uuid = UUID.fromString((String)databaseNode.getProperty("uuid"));
        return DatabaseIdFactory.from((String)name, (UUID)uuid);
    }

    private static String getPropertyOnNode(String labelName, Node node, String key) {
        Object value = node.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("%s has no property %s.", labelName, key));
        }
        if (!(value instanceof String)) {
            throw new IllegalStateException(String.format("%s has non String property %s.", labelName, key));
        }
        return (String)value;
    }

    private static <T> Optional<T> ignoreConcurrentDeletes(Supplier<Optional<T>> operation) {
        try {
            return operation.get();
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }
}

