/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.ExceptionUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.DatabaseUpgradeTransactionHandler;
import org.neo4j.kernel.database.UpgradeLocker;
import org.neo4j.kernel.impl.api.InjectedNLIUpgradeCallback;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.lock.Lock;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Race;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;

class DatabaseUpgradeTransactionHandlerTest {
    private volatile KernelVersion currentKernelVersion;
    private volatile DbmsRuntimeVersion currentDbmsRuntimeVersion;
    private InternalTransactionEventListener<Object> listener;
    private volatile boolean listenerUnregistered;
    private final ConcurrentLinkedQueue<RegisteredTransaction> registeredTransactions = new ConcurrentLinkedQueue();
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final RWUpgradeLocker lock = new RWUpgradeLocker();

    DatabaseUpgradeTransactionHandlerTest() {
    }

    @AfterEach
    void checkTransactionStreamConsistency() {
        this.assertCorrectTransactionStream();
    }

    @Test
    void shouldUpdateKernelOnFirstTransactionAndUnsubscribeListener() {
        this.init(KernelVersion.V4_2, DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION);
        this.doATransaction();
        Assertions.assertThat((Comparable)this.currentKernelVersion).isEqualTo((Object)KernelVersion.LATEST);
        Assertions.assertThat((boolean)this.listenerUnregistered).isTrue();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithArguments("Upgrade transaction from %s to %s started", new Object[]{KernelVersion.V4_2, KernelVersion.LATEST}).containsMessageWithArguments("Upgrade transaction from %s to %s completed", new Object[]{KernelVersion.V4_2, KernelVersion.LATEST});
    }

    @Test
    void shouldNotRegisterListenerWhenOnLatestVersion() {
        this.init(KernelVersion.LATEST, DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION);
        this.doATransaction();
        Assertions.assertThat(this.listener).isNull();
        Assertions.assertThat((boolean)this.listenerUnregistered).isFalse();
    }

    @Test
    void shouldNotUpgradePastRuntimeVersionAndKeepListener() {
        this.init(KernelVersion.V4_0, DbmsRuntimeVersion.V4_2);
        this.doATransaction();
        Assertions.assertThat((Comparable)this.currentKernelVersion).isEqualTo((Object)KernelVersion.V4_2);
        Assertions.assertThat((boolean)this.listenerUnregistered).isFalse();
    }

    @Test
    void shouldWaitForUpgradeUntilRuntimeVersionIsBumped() {
        this.init(KernelVersion.V4_2, DbmsRuntimeVersion.V4_2);
        this.doATransaction();
        Assertions.assertThat((Comparable)this.currentKernelVersion).isEqualTo((Object)KernelVersion.V4_2);
        Assertions.assertThat((boolean)this.listenerUnregistered).isFalse();
        this.setDbmsRuntime(DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION);
        this.doATransaction();
        Assertions.assertThat((Comparable)this.currentKernelVersion).isEqualTo((Object)KernelVersion.LATEST);
        Assertions.assertThat((boolean)this.listenerUnregistered).isTrue();
    }

    @Test
    void shouldNotRegisterListenerWhenKernelIsNewerThanRuntime() {
        this.init(KernelVersion.LATEST, DbmsRuntimeVersion.V4_2);
        this.doATransaction();
        Assertions.assertThat(this.listener).isNull();
        Assertions.assertThat((boolean)this.listenerUnregistered).isFalse();
    }

    @Test
    void shouldUpgradeOnceEvenWithManyConcurrentTransactions() {
        this.init(KernelVersion.V4_0, DbmsRuntimeVersion.V4_2);
        AtomicBoolean stop = new AtomicBoolean();
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[1];
        booleanSupplierArray[0] = stop::get;
        Race race = new Race().withEndCondition(booleanSupplierArray);
        race.addContestants(Integer.max(Runtime.getRuntime().availableProcessors() - 1, 2), this::doATransactionWithSomeSleeping);
        race.addContestant(() -> {
            Assert.assertEventually(this::getKernelVersion, (Condition)Conditions.equalityCondition((Object)KernelVersion.V4_2), (long)1L, (TimeUnit)TimeUnit.MINUTES);
            this.setDbmsRuntime(DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION);
            Assert.assertEventually(this::getKernelVersion, (Condition)Conditions.equalityCondition((Object)KernelVersion.LATEST), (long)1L, (TimeUnit)TimeUnit.MINUTES);
            stop.set(true);
        }, 1);
        race.goUnchecked();
    }

    private void assertCorrectTransactionStream() {
        KernelVersion checkVersion = null;
        for (RegisteredTransaction registeredTransaction : this.registeredTransactions) {
            if (registeredTransaction.isUpgradeTransaction) {
                if (checkVersion != null) {
                    Assertions.assertThat((boolean)registeredTransaction.version.isGreaterThan(checkVersion)).isTrue();
                }
                checkVersion = registeredTransaction.version;
                continue;
            }
            if (checkVersion != null) {
                Assertions.assertThat((Comparable)registeredTransaction.version).isEqualTo((Object)checkVersion);
                continue;
            }
            checkVersion = registeredTransaction.version;
        }
    }

    private void init(KernelVersion initialKernelVersion, DbmsRuntimeVersion initialDbmsRuntimeVersion) {
        this.setKernelVersion(initialKernelVersion);
        this.setDbmsRuntime(initialDbmsRuntimeVersion);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        ((StorageEngine)Mockito.doAnswer(inv -> {
            KernelVersion toKernelVersion = (KernelVersion)inv.getArgument(0, KernelVersion.class);
            this.registeredTransactions.add(new RegisteredTransaction(toKernelVersion, true));
            return List.of(new FakeKernelVersionUpgradeCommand(toKernelVersion));
        }).when((Object)storageEngine)).createUpgradeCommands((KernelVersion)ArgumentMatchers.any(), (InjectedNLIUpgradeCallback)ArgumentMatchers.any());
        DbmsRuntimeRepository dbmsRuntimeRepository = (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class);
        ((DbmsRuntimeRepository)Mockito.doAnswer(inv -> this.currentDbmsRuntimeVersion).when((Object)dbmsRuntimeRepository)).getVersion();
        KernelVersionRepository kernelVersionRepository = this::getKernelVersion;
        DatabaseTransactionEventListeners databaseTransactionEventListeners = (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class);
        ((DatabaseTransactionEventListeners)Mockito.doAnswer(inv -> {
            this.listener = (InternalTransactionEventListener)inv.getArgument(0, InternalTransactionEventListener.class);
            return this.listener;
        }).when((Object)databaseTransactionEventListeners)).registerTransactionEventListener((TransactionEventListener)ArgumentMatchers.any());
        ((DatabaseTransactionEventListeners)Mockito.doAnswer(inv -> {
            this.listenerUnregistered = true;
            return true;
        }).when((Object)databaseTransactionEventListeners)).unregisterTransactionEventListener((TransactionEventListener)ArgumentMatchers.any());
        DatabaseUpgradeTransactionHandler handler = new DatabaseUpgradeTransactionHandler(storageEngine, dbmsRuntimeRepository, kernelVersionRepository, databaseTransactionEventListeners, (UpgradeLocker)this.lock, (LogProvider)this.logProvider);
        handler.registerUpgradeListener(commands -> this.setKernelVersion(((FakeKernelVersionUpgradeCommand)commands.iterator().next()).version));
    }

    private synchronized void setKernelVersion(KernelVersion newKernelVersion) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.currentKernelVersion).as("We only allow one upgrade transaction", new Object[0])).isNotEqualTo((Object)newKernelVersion);
        this.currentKernelVersion = newKernelVersion;
    }

    private synchronized KernelVersion getKernelVersion() {
        return this.currentKernelVersion;
    }

    private synchronized void setDbmsRuntime(DbmsRuntimeVersion dbmsRuntimeVersion) {
        this.currentDbmsRuntimeVersion = dbmsRuntimeVersion;
    }

    private void doATransaction() {
        this.doATransaction(false);
    }

    private void doATransactionWithSomeSleeping() {
        this.doATransaction(true);
    }

    private void doATransaction(boolean doSomeSleeping) {
        if (!this.listenerUnregistered && this.listener != null) {
            try {
                Object state = this.listener.beforeCommit((TransactionData)Mockito.mock(TransactionData.class), (KernelTransaction)Mockito.mock(KernelTransaction.class), (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class));
                KernelVersion currentKernelVersion = this.currentKernelVersion;
                if (doSomeSleeping) {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(3));
                }
                this.registeredTransactions.add(new RegisteredTransaction(currentKernelVersion, false));
                this.listener.afterCommit((TransactionData)Mockito.mock(TransactionData.class), state, (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class));
            }
            catch (Exception e) {
                ExceptionUtils.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private static class RWUpgradeLocker
    implements UpgradeLocker {
        private final ReadWriteLock realLock = new ReentrantReadWriteLock();

        private RWUpgradeLocker() {
        }

        public Lock acquireWriteLock(KernelTransaction tx) {
            this.realLock.writeLock().lock();
            return new Lock(){

                public void release() {
                    realLock.writeLock().unlock();
                }
            };
        }

        public Lock acquireReadLock(KernelTransaction tx) {
            this.realLock.readLock().lock();
            return new Lock(){

                public void release() {
                    realLock.readLock().unlock();
                }
            };
        }
    }

    private static class RegisteredTransaction {
        private final KernelVersion version;
        private final boolean isUpgradeTransaction;

        RegisteredTransaction(KernelVersion version, boolean isUpgradeTransaction) {
            this.version = version;
            this.isUpgradeTransaction = isUpgradeTransaction;
        }

        public String toString() {
            return "RegisteredTransaction{version=" + this.version + ", isUpgradeTransaction=" + this.isUpgradeTransaction + "}";
        }
    }

    private static class FakeKernelVersionUpgradeCommand
    implements StorageCommand {
        KernelVersion version;

        FakeKernelVersionUpgradeCommand(KernelVersion version) {
            this.version = version;
        }

        public KernelVersion version() {
            return this.version;
        }

        public void serialize(WritableChannel channel) throws IOException {
        }
    }
}

