/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerExtension;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.scheduler.CallingThreadJobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={JobSchedulerExtension.class})
public class BatchingMultipleIndexPopulatorTest {
    private static final int propertyId = 1;
    private static final int labelId = 1;
    @Inject
    private JobScheduler jobScheduler;
    private final IndexDescriptor index1 = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    private final IndexDescriptor index42 = TestIndexDescriptorFactory.forLabel((int)42, (int[])new int[]{42});
    private final InMemoryTokens tokens = new InMemoryTokens();

    @Test
    void populateFromQueueDoesNothingIfThresholdNotReached() throws Exception {
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator((IndexStoreView)Mockito.mock(IndexStoreView.class), (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults((Setting)GraphDatabaseInternalSettings.index_population_queue_threshold, (Object)5));
        IndexPopulator populator = this.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)updater);
        ValueIndexEntryUpdate update1 = IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.index1, (Object[])new Object[]{"foo"});
        ValueIndexEntryUpdate update2 = IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.index1, (Object[])new Object[]{"bar"});
        batchingPopulator.queueConcurrentUpdate((IndexEntryUpdate)update1);
        batchingPopulator.queueConcurrentUpdate((IndexEntryUpdate)update2);
        Assertions.assertThat((boolean)batchingPopulator.needToApplyExternalUpdates()).isFalse();
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)ArgumentMatchers.any(ValueIndexEntryUpdate.class));
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any());
    }

    @Test
    void populateFromQueuePopulatesWhenThresholdReached() throws Exception {
        FullScanStoreView storeView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, () -> (StorageReader)Mockito.mock(StorageReader.class), any -> StoreCursors.NULL, Config.defaults(), this.jobScheduler);
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults((Setting)GraphDatabaseInternalSettings.index_population_queue_threshold, (Object)2));
        IndexPopulator populator1 = this.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator1.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)updater1);
        IndexPopulator populator2 = this.addPopulator(batchingPopulator, this.index42);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator2.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)updater2);
        batchingPopulator.createStoreScan(PageCacheTracer.NULL);
        ValueIndexEntryUpdate update1 = IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.index1, (Object[])new Object[]{"foo"});
        ValueIndexEntryUpdate update2 = IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.index42, (Object[])new Object[]{"bar"});
        ValueIndexEntryUpdate update3 = IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.index1, (Object[])new Object[]{"baz"});
        batchingPopulator.queueConcurrentUpdate((IndexEntryUpdate)update1);
        batchingPopulator.queueConcurrentUpdate((IndexEntryUpdate)update2);
        batchingPopulator.queueConcurrentUpdate((IndexEntryUpdate)update3);
        batchingPopulator.applyExternalUpdates(42L);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process((IndexEntryUpdate)update1);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process((IndexEntryUpdate)update3);
        ((IndexUpdater)Mockito.verify((Object)updater2)).process((IndexEntryUpdate)update2);
    }

    @Test
    void pendingBatchesFlushedAfterStoreScan() throws Exception {
        Update update1 = BatchingMultipleIndexPopulatorTest.nodeUpdate(1, 1, "foo", 1L);
        Update update2 = BatchingMultipleIndexPopulatorTest.nodeUpdate(2, 1, "bar", 1L);
        Update update3 = BatchingMultipleIndexPopulatorTest.nodeUpdate(3, 1, "baz", 1L);
        Update update42 = BatchingMultipleIndexPopulatorTest.nodeUpdate(4, 42, "42", 42L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update42);
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults());
        IndexPopulator populator1 = this.addPopulator(batchingPopulator, this.index1);
        IndexPopulator populator42 = this.addPopulator(batchingPopulator, this.index42);
        batchingPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        ((IndexPopulator)Mockito.verify((Object)populator1)).add((Collection)ArgumentMatchers.eq(BatchingMultipleIndexPopulatorTest.forUpdates(this.index1, update1, update2, update3)), (CursorContext)ArgumentMatchers.any());
        ((IndexPopulator)Mockito.verify((Object)populator42)).add((Collection)ArgumentMatchers.eq(BatchingMultipleIndexPopulatorTest.forUpdates(this.index42, update42)), (CursorContext)ArgumentMatchers.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void populatorMarkedAsFailed() throws Exception {
        IndexPopulator populator;
        Update update1 = BatchingMultipleIndexPopulatorTest.nodeUpdate(1, 1, "aaa", 1L);
        Update update2 = BatchingMultipleIndexPopulatorTest.nodeUpdate(1, 1, "bbb", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler(executor);
        try {
            MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (JobScheduler)jobScheduler, (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults((Setting)GraphDatabaseInternalSettings.index_population_batch_max_byte_size, (Object)1L));
            populator = this.addPopulator(batchingPopulator, this.index1);
            List<IndexEntryUpdate<IndexDescriptor>> expected = BatchingMultipleIndexPopulatorTest.forUpdates(this.index1, update1, update2);
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{batchFlushError}).when((Object)populator)).add((Collection)ArgumentMatchers.eq(expected), (CursorContext)ArgumentMatchers.any());
            batchingPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        }
        finally {
            jobScheduler.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
    }

    private static List<IndexEntryUpdate<IndexDescriptor>> forUpdates(IndexDescriptor index, Update ... updates) {
        List entityUpdates = Arrays.stream(updates).map(update -> EntityUpdates.forEntity((long)update.id, (boolean)true).withTokens(update.labels).added(update.propertyId, update.propertyValue).build()).collect(Collectors.toList());
        return Iterables.asList((Iterable)Iterables.concat((Iterable)Iterables.map(update -> update.valueUpdatesForIndexKeys(Iterables.asIterable((Object[])new IndexDescriptor[]{index})), entityUpdates)));
    }

    private static Update nodeUpdate(int nodeId, int propertyId, String propertyValue, long ... labelIds) {
        return new Update(nodeId, labelIds, propertyId, (Value)Values.stringValue((String)propertyValue));
    }

    private IndexPopulator addPopulator(MultipleIndexPopulator batchingPopulator, IndexDescriptor descriptor) {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        ValueIndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(descriptor, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (TokenNameLookup)this.tokens);
        batchingPopulator.addPopulator(populator, (IndexProxyStrategy)indexProxyStrategy, flipper, failedIndexProxyFactory);
        return populator;
    }

    private static IndexStoreView newStoreView(Update ... updates) {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (PropertyScanConsumer)ArgumentMatchers.any(), (TokenScanConsumer)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenAnswer(invocation -> {
            PropertyScanConsumer consumerArg = (PropertyScanConsumer)invocation.getArgument(2);
            return new IndexEntryUpdateScan(updates, consumerArg);
        });
        Mockito.when((Object)storeView.newPropertyAccessor((CursorContext)ArgumentMatchers.any(CursorContext.class), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
        return storeView;
    }

    private static class Update {
        private final long id;
        private final long[] labels;
        private final int propertyId;
        private final Value propertyValue;

        private Update(long id, long[] labels, int propertyId, Value propertyValue) {
            this.id = id;
            this.labels = labels;
            this.propertyId = propertyId;
            this.propertyValue = propertyValue;
        }
    }

    private static class IndexEntryUpdateScan
    implements StoreScan {
        final Update[] updates;
        final PropertyScanConsumer consumer;
        boolean stop;

        IndexEntryUpdateScan(Update[] updates, PropertyScanConsumer consumer) {
            this.updates = updates;
            this.consumer = consumer;
        }

        public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
            if (this.stop) {
                return;
            }
            PropertyScanConsumer.Batch batch = this.consumer.newBatch();
            Arrays.stream(this.updates).forEach(update -> batch.addRecord(update.id, update.labels, Map.of(update.propertyId, update.propertyValue)));
            batch.process();
        }

        public void stop() {
            this.stop = true;
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.NONE;
        }
    }
}

