/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.apache.commons.lang3.mutable.MutableObject;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.MockIndexProviderMap;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.NodeIdsIndexReaderQueryAnswer;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.Barrier;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class IndexingServiceTest {
    private final LifeSupport life = new LifeSupport();
    private static final IndexProviderDescriptor native30Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE30.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE30.providerVersion());
    private static final IndexProviderDescriptor nativeBtree10Descriptor = new IndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion());
    private static final IndexProviderDescriptor fulltextDescriptor = new IndexProviderDescriptor("fulltext", "1.0");
    private static final IndexProviderDescriptor tokenDescriptor = new IndexProviderDescriptor("token-lookup", "1.0");
    private static final IndexProviderDescriptor textDescriptor = new IndexProviderDescriptor("text", "1.0");
    private static final IndexProviderDescriptor[] indexProviderDescriptors = new IndexProviderDescriptor[]{native30Descriptor, nativeBtree10Descriptor, fulltextDescriptor};
    private final SchemaState schemaState = (SchemaState)Mockito.mock(SchemaState.class);
    private final int labelId = 7;
    private final int propertyKeyId = 15;
    private final int uniquePropertyKeyId = 15;
    private final IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)7, (int[])new int[]{15})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index");
    private final IndexDescriptor index = this.prototype.materialise(0L);
    private final IndexPrototype uniqueIndex = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)7, (int[])new int[]{15})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("constraint");
    private final IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class, (Answer)Mockito.RETURNS_MOCKS);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final IndexStoreViewFactory storeViewFactory = (IndexStoreViewFactory)Mockito.mock(IndexStoreViewFactory.class);
    private final NodePropertyAccessor propertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
    private final InMemoryTokens nameLookup = new InMemoryTokens();
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
    private final JobScheduler scheduler = JobSchedulerFactory.createScheduler();

    IndexingServiceTest() {
    }

    @BeforeEach
    void setUp() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.populator.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)new IndexSample());
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample());
        Mockito.when((Object)this.storeViewFactory.createTokenIndexStoreView((IndexingService.IndexProxyProvider)ArgumentMatchers.any())).thenReturn((Object)this.storeView);
        Mockito.when((Object)this.storeView.newPropertyAccessor((CursorContext)ArgumentMatchers.any(CursorContext.class), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)this.propertyAccessor);
        ValueIndexReader indexReader = (ValueIndexReader)Mockito.mock(ValueIndexReader.class);
        IndexSampler indexSampler = (IndexSampler)Mockito.mock(IndexSampler.class);
        Mockito.when((Object)indexSampler.sampleIndex((CursorContext)ArgumentMatchers.any())).thenReturn((Object)new IndexSample());
        Mockito.when((Object)indexReader.createSampler()).thenReturn((Object)indexSampler);
        Mockito.when((Object)this.accessor.newValueReader()).thenReturn((Object)indexReader);
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
    }

    @Test
    void noMessagesWhenThereIsNoIndexes() throws Throwable {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        indexingService.start();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).doesNotHaveAnyLogs();
    }

    @Test
    void shouldBringIndexOnlineAndFlipOverToIndexAccessor() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        IndexProxy proxy = indexingService.getIndexProxy(this.index);
        IndexingServiceTest.waitForIndexesToComeOnline(indexingService, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L))).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process(this.add(10L, "foo"));
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater((IndexUpdateMode)ArgumentMatchers.eq((Object)IndexUpdateMode.ONLINE_IDEMPOTENT), (CursorContext)ArgumentMatchers.any());
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    void indexCreationShouldBeIdempotent() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        IndexingServiceTest.waitForIndexesToComeOnline(indexingService, this.index);
    }

    @Test
    void shouldDeliverUpdatesThatOccurDuringPopulationToPopulator() throws Exception {
        Mockito.when((Object)this.populator.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.eq((Object)this.propertyAccessor), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)this.updater);
        final CountDownLatch populationLatch = new CountDownLatch(1);
        final Barrier.Control populationStartBarrier = new Barrier.Control();
        IndexMonitor.MonitorAdapter monitor = new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanStarting() {
                populationStartBarrier.reached();
            }

            public void indexPopulationScanComplete() {
                try {
                    populationLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Index population monitor was interrupted", e);
                }
            }
        };
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(1L, "value1")), (IndexMonitor)monitor, new IndexDescriptor[0]);
        this.life.start();
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        IndexProxy proxy = indexingService.getIndexProxy(this.index);
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        populationStartBarrier.await();
        populationStartBarrier.release();
        IndexEntryUpdate<IndexDescriptor> value2 = this.add(2L, "value2");
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process(value2);
        }
        populationLatch.countDown();
        IndexingServiceTest.waitForIndexesToComeOnline(indexingService, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).includeSample(this.add(1L, "value1"));
        ((IndexPopulator)order.verify((Object)this.populator, Mockito.times((int)1))).add((Collection)ArgumentMatchers.any(Collection.class), (CursorContext)ArgumentMatchers.any(CursorContext.class));
        ((IndexPopulator)order.verify((Object)this.populator)).scanCompleted((PhaseTracker)ArgumentMatchers.any(PhaseTracker.class), (IndexPopulator.PopulationWorkScheduler)ArgumentMatchers.any(IndexPopulator.PopulationWorkScheduler.class), (CursorContext)ArgumentMatchers.any(CursorContext.class));
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.eq((Object)this.propertyAccessor), (CursorContext)ArgumentMatchers.any());
        ((IndexPopulator)order.verify((Object)this.populator)).includeSample((IndexEntryUpdate)ArgumentMatchers.any());
        ((IndexUpdater)order.verify((Object)this.updater)).process((IndexEntryUpdate)ArgumentMatchers.any());
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).sample((CursorContext)ArgumentMatchers.any());
        ((IndexPopulator)order.verify((Object)this.populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updater});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.accessor});
    }

    @Test
    void shouldStillReportInternalIndexStateAsPopulatingWhenConstraintIndexIsDonePopulating() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)this.updater);
        ValueIndexReader indexReader = (ValueIndexReader)Mockito.mock(ValueIndexReader.class);
        Mockito.when((Object)this.accessor.newValueReader()).thenReturn((Object)indexReader);
        ((ValueIndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(this.index, new long[0])).when((Object)indexReader)).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        this.life.start();
        IndexDescriptor index = IndexingServiceTest.constraintIndexRule(0L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{index});
        IndexProxy proxy = indexingService.getIndexProxy(index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)20000L))).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process(this.add(10L, "foo"));
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater((IndexUpdateMode)ArgumentMatchers.eq((Object)IndexUpdateMode.ONLINE), (CursorContext)ArgumentMatchers.any());
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    void shouldBringConstraintIndexOnlineWhenExplicitlyToldTo() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        this.life.start();
        IndexDescriptor index = IndexingServiceTest.constraintIndexRule(0L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{index});
        IndexProxy proxy = indexingService.getIndexProxy(index);
        indexingService.activateIndex(index);
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any(CursorContext.class));
    }

    @Test
    void shouldLogIndexStateOnInit() throws Exception {
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        IndexProviderMap providerMap = (IndexProviderMap)this.life.add((Lifecycle)new MockIndexProviderMap(provider));
        IndexDescriptor onlineIndex = IndexingServiceTest.storeIndex(1L, 1, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(2L, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(3L, 2, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreViewFactory)((IndexStoreViewFactory)Mockito.mock(IndexStoreViewFactory.class)), (TokenNameLookup)this.nameLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexMonitor)IndexMonitor.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable()));
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)onlineIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)populatingIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)failedIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.FAILED);
        this.nameLookup.label(1, "LabelOne");
        this.nameLookup.label(2, "LabelTwo");
        this.nameLookup.propertyKey(1, "propertyOne");
        this.nameLookup.propertyKey(2, "propertyTwo");
        this.life.init();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"IndexingService.init: index 1 on (:LabelOne {propertyOne}) is ONLINE", "IndexingService.init: index 2 on (:LabelOne {propertyTwo}) is POPULATING", "IndexingService.init: index 3 on (:LabelTwo {propertyTwo}) is FAILED"});
    }

    @Test
    void shouldLogIndexStateOnStart() throws Throwable {
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        MockIndexProviderMap providerMap = new MockIndexProviderMap(provider);
        providerMap.init();
        IndexDescriptor onlineIndex = IndexingServiceTest.storeIndex(1L, 1, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(2L, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(3L, 2, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreViewFactory)this.storeViewFactory, (TokenNameLookup)this.nameLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexMonitor)IndexMonitor.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable());
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)onlineIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)populatingIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)failedIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.FAILED);
        indexingService.init();
        this.nameLookup.label(1, "LabelOne");
        this.nameLookup.label(2, "LabelTwo");
        this.nameLookup.propertyKey(1, "propertyOne");
        this.nameLookup.propertyKey(2, "propertyTwo");
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample(100L, 32L, 32L));
        this.internalLogProvider.clear();
        indexingService.start();
        ((IndexProvider)Mockito.verify((Object)provider)).getPopulationFailure((IndexDescriptor)ArgumentMatchers.eq((Object)failedIndex), (CursorContext)ArgumentMatchers.any());
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"IndexingService.start: index 1 on (:LabelOne {propertyOne}) is ONLINE", "IndexingService.start: index 2 on (:LabelOne {propertyTwo}) is POPULATING", "IndexingService.start: index 3 on (:LabelTwo {propertyTwo}) is FAILED"});
    }

    @Test
    void shouldFailToStartIfMissingIndexProvider() throws Exception {
        String otherProviderKey = "something-completely-different";
        IndexProviderDescriptor otherDescriptor = new IndexProviderDescriptor(otherProviderKey, "no-version");
        IndexDescriptor rule = IndexingServiceTest.storeIndex(1L, 2, 3, otherDescriptor);
        this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), (IndexAccessor)Mockito.mock(IndexAccessor.class), new DataUpdates(), rule);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((LifeSupport)this.life).init()).isInstanceOf(LifecycleException.class)).hasMessageContaining("lookup by descriptor failed");
    }

    @Test
    void shouldSnapshotOnlineIndexes() throws Exception {
        int indexId = 1;
        int indexId2 = 2;
        IndexDescriptor rule1 = IndexingServiceTest.storeIndex(indexId, 2, 3, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor rule2 = IndexingServiceTest.storeIndex(indexId2, 4, 5, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), indexAccessor, new DataUpdates(), rule1, rule2);
        Path theFile = Path.of("Blah", new String[0]);
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(IndexingServiceTest.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState(rule1, CursorContext.NULL)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getInitialState(rule2, CursorContext.NULL)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample(100L, 32L, 32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotIndexFiles();
        LogAssertions.assertThat((Iterable)Iterators.asCollection((Iterator)files)).isEqualTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object[])new Path[]{theFile, theFile})));
    }

    @Test
    void shouldNotSnapshotPopulatingIndexes() throws Exception {
        CountDownLatch populatorLatch = new CountDownLatch(1);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        int indexId = 1;
        int indexId2 = 2;
        IndexDescriptor index1 = IndexingServiceTest.storeIndex(indexId, 2, 3, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index2 = IndexingServiceTest.storeIndex(indexId2, 4, 5, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, indexAccessor, new DataUpdates(), index1, index2);
        Path theFile = Path.of("Blah", new String[0]);
        ((IndexPopulator)Mockito.doAnswer(IndexingServiceTest.waitForLatch(populatorLatch)).when((Object)this.populator)).create();
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(IndexingServiceTest.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)index1), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)index2), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample(100L, 32L, 32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotIndexFiles();
        populatorLatch.countDown();
        IndexingServiceTest.waitForIndexesToComeOnline(indexing, index1, index2);
        LogAssertions.assertThat((Iterable)Iterators.asCollection((Iterator)files)).isEqualTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object)theFile)));
    }

    @Test
    void shouldIgnoreActivateCallDuringRecovery() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index").materialise(0L);
        indexingService.activateIndex(index);
    }

    @Test
    void shouldLogTriggerSamplingOnAllIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        IndexSamplingMode mode = IndexSamplingMode.backgroundRebuildAll();
        indexingService.triggerIndexSampling(mode);
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Manual trigger for sampling all indexes [" + mode + "]"});
    }

    @Test
    void shouldLogTriggerSamplingOnAnIndexes() throws Exception {
        long indexId = 0L;
        IndexSamplingMode mode = IndexSamplingMode.backgroundRebuildAll();
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index");
        IndexDescriptor index = prototype.materialise(indexId);
        Mockito.when((Object)this.accessor.newValueReader()).thenReturn((Object)ValueIndexReader.EMPTY);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), index);
        this.life.init();
        this.life.start();
        indexingService.triggerIndexSampling(index, mode);
        String userDescription = index.userDescription((TokenNameLookup)this.nameLookup);
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Manual trigger for sampling index " + userDescription + " [" + mode + "]"});
    }

    @Test
    void applicationOfIndexUpdatesShouldThrowIfServiceIsShutdown() throws IOException {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        this.life.start();
        this.life.shutdown();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> indexingService.applyUpdates((Iterable)Iterators.asSet((Object[])new IndexEntryUpdate[]{this.add(1L, "foo")}), CursorContext.NULL));
        LogAssertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"Can't apply index updates");
    }

    @Test
    void applicationOfUpdatesShouldFlush() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)this.updater);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        this.life.start();
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        IndexingServiceTest.waitForIndexesToComeOnline(indexing, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L))).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        indexing.applyUpdates(Arrays.asList(this.add(1L, "foo"), this.add(2L, "bar")), CursorContext.NULL);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.updater});
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(1L, "foo"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(2L, "bar"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).close();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void closingOfValidatedUpdatesShouldCloseUpdaters() throws Exception {
        long indexId1 = 1L;
        long indexId2 = 2L;
        int labelId1 = 24;
        int labelId2 = 42;
        IndexDescriptor index1 = IndexingServiceTest.storeIndex(indexId1, labelId1, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index2 = IndexingServiceTest.storeIndex(indexId2, labelId2, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        IndexAccessor accessor1 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor1.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)updater1);
        IndexAccessor accessor2 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor2.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)updater2);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.eq((Object)index1), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor1);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.eq((Object)index2), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor2);
        this.life.start();
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{index1});
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{index2});
        IndexingServiceTest.waitForIndexesToComeOnline(indexing, index1, index2);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
        indexing.applyUpdates(Arrays.asList(IndexingServiceTest.add(1L, "foo", index1), IndexingServiceTest.add(2L, "bar", index2)), CursorContext.NULL);
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
    }

    private static void waitForIndexesToComeOnline(IndexingService indexing, IndexDescriptor ... index) throws IndexNotFoundKernelException {
        IndexingServiceTest.waitForIndexesToGetIntoState(indexing, InternalIndexState.ONLINE, index);
    }

    private static void waitForIndexesToGetIntoState(IndexingService indexing, InternalIndexState state, IndexDescriptor ... indexes) throws IndexNotFoundKernelException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (!IndexingServiceTest.allInState(indexing, state, indexes)) {
            if (System.currentTimeMillis() <= end) continue;
            org.junit.jupiter.api.Assertions.fail((String)"Indexes couldn't come online");
        }
    }

    private static boolean allInState(IndexingService indexing, InternalIndexState state, IndexDescriptor[] indexes) throws IndexNotFoundKernelException {
        for (IndexDescriptor index : indexes) {
            if (indexing.getIndexProxy(index).getState() == state) continue;
            return false;
        }
        return true;
    }

    private Iterable<IndexEntryUpdate<IndexDescriptor>> nodeIdsAsIndexUpdates(long ... nodeIds) {
        return () -> {
            ArrayList<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
            for (long nodeId : nodeIds) {
                updates.add(IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{Values.of((Object)1)}));
            }
            return updates.iterator();
        };
    }

    @Test
    void shouldNotLoseIndexDescriptorDueToOtherSimilarIndexDuringRecovery() throws Exception {
        long nodeId = 0L;
        long otherIndexId = 2L;
        Update update = this.addNodeUpdate(nodeId, "value");
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample(100L, 42L, 42L));
        IndexAccessor accessor = (IndexAccessor)Mockito.spy((Object)((Object)new TrackingIndexAccessor()));
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, accessor, IndexingServiceTest.withData(update), this.index);
        Mockito.when((Object)this.indexProvider.getInitialState(this.index, CursorContext.NULL)).thenReturn((Object)InternalIndexState.ONLINE);
        this.life.init();
        IndexDescriptor otherIndex = this.prototype.withName("index_" + otherIndexId).materialise(otherIndexId);
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{otherIndex});
        indexing.dropIndex(otherIndex);
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        Mockito.reset((Object[])new IndexAccessor[]{accessor});
        indexing.applyUpdates(this.nodeIdsAsIndexUpdates(nodeId), CursorContext.NULL);
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor)).newUpdater((IndexUpdateMode)ArgumentMatchers.eq((Object)IndexUpdateMode.RECOVERY), (CursorContext)ArgumentMatchers.any(CursorContext.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotLoseIndexDescriptorDueToOtherVerySimilarIndexDuringRecovery() throws Exception {
        AtomicReference<BinaryLatch> populationStartLatch = this.latchedIndexPopulation();
        long nodeId = 0L;
        Update update = this.addNodeUpdate(nodeId, "value");
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample(100L, 42L, 42L));
        IndexAccessor accessor = (IndexAccessor)Mockito.spy((Object)((Object)new TrackingIndexAccessor()));
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, accessor, IndexingServiceTest.withData(update), this.index);
        Mockito.when((Object)this.indexProvider.getInitialState(this.index, CursorContext.NULL)).thenReturn((Object)InternalIndexState.ONLINE);
        this.life.init();
        populationStartLatch.getAndSet(new BinaryLatch()).release();
        IndexConfig indexConfig = this.index.getIndexConfig().withIfAbsent("a", (Value)Values.booleanValue((boolean)true));
        IndexDescriptor otherIndex = this.index.withIndexConfig(indexConfig);
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{otherIndex});
        indexing.dropIndex(otherIndex);
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        Mockito.reset((Object[])new IndexAccessor[]{accessor});
        indexing.applyUpdates(this.nodeIdsAsIndexUpdates(nodeId), CursorContext.NULL);
        this.life.start();
        IndexProxy indexProxy = indexing.getIndexProxy(this.index);
        try {
            org.junit.jupiter.api.Assertions.assertNull((Object)indexProxy.getDescriptor().getIndexConfig().get("a"));
            LogAssertions.assertThat((Comparable)indexProxy.getState()).isEqualTo((Object)InternalIndexState.POPULATING);
        }
        finally {
            populationStartLatch.get().release();
        }
    }

    @Test
    void shouldWaitForRecoveredUniquenessConstraintIndexesToBeFullyPopulated() throws Exception {
        final DoubleLatch latch = new DoubleLatch();
        ControlledIndexPopulator populator = new ControlledIndexPopulator(latch);
        final AtomicReference indexRef = new AtomicReference();
        IndexMonitor.MonitorAdapter monitor = new IndexMonitor.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(IndexDescriptor descriptor) {
                indexRef.set(descriptor);
                latch.startAndWaitForAllToStart();
            }
        };
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(0L, "value", 1)), (IndexMonitor)monitor, new IndexDescriptor[0]);
        this.life.init();
        long fakeOwningConstraintRuleId = 1L;
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{IndexingServiceTest.constraintIndexRule(2L, 7, 15, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, fakeOwningConstraintRuleId)});
        this.life.start();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((IndexDescriptor)indexRef.get()).getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexing.getIndexProxy((IndexDescriptor)indexRef.get()).getState());
    }

    @Test
    void shouldCreateMultipleIndexesInOneCall() throws Exception {
        IndexMonitor monitor = IndexMonitor.NO_MONITOR;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(this.addNodeUpdate(0L, "value", 1)), monitor, new IndexDescriptor[0]);
        this.life.start();
        IndexDescriptor index1 = IndexingServiceTest.storeIndex(0L, 0, 0, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index2 = IndexingServiceTest.storeIndex(1L, 0, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexDescriptor index3 = IndexingServiceTest.storeIndex(2L, 1, 0, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{index1, index2, index3});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.eq((Object)prototype.withName("index_0").materialise(0L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.eq((Object)prototype.withSchemaDescriptor((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1})).withName("index_1").materialise(1L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        ((IndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.eq((Object)prototype.withSchemaDescriptor((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{0})).withName("index_2").materialise(2L)), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class));
        IndexingServiceTest.waitForIndexesToComeOnline(indexing, index1, index2, index3);
    }

    @Test
    void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterPopulating() throws Exception {
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), new IndexDescriptor[0]);
        IOException exception = new IOException("Expected failure");
        this.nameLookup.label(7, "TheLabel");
        this.nameLookup.propertyKey(15, "propertyKey");
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        indexing.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{this.index});
        IndexingServiceTest.waitForIndexesToGetIntoState(indexing, InternalIndexState.FAILED, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue(), (CursorContext)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(this.index).getState());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        LogAssertions.assertThat((String)this.storedFailure()).contains(new CharSequence[]{String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])});
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.ERROR).assertExceptionForLogMessage("Failed to populate index: [Index( id=0, name='index', type='GENERAL BTREE', schema=(:TheLabel {propertyKey}), indexProvider='quantum-dex-25.0' )]").hasRootCause((Throwable)exception);
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.INFO).doesNotContainMessageWithArguments("Index population completed. Index is now online: [%s]", new Object[]{"Index( id=0, name='index', type='GENERAL BTREE', schema=(:TheLabel {propertyKey}), indexProvider='quantum-dex-25.0' )"});
    }

    @Test
    void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterRecoveringPopulatingIndex() throws Exception {
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), this.index);
        IOException exception = new IOException("Expected failure");
        this.nameLookup.label(7, "TheLabel");
        this.nameLookup.propertyKey(15, "propertyKey");
        Mockito.when((Object)this.indexProvider.getInitialState(this.index, CursorContext.NULL)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        IndexingServiceTest.waitForIndexesToGetIntoState(indexing, InternalIndexState.FAILED, this.index);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)10000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue(), (CursorContext)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(this.index).getState());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        LogAssertions.assertThat((String)this.storedFailure()).contains(new CharSequence[]{String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])});
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.ERROR).assertExceptionForLogMessage("Failed to populate index: [Index( id=0, name='index', type='GENERAL BTREE', schema=(:TheLabel {propertyKey}), indexProvider='quantum-dex-25.0' )]").hasRootCause((Throwable)exception);
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.INFO).doesNotContainMessageWithArguments("Index population completed. Index is now online: [%s]", new Object[]{"Index( id=0, name='index', type='GENERAL BTREE', schema=(:TheLabel {propertyKey}), indexProvider='quantum-dex-25.0' )"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void constraintIndexesWithoutConstraintsMustGetPopulatingProxies() throws Exception {
        AtomicReference<BinaryLatch> populationStartLatch = this.latchedIndexPopulation();
        try {
            long indexId = 1L;
            IndexDescriptor index = this.uniqueIndex.materialise(indexId);
            IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), index);
            Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)index), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
            this.life.start();
            org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)indexing.getIndexProxy(index).getState());
        }
        finally {
            populationStartLatch.get().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReportCauseOfPopulationFailureIfPopulationFailsDuringRecovery() throws Exception {
        long indexId = 1L;
        long constraintId = 2L;
        IndexDescriptor indexRule = this.uniqueIndex.materialise(indexId).withOwningConstraintId(constraintId);
        final Barrier.Control barrier = new Barrier.Control();
        CountDownLatch exceptionBarrier = new CountDownLatch(1);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), (IndexMonitor)new IndexMonitor.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(IndexDescriptor descriptor) {
                barrier.reached();
            }
        }, indexRule);
        Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)indexRule), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        this.life.init();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(() -> {
                try {
                    this.life.start();
                }
                finally {
                    exceptionBarrier.countDown();
                }
            });
            barrier.await();
            IndexingServiceTest.waitForIndexesToComeOnline(indexing, indexRule);
            IndexProxy indexProxy = indexing.getIndexProxy(indexRule);
            LogAssertions.assertThat((Object)indexProxy).isInstanceOf(ContractCheckingIndexProxy.class);
            ContractCheckingIndexProxy contractCheckingIndexProxy = (ContractCheckingIndexProxy)indexProxy;
            IndexProxy delegate = contractCheckingIndexProxy.getDelegate();
            LogAssertions.assertThat((Object)delegate).isInstanceOf(FlippableIndexProxy.class);
            FlippableIndexProxy flippableIndexProxy = (FlippableIndexProxy)delegate;
            Exception expectedCause = new Exception("index was failed on purpose");
            IndexPopulationFailure indexFailure = IndexPopulationFailure.failure((Throwable)expectedCause);
            flippableIndexProxy.flipTo((IndexProxy)new FailedIndexProxy((IndexProxyStrategy)new ValueIndexProxyStrategy(indexRule, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (TokenNameLookup)this.nameLookup), (MinimalIndexAccessor)Mockito.mock(IndexPopulator.class), indexFailure, (LogProvider)this.internalLogProvider));
            barrier.release();
            exceptionBarrier.await();
            LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).containsMessages(new String[]{expectedCause.getMessage()}).containsMessages(new String[]{String.format("Index %s entered %s state ", indexRule, InternalIndexState.FAILED)});
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldLogIndexStateOutliersOnInit() throws Exception {
        int i;
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        IndexProviderMap providerMap = (IndexProviderMap)this.life.add((Lifecycle)new MockIndexProviderMap(provider));
        ArrayList<IndexDescriptor> indexes = new ArrayList<IndexDescriptor>();
        int nextIndexId = 1;
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)populatingIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        indexes.add(populatingIndex);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)failedIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.FAILED);
        indexes.add(failedIndex);
        for (i = 0; i < 10; ++i) {
            IndexDescriptor indexRule = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)indexRule), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
            indexes.add(indexRule);
        }
        for (i = 0; i < nextIndexId; ++i) {
            this.nameLookup.label(i, "Label" + i);
        }
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreViewFactory)((IndexStoreViewFactory)Mockito.mock(IndexStoreViewFactory.class)), (TokenNameLookup)this.nameLookup, indexes, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexMonitor)IndexMonitor.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable()));
        this.nameLookup.propertyKey(1, "prop");
        this.life.init();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"IndexingService.init: index 1 on (:Label1 {prop}) is POPULATING", "IndexingService.init: index 2 on (:Label2 {prop}) is FAILED", "IndexingService.init: indexes not specifically mentioned above are ONLINE"}).doesNotContainMessage("IndexingService.init: index 3 on :Label3(prop) is ONLINE");
    }

    @Test
    void shouldLogIndexStateOutliersOnStart() throws Throwable {
        int i;
        IndexProvider provider = IndexingServiceTest.mockIndexProviderWithAccessor(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name());
        MockIndexProviderMap providerMap = new MockIndexProviderMap(provider);
        providerMap.init();
        ArrayList<IndexDescriptor> indexes = new ArrayList<IndexDescriptor>();
        int nextIndexId = 1;
        IndexDescriptor populatingIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)populatingIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        indexes.add(populatingIndex);
        IndexDescriptor failedIndex = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)failedIndex), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.FAILED);
        indexes.add(failedIndex);
        for (i = 0; i < 10; ++i) {
            IndexDescriptor indexRule = IndexingServiceTest.storeIndex(nextIndexId, nextIndexId++, 1, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            Mockito.when((Object)provider.getInitialState((IndexDescriptor)ArgumentMatchers.eq((Object)indexRule), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
            indexes.add(indexRule);
        }
        for (i = 0; i < nextIndexId; ++i) {
            this.nameLookup.label(i, "Label" + i);
        }
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (IndexProviderMap)providerMap, (IndexStoreViewFactory)this.storeViewFactory, (TokenNameLookup)this.nameLookup, indexes, (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexMonitor)IndexMonitor.NO_MONITOR, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable());
        Mockito.when((Object)this.indexStatisticsStore.indexSample(ArgumentMatchers.anyLong())).thenReturn((Object)new IndexSample(100L, 32L, 32L));
        this.nameLookup.propertyKey(1, "prop");
        indexingService.init();
        this.internalLogProvider.clear();
        indexingService.start();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"IndexingService.start: index 1 on (:Label1 {prop}) is POPULATING", "IndexingService.start: index 2 on (:Label2 {prop}) is FAILED", "IndexingService.start: indexes not specifically mentioned above are ONLINE"}).doesNotContainMessage("IndexingService.start: index 3 on :Label3(prop) is ONLINE");
    }

    @Test
    void flushAllIndexesWhileSomeOfThemDropped() throws IOException {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxy validIndex1 = IndexingServiceTest.createIndexProxyMock(1L);
        IndexProxy validIndex2 = IndexingServiceTest.createIndexProxyMock(2L);
        IndexProxy deletedIndexProxy = IndexingServiceTest.createIndexProxyMock(3L);
        IndexProxy validIndex3 = IndexingServiceTest.createIndexProxyMock(4L);
        IndexProxy validIndex4 = IndexingServiceTest.createIndexProxyMock(5L);
        indexMapReference.modify(indexMap -> {
            indexMap.putIndexProxy(validIndex1);
            indexMap.putIndexProxy(validIndex2);
            indexMap.putIndexProxy(deletedIndexProxy);
            indexMap.putIndexProxy(validIndex3);
            indexMap.putIndexProxy(validIndex4);
            return indexMap;
        });
        ((IndexProxy)Mockito.doAnswer(invocation -> {
            indexMapReference.modify(indexMap -> {
                indexMap.removeIndexProxy(3L);
                return indexMap;
            });
            throw new RuntimeException("Index deleted.");
        }).when((Object)deletedIndexProxy)).force((CursorContext)ArgumentMatchers.any(CursorContext.class));
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        indexingService.forceAll(CursorContext.NULL);
        ((IndexProxy)Mockito.verify((Object)validIndex1)).force(CursorContext.NULL);
        ((IndexProxy)Mockito.verify((Object)validIndex2)).force(CursorContext.NULL);
        ((IndexProxy)Mockito.verify((Object)validIndex3)).force(CursorContext.NULL);
        ((IndexProxy)Mockito.verify((Object)validIndex4)).force(CursorContext.NULL);
    }

    @Test
    void failForceAllWhenOneOfTheIndexesFailToForce() throws IOException {
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxy strangeIndexProxy = IndexingServiceTest.createIndexProxyMock(1L);
        ((IndexProxy)Mockito.doThrow((Throwable[])new Throwable[]{new UncheckedIOException(new IOException("Can't force"))}).when((Object)strangeIndexProxy)).force((CursorContext)ArgumentMatchers.any(CursorContext.class));
        indexMapReference.modify(indexMap -> {
            IndexProxy validIndex = IndexingServiceTest.createIndexProxyMock(0L);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(strangeIndexProxy);
            indexMap.putIndexProxy(validIndex);
            indexMap.putIndexProxy(validIndex);
            return indexMap;
        });
        IndexingService indexingService = this.createIndexServiceWithCustomIndexMap(indexMapReference);
        UnderlyingStorageException e = (UnderlyingStorageException)org.junit.jupiter.api.Assertions.assertThrows(UnderlyingStorageException.class, () -> indexingService.forceAll(CursorContext.NULL));
        LogAssertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"Unable to force");
    }

    @Test
    void shouldRefreshIndexesOnStart() throws Exception {
        this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), this.index);
        IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor.newValueReader()).thenReturn((Object)ValueIndexReader.EMPTY);
        Mockito.when((Object)accessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)updater);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        this.life.init();
        ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.never())).refresh();
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor)).refresh();
    }

    @Test
    void shouldNotHaveToWaitForOrphanedUniquenessIndexInRecovery() throws Exception {
        IndexDescriptor descriptor = this.uniqueIndex.materialise(10L);
        List<IndexDescriptor> schemaRules = Collections.singletonList(descriptor);
        IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        IndexProviderMap indexProviderMap = (IndexProviderMap)Mockito.mock(IndexProviderMap.class);
        Mockito.when((Object)indexProviderMap.lookup(ArgumentMatchers.anyString())).thenReturn((Object)indexProvider);
        Mockito.when((Object)indexProviderMap.lookup((IndexProviderDescriptor)ArgumentMatchers.any(IndexProviderDescriptor.class))).thenReturn((Object)indexProvider);
        Mockito.when((Object)indexProviderMap.getDefaultProvider()).thenReturn((Object)indexProvider);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexMapReference indexMapReference = new IndexMapReference();
        IndexProxyCreator indexProxyCreator = (IndexProxyCreator)Mockito.mock(IndexProxyCreator.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.POPULATING, (Object[])new InternalIndexState[]{InternalIndexState.POPULATING, InternalIndexState.POPULATING, InternalIndexState.POPULATING, InternalIndexState.ONLINE});
        Mockito.when((Object)indexProxyCreator.createRecoveringIndexProxy((IndexDescriptor)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxyCreator.createFailedIndexProxy((IndexDescriptor)ArgumentMatchers.any(), (IndexPopulationFailure)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxyCreator.createPopulatingIndexProxy((IndexDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IndexMonitor)ArgumentMatchers.any(), (IndexPopulationJob)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        IndexSamplingController samplingController = (IndexSamplingController)Mockito.mock(IndexSamplingController.class);
        IndexMonitor monitor = (IndexMonitor)Mockito.mock(IndexMonitor.class);
        IndexStoreViewFactory storeViewFactory = (IndexStoreViewFactory)Mockito.mock(IndexStoreViewFactory.class);
        Mockito.when((Object)storeViewFactory.createTokenIndexStoreView((IndexingService.IndexProxyProvider)ArgumentMatchers.any())).thenReturn((Object)this.storeView);
        Mockito.when((Object)this.storeView.newPropertyAccessor((CursorContext)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)this.propertyAccessor);
        IndexingService indexingService = new IndexingService(indexProxyCreator, indexProviderMap, indexMapReference, storeViewFactory, schemaRules, samplingController, (TokenNameLookup)this.nameLookup, scheduler, null, (LogProvider)logProvider, (LogProvider)logProvider, monitor, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", DatabaseReadOnlyChecker.writable(), Config.defaults());
        indexingService.init();
        indexingService.start();
        ((IndexProxy)Mockito.verify((Object)indexProxy, (VerificationMode)Mockito.never())).awaitStoreScanCompleted(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        ((IndexMonitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).awaitingPopulationOfRecoveredIndex((IndexDescriptor)ArgumentMatchers.any());
    }

    @Test
    public void shouldIncrementIndexUpdatesAfterStartingExistingOnlineIndexProxy() throws Exception {
        long indexId = 10L;
        IndexDescriptor indexDescriptor = this.uniqueIndex.materialise(indexId);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), indexDescriptor);
        this.life.start();
        IndexProxy proxy = indexingService.getIndexProxy(indexDescriptor);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)123L, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.stringValue((String)"some value")}));
        }
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).incrementIndexUpdates(indexId, 1L);
    }

    @Test
    public void shouldDropAndCreateIndexWithSameIdDuringRecovery() throws IOException {
        long indexId = 10L;
        IndexDescriptor indexDescriptor = this.uniqueIndex.materialise(indexId);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, IndexingServiceTest.withData(new Update[0]), indexDescriptor);
        this.life.init();
        indexingService.dropIndex(indexDescriptor);
        indexingService.createIndexes(Subject.AUTH_DISABLED, new IndexDescriptor[]{indexDescriptor});
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)this.accessor)).drop();
    }

    @Test
    void shouldHandleOpeningMismatchingIndex() throws Exception {
        Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)this.populator);
        IndexingServiceTest.withData(new Update[0]).getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.eq((Object)this.index), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenThrow(new Throwable[]{new IllegalStateException("Something unexpectedly wrong with the index here")});
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class), (StorageEngineFactory)ArgumentMatchers.any())).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        MockIndexProviderMap providerMap = (MockIndexProviderMap)this.life.add((Lifecycle)new MockIndexProviderMap(this.indexProvider));
        final AtomicBoolean populationStarted = new AtomicBoolean();
        final AtomicBoolean populationCompleted = new AtomicBoolean();
        final MutableObject initialState = new MutableObject();
        IndexMonitor.MonitorAdapter monitor = new IndexMonitor.MonitorAdapter(){

            public void initialState(String databaseName, IndexDescriptor descriptor, InternalIndexState state) {
                if (descriptor.equals((Object)IndexingServiceTest.this.index)) {
                    initialState.setValue((Object)state);
                }
            }

            public void indexPopulationScanStarting() {
                populationStarted.set(true);
            }

            public void populationCompleteOn(IndexDescriptor descriptor) {
                LogAssertions.assertThat((Object)descriptor).isEqualTo((Object)IndexingServiceTest.this.index);
                populationCompleted.set(true);
            }
        };
        IndexingService indexingService = (IndexingService)this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)Config.defaults(), (JobScheduler)((JobScheduler)this.life.add((Lifecycle)this.scheduler)), (IndexProviderMap)providerMap, (IndexStoreViewFactory)this.storeViewFactory, (TokenNameLookup)this.nameLookup, (Iterable)Iterators.loop((Iterator)Iterators.iterator((Object)this.index)), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexMonitor)monitor, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable()));
        this.life.init();
        LogAssertions.assertThat((boolean)populationStarted.get()).isFalse();
        LogAssertions.assertThat((boolean)populationCompleted.get()).isFalse();
        LogAssertions.assertThat((Comparable)((InternalIndexState)initialState.getValue())).isEqualTo((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.eq((Object)this.index), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)this.accessor);
        this.life.start();
        indexingService.getIndexProxy(this.index).awaitStoreScanCompleted(1L, TimeUnit.MINUTES);
        LogAssertions.assertThat((boolean)populationStarted.get()).isTrue();
        LogAssertions.assertThat((boolean)populationCompleted.get()).isTrue();
    }

    private AtomicReference<BinaryLatch> latchedIndexPopulation() {
        final AtomicReference<BinaryLatch> populationStartLatch = new AtomicReference<BinaryLatch>(new BinaryLatch());
        this.scheduler.setThreadFactory(Group.INDEX_POPULATION, (group, parent) -> new GroupedDaemonThreadFactory(group, parent){

            public Thread newThread(Runnable job) {
                return super.newThread(() -> {
                    ((BinaryLatch)populationStartLatch.get()).await();
                    job.run();
                });
            }
        });
        return populationStartLatch;
    }

    private static IndexProxy createIndexProxyMock(long indexId) {
        IndexProxy proxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexDescriptor descriptor = IndexingServiceTest.storeIndex(indexId, 1, 2, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)proxy.getDescriptor()).thenReturn((Object)descriptor);
        return proxy;
    }

    private String storedFailure() {
        ArgumentCaptor reason = ArgumentCaptor.forClass(String.class);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).markAsFailed((String)reason.capture());
        return (String)reason.getValue();
    }

    private static Answer<Void> waitForLatch(CountDownLatch latch) {
        return invocationOnMock -> {
            latch.await();
            return null;
        };
    }

    private static Answer<ResourceIterator<Path>> newResourceIterator(Path theFile) {
        return invocationOnMock -> Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)theFile));
    }

    private Update addNodeUpdate(long nodeId, Object propertyValue) {
        return this.addNodeUpdate(nodeId, propertyValue, 7);
    }

    private Update addNodeUpdate(long nodeId, Object propertyValue, int labelId) {
        return new Update(nodeId, new long[]{labelId}, this.prototype.schema().getPropertyId(), Values.of((Object)propertyValue));
    }

    private IndexEntryUpdate<IndexDescriptor> add(long nodeId, Object propertyValue) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{Values.of((Object)propertyValue)});
    }

    private static IndexEntryUpdate<IndexDescriptor> add(long nodeId, Object propertyValue, IndexDescriptor index) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)index, (Value[])new Value[]{Values.of((Object)propertyValue)});
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexDescriptor ... rules) throws IOException {
        return this.newIndexingServiceWithMockedDependencies(populator, accessor, data, IndexMonitor.NO_MONITOR, rules);
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexMonitor monitor, IndexDescriptor ... rules) throws IOException {
        Mockito.when((Object)this.indexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)populator);
        data.getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)accessor);
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class), (StorageEngineFactory)ArgumentMatchers.any())).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Config config = Config.newBuilder().set(GraphDatabaseSettings.default_schema_provider, (Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.name()).build();
        MockIndexProviderMap providerMap = (MockIndexProviderMap)this.life.add((Lifecycle)new MockIndexProviderMap(this.indexProvider));
        return (IndexingService)this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)this.life.add((Lifecycle)this.scheduler)), (IndexProviderMap)providerMap, (IndexStoreViewFactory)this.storeViewFactory, (TokenNameLookup)this.nameLookup, (Iterable)Iterators.loop((Iterator)Iterators.iterator((Object[])rules)), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, (IndexMonitor)monitor, (SchemaState)this.schemaState, (IndexStatisticsStore)this.indexStatisticsStore, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable()));
    }

    private static DataUpdates withData(Update ... updates) {
        return new DataUpdates(Arrays.asList(updates));
    }

    private static IndexDescriptor storeIndex(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor) {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexProvider(providerDescriptor).withName("index_" + ruleId).materialise(ruleId);
    }

    private static IndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor) {
        return IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexProvider(providerDescriptor).withName("constraint_" + ruleId).materialise(ruleId);
    }

    private static IndexDescriptor constraintIndexRule(long ruleId, int labelId, int propertyKeyId, IndexProviderDescriptor providerDescriptor, long constraintId) {
        return IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexProvider(providerDescriptor).withName("constraint_" + ruleId).materialise(ruleId).withOwningConstraintId(constraintId);
    }

    private IndexingService createIndexServiceWithCustomIndexMap(IndexMapReference indexMapReference) {
        return new IndexingService((IndexProxyCreator)Mockito.mock(IndexProxyCreator.class), (IndexProviderMap)Mockito.mock(IndexProviderMap.class), indexMapReference, (IndexStoreViewFactory)Mockito.mock(IndexStoreViewFactory.class), Collections.emptyList(), (IndexSamplingController)Mockito.mock(IndexSamplingController.class), (TokenNameLookup)this.nameLookup, (JobScheduler)Mockito.mock(JobScheduler.class), (SchemaState)Mockito.mock(SchemaState.class), (LogProvider)this.internalLogProvider, (LogProvider)this.userLogProvider, IndexMonitor.NO_MONITOR, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", DatabaseReadOnlyChecker.writable(), Config.defaults());
    }

    private static DependencyResolver buildIndexDependencies(IndexProvider ... providers) {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies((Object[])providers);
        dependencies.satisfyDependency((Object)IndexingServiceTest.tokenProvider());
        dependencies.satisfyDependency((Object)IndexingServiceTest.textProvider());
        return dependencies;
    }

    private static IndexProvider mockIndexProviderWithAccessor(IndexProviderDescriptor descriptor) throws IOException {
        IndexProvider provider = IndexingServiceTest.mockIndexProvider(descriptor);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)provider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class))).thenReturn((Object)indexAccessor);
        return provider;
    }

    private static IndexProvider mockIndexProvider(IndexProviderDescriptor descriptor) {
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)descriptor);
        return provider;
    }

    private static IndexProvider fulltextProvider() {
        return IndexingServiceTest.mockIndexProvider(fulltextDescriptor);
    }

    private static IndexProvider tokenProvider() {
        return IndexingServiceTest.mockIndexProvider(tokenDescriptor);
    }

    private static IndexProvider textProvider() {
        return IndexingServiceTest.mockIndexProvider(textDescriptor);
    }

    private void onBothLogProviders(Consumer<AssertableLogProvider> logProviderAction) {
        logProviderAction.accept(this.internalLogProvider);
        logProviderAction.accept(this.userLogProvider);
    }

    private static class Update {
        private final long id;
        private final long[] labels;
        private final int propertyId;
        private final Value propertyValue;

        private Update(long id, long[] labels, int propertyId, Value propertyValue) {
            this.id = id;
            this.labels = labels;
            this.propertyId = propertyId;
            this.propertyValue = propertyValue;
        }
    }

    private static class TrackingIndexAccessor
    extends IndexAccessor.Adapter {
        private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);

        private TrackingIndexAccessor() {
        }

        public void drop() {
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
            return this.updater;
        }

        public ValueIndexReader newValueReader() {
            throw new UnsupportedOperationException("Not required");
        }

        public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
            throw new UnsupportedOperationException("Not required");
        }

        public ResourceIterator<Path> snapshotFiles() {
            throw new UnsupportedOperationException("Not required");
        }
    }

    private static class DataUpdates
    implements Answer<StoreScan> {
        private final List<Update> updates;

        DataUpdates() {
            this.updates = List.of();
        }

        DataUpdates(List<Update> updates) {
            this.updates = updates;
        }

        void getsProcessedByStoreScanFrom(IndexStoreView mock) {
            Mockito.when((Object)mock.visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (PropertyScanConsumer)ArgumentMatchers.any(PropertyScanConsumer.class), (TokenScanConsumer)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(PageCacheTracer.class), (MemoryTracker)ArgumentMatchers.any())).thenAnswer((Answer)this);
        }

        public StoreScan answer(InvocationOnMock invocation) {
            final PropertyScanConsumer consumer = (PropertyScanConsumer)invocation.getArgument(2);
            return new StoreScan(){
                private volatile boolean stop;

                public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
                    if (this.stop || updates.isEmpty()) {
                        return;
                    }
                    PropertyScanConsumer.Batch batch = consumer.newBatch();
                    updates.forEach(update -> batch.addRecord(update.id, update.labels, Map.of(update.propertyId, update.propertyValue)));
                    batch.process();
                }

                public void stop() {
                    this.stop = true;
                }

                public PopulationProgress getProgress() {
                    return PopulationProgress.single((long)42L, (long)100L);
                }
            };
        }

        public String toString() {
            return this.updates.toString();
        }
    }

    private static class ControlledIndexPopulator
    extends IndexPopulator.Adapter {
        private final DoubleLatch latch;

        ControlledIndexPopulator(DoubleLatch latch) {
            this.latch = latch;
        }

        public void scanCompleted(PhaseTracker phaseTracker, IndexPopulator.PopulationWorkScheduler jobScheduler, CursorContext cursorContext) {
            this.latch.waitForAllToStart();
        }

        public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
            this.latch.finish();
        }
    }
}

