/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.AbstractLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.InlinedLogTailScanner;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;

@EphemeralPageCacheExtension
@EphemeralNeo4jLayoutExtension
abstract class AbstractLogTailScannerTest {
    @Inject
    protected FileSystemAbstraction fs;
    @Inject
    protected PageCache pageCache;
    @Inject
    protected DatabaseLayout databaseLayout;
    private final LogEntryReader reader = TestLogEntryReader.logEntryReader();
    private final Monitors monitors = new Monitors();
    protected LogFiles logFiles;
    protected AssertableLogProvider logProvider;
    protected LogVersionRepository logVersionRepository;
    protected TransactionIdStore transactionIdStore;

    AbstractLogTailScannerTest() {
    }

    private static Stream<Arguments> params() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{1, 2}), Arguments.arguments((Object[])new Object[]{42, 43}));
    }

    @BeforeEach
    void setUp() throws IOException {
        this.logVersionRepository = new SimpleLogVersionRepository();
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logProvider = new AssertableLogProvider();
        this.logFiles = this.createLogFiles();
    }

    protected abstract LogFiles createLogFiles() throws IOException;

    protected abstract void writeCheckpoint(LogEntryWriter var1, CheckpointFile var2, LogPosition var3) throws IOException;

    @Test
    void detectMissingLogFiles() {
        LogTailInformation tailInformation = this.logFiles.getTailInformation();
        Assertions.assertTrue((boolean)tailInformation.logsMissing());
        Assertions.assertTrue((boolean)tailInformation.isRecoveryRequired());
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void noLogFilesFound(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, new LogCreator[0]);
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, false, -1L, true, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void oneLogFileNoCheckPoints(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(new Entry[0]));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, false, -1L, false, logTailInformation);
        Assertions.assertFalse((boolean)logTailInformation.logsMissing());
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void oneLogFileNoCheckPointsOneStart(int startLogVersion, int endLogVersion) {
        long txId = 10L;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPoints(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(new Entry[0]));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPointsOneStart(int startLogVersion, int endLogVersion) {
        long txId = 21L;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPointsOneStartWithoutCommit(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(AbstractLogTailScannerTest.start()));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, true, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPointsTwoCommits(int startLogVersion, int endLogVersion) {
        long txId = 21L;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId), AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId + 1L)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesCheckPointTargetsPrevious(int startLogVersion, int endLogVersion) {
        long txId = 6L;
        PositionEntry position = AbstractLogTailScannerTest.position();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId - 1L), position), this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId)), this.logFile(AbstractLogTailScannerTest.checkPoint(position)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesStartAndCommitInDifferentFiles(int startLogVersion, int endLogVersion) {
        long txId = 6L;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start()), this.logFile(AbstractLogTailScannerTest.commit(txId)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(false, true, 6L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingACheckPointOnly(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.checkPoint()));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingACheckPointAndAStartBefore(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(1L), AbstractLogTailScannerTest.checkPoint()));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void bigFileLatestCheckpointFindsStartAfter(int startLogVersion, int endLogVersion) throws IOException {
        long firstTxAfterCheckpoint = 0x80000003L;
        FirstTxIdConfigurableTailScanner tailScanner = new FirstTxIdConfigurableTailScanner(firstTxAfterCheckpoint, this.logFiles, this.reader, this.monitors);
        LogEntryStart startEntry = new LogEntryStart(3L, 4L, 0, new byte[]{5, 6}, new LogPosition((long)endLogVersion, 0x80000010L));
        CheckpointInfo checkPoint = new CheckpointInfo(new LogPosition((long)endLogVersion, 16L), StoreId.UNKNOWN, LogPosition.UNSPECIFIED);
        LogTailInformation logTailInformation = tailScanner.checkpointTailInformation(endLogVersion, startEntry, endLogVersion, (byte)-1, checkPoint, false, StoreId.UNKNOWN);
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, firstTxAfterCheckpoint, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesSecondIsCorruptedBeforeCommit(int startLogVersion, int endLogVersion) throws IOException {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.checkPoint()), this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(2L)));
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        this.fs.truncate(highestLogFile, this.fs.getFileSize(highestLogFile) - 3L);
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesSecondIsCorruptedBeforeAfterCommit(int startLogVersion, int endLogVersion) throws IOException {
        int firstTxId = 2;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.checkPoint()), this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(firstTxId), AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(3L)));
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        this.fs.truncate(highestLogFile, this.fs.getFileSize(highestLogFile) - 3L);
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, firstTxId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingACheckPointAndAStartAfter(int startLogVersion, int endLogVersion) {
        long txId = 35L;
        StartEntry start = AbstractLogTailScannerTest.start();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(start, AbstractLogTailScannerTest.commit(txId), AbstractLogTailScannerTest.checkPoint(start)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingMultipleCheckPointsOneStartInBetween(int startLogVersion, int endLogVersion) {
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.checkPoint(), AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(1L), AbstractLogTailScannerTest.checkPoint()));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth(int startLogVersion, int endLogVersion) {
        long txId = 11L;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.checkPoint(), AbstractLogTailScannerTest.checkPoint(), AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingACheckPointAndNewerFileContainingAStart(int startLogVersion, int endLogVersion) {
        long txId = 11L;
        StartEntry start = AbstractLogTailScannerTest.start();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.checkPoint()), this.logFile(start, AbstractLogTailScannerTest.commit(txId)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingACheckPointAndNewerFileIsEmpty(int startLogVersion, int endLogVersion) {
        StartEntry start = AbstractLogTailScannerTest.start();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(start, AbstractLogTailScannerTest.commit(1L), AbstractLogTailScannerTest.checkPoint()), this.logFile(new Entry[0]));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart(int startLogVersion, int endLogVersion) {
        long txId = 123L;
        StartEntry start = AbstractLogTailScannerTest.start();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(start, AbstractLogTailScannerTest.commit(txId)), this.logFile(AbstractLogTailScannerTest.checkPoint(start)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStartWithoutCommit(int startLogVersion, int endLogVersion) {
        StartEntry start = AbstractLogTailScannerTest.start();
        PositionEntry position = AbstractLogTailScannerTest.position();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(start, position), this.logFile(AbstractLogTailScannerTest.checkPoint(position)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart(int startLogVersion, int endLogVersion) {
        PositionEntry position = AbstractLogTailScannerTest.position();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(3L), position), this.logFile(AbstractLogTailScannerTest.checkPoint(position)));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, false, -1L, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog(int startLogVersion, int endLogVersion) {
        long txId = 432L;
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(1L), AbstractLogTailScannerTest.checkPoint(), AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId)), this.logFile(new Entry[0]));
        LogTailInformation logTailInformation = this.logFiles.getTailInformation();
        AbstractLogTailScannerTest.assertLatestCheckPoint(true, true, txId, false, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void printProgress(long startLogVersion, long endLogVersion) {
        long txId = 6L;
        PositionEntry position = AbstractLogTailScannerTest.position();
        AbstractLogTailScannerTest.setupLogFiles(endLogVersion, this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId - 1L), position), this.logFile(AbstractLogTailScannerTest.checkPoint(position)), this.logFile(AbstractLogTailScannerTest.start(), AbstractLogTailScannerTest.commit(txId)));
        this.logFiles.getTailInformation();
        String message = "Scanning log file with version %d for checkpoint entries";
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessageWithArguments(message, new Object[]{endLogVersion});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessageWithArguments(message, new Object[]{startLogVersion});
    }

    static void setupLogFiles(long endLogVersion, LogCreator ... logFiles) {
        HashMap<Entry, LogPosition> positions = new HashMap<Entry, LogPosition>();
        long version = endLogVersion - (long)logFiles.length;
        for (LogCreator logFile : logFiles) {
            logFile.create(++version, positions);
        }
    }

    LogCreator logFile(Entry ... entries) {
        return (logVersion, positions) -> {
            try {
                AtomicLong lastTxId = new AtomicLong();
                this.logVersionRepository.setCurrentLogVersion(logVersion, CursorContext.NULL);
                this.logVersionRepository.setCheckpointLogVersion(logVersion, CursorContext.NULL);
                LifeSupport logFileLife = new LifeSupport();
                logFileLife.start();
                logFileLife.add((Lifecycle)this.logFiles);
                LogFile logFile = this.logFiles.getLogFile();
                CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
                int previousChecksum = -559063315;
                try {
                    TransactionLogWriter logWriter = logFile.getTransactionLogWriter();
                    LogEntryWriter writer = logWriter.getWriter();
                    for (Entry entry : entries) {
                        LogPosition currentPosition = logWriter.getCurrentPosition();
                        positions.put(entry, currentPosition);
                        if (entry instanceof StartEntry) {
                            writer.writeStartEntry(0L, 0L, previousChecksum, new byte[0]);
                            continue;
                        }
                        if (entry instanceof CommitEntry) {
                            CommitEntry commitEntry = (CommitEntry)entry;
                            previousChecksum = writer.writeCommitEntry(commitEntry.txId, 0L);
                            lastTxId.set(commitEntry.txId);
                            continue;
                        }
                        if (entry instanceof CheckPointEntry) {
                            LogPosition logPosition;
                            CheckPointEntry checkPointEntry = (CheckPointEntry)entry;
                            Entry target = checkPointEntry.withPositionOfEntry;
                            LogPosition logPosition2 = logPosition = target != null ? (LogPosition)positions.get(target) : currentPosition;
                            assert (logPosition != null) : "No registered log position for " + target;
                            this.writeCheckpoint(writer, checkpointFile, logPosition);
                            continue;
                        }
                        if (entry instanceof PositionEntry) continue;
                        throw new IllegalArgumentException("Unknown entry " + entry);
                    }
                }
                finally {
                    logFileLife.shutdown();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    static StartEntry start() {
        return new StartEntry();
    }

    static CommitEntry commit(long txId) {
        return new CommitEntry(txId);
    }

    static CheckPointEntry checkPoint() {
        return AbstractLogTailScannerTest.checkPoint(null);
    }

    static CheckPointEntry checkPoint(Entry forEntry) {
        return new CheckPointEntry(forEntry);
    }

    static PositionEntry position() {
        return new PositionEntry();
    }

    private static void assertLatestCheckPoint(boolean hasCheckPointEntry, boolean commitsAfterLastCheckPoint, long firstTxIdAfterLastCheckPoint, boolean filesNotFound, LogTailInformation logTailInformation) {
        Assertions.assertEquals((Object)hasCheckPointEntry, (Object)(logTailInformation.lastCheckPoint != null ? 1 : 0));
        Assertions.assertEquals((Object)commitsAfterLastCheckPoint, (Object)logTailInformation.commitsAfterLastCheckpoint());
        if (commitsAfterLastCheckPoint) {
            Assertions.assertEquals((long)firstTxIdAfterLastCheckPoint, (long)logTailInformation.firstTxIdAfterLastCheckPoint);
        }
        Assertions.assertEquals((Object)filesNotFound, (Object)logTailInformation.filesNotFound);
    }

    private static class FirstTxIdConfigurableTailScanner
    extends InlinedLogTailScanner {
        private final long txId;

        FirstTxIdConfigurableTailScanner(long txId, LogFiles logFiles, LogEntryReader logEntryReader, Monitors monitors) {
            super(logFiles, logEntryReader, monitors, false, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.txId = txId;
        }

        protected AbstractLogTailScanner.ExtractedTransactionRecord extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) {
            return new AbstractLogTailScanner.ExtractedTransactionRecord(this.txId);
        }
    }

    static class PositionEntry
    implements Entry {
        PositionEntry() {
        }
    }

    private static class CheckPointEntry
    implements Entry {
        final Entry withPositionOfEntry;

        CheckPointEntry(Entry withPositionOfEntry) {
            this.withPositionOfEntry = withPositionOfEntry;
        }
    }

    private static class CommitEntry
    implements Entry {
        final long txId;

        CommitEntry(long txId) {
            this.txId = txId;
        }
    }

    private static class StartEntry
    implements Entry {
        private StartEntry() {
        }
    }

    static interface Entry {
    }

    @FunctionalInterface
    static interface LogCreator {
        public void create(long var1, Map<Entry, LogPosition> var3);
    }
}

