/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryDetachedCheckpoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryInlinedCheckPoint;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.storageengine.api.StoreId;

class CheckpointInfoTest {
    CheckpointInfoTest() {
    }

    @Test
    void checkpointInfoOfLegacyCheckpointEntry() {
        LogPosition logPosition = new LogPosition(0L, 1L);
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L, 5L);
        LogPosition position = new LogPosition(1L, 2L);
        CheckpointInfo checkpointInfo = new CheckpointInfo(new LogEntryInlinedCheckPoint(logPosition), storeId, position);
        Assertions.assertSame((Object)logPosition, (Object)checkpointInfo.getTransactionLogPosition());
        Assertions.assertSame((Object)storeId, (Object)checkpointInfo.storeId());
        Assertions.assertSame((Object)position, (Object)checkpointInfo.getCheckpointEntryPosition());
    }

    @Test
    void checkpointInfoOfDetachedCheckpointEntry() {
        LogPosition logPosition = new LogPosition(0L, 1L);
        StoreId storeId = new StoreId(3L, 4L, 5L, 6L, 7L);
        LogPosition position = new LogPosition(1L, 2L);
        CheckpointInfo checkpointInfo = new CheckpointInfo(new LogEntryDetachedCheckpoint(KernelVersion.V4_0, logPosition, 2L, storeId, "checkpoint"), position);
        Assertions.assertSame((Object)logPosition, (Object)checkpointInfo.getTransactionLogPosition());
        Assertions.assertSame((Object)storeId, (Object)checkpointInfo.storeId());
        Assertions.assertSame((Object)position, (Object)checkpointInfo.getCheckpointEntryPosition());
    }
}

