/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class})
@Neo4jLayoutExtension
class KernelDiagnosticsTest {
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;

    KernelDiagnosticsTest() {
    }

    @Test
    void shouldPrintDiskUsage() throws IOException {
        DatabaseLayout layout = DatabaseLayout.ofFlat((Path)this.testDirectory.homePath());
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        Mockito.when((Object)storageEngineFactory.listStorageFiles((FileSystemAbstraction)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, (FileSystemAbstraction)this.fs, layout);
        storeFiles.dump(arg_0 -> ((Log)logProvider.getLog(this.getClass())).debug(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Disk space on partition"});
    }

    @Test
    void printDatabaseFileStoreType() {
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, (FileSystemAbstraction)this.fs, this.databaseLayout);
        storeFiles.dump(arg_0 -> ((Log)logProvider.getLog(this.getClass())).debug(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Storage files stored on file store: "});
    }

    @Test
    void shouldCountFileSizeRecursively() throws IOException {
        Path storeDir = this.testDirectory.directory("storedir");
        DatabaseLayout layout = DatabaseLayout.ofFlat((Path)storeDir);
        Path indexDir = this.directory(storeDir, "indexDir");
        this.file(indexDir, "indexFile", (int)ByteUnit.kibiBytes((long)1L));
        this.file(storeDir, layout.metadataStore().getFileName().toString(), (int)ByteUnit.kibiBytes((long)3L));
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        Mockito.when((Object)storageEngineFactory.listStorageFiles((FileSystemAbstraction)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any())).thenReturn(Collections.singletonList(layout.metadataStore()));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, (FileSystemAbstraction)this.fs, layout);
        storeFiles.dump(arg_0 -> ((Log)logProvider.getLog(this.getClass())).debug(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Total size of store: 4.000KiB", "Total size of mapped files: 3.000KiB"});
    }

    private Path directory(Path parent, String name) throws IOException {
        Path dir = parent.resolve(name);
        this.fs.mkdirs(dir);
        return dir;
    }

    private Path file(Path parent, String name, int size) throws IOException {
        Path file = parent.resolve(name);
        try (StoreFileChannel channel = this.fs.write(file);){
            ByteBuffer buffer = ByteBuffers.allocate((int)size, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            buffer.position(size).flip();
            channel.writeAll(buffer);
        }
        return file;
    }
}

