/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingStack;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingStackTest {
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private HeapTrackingStack<Object> aStack;
    private Object[] objArray;

    HeapTrackingStackTest() {
    }

    @BeforeEach
    void setUp() {
        this.objArray = new Object[100];
        for (int i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = i;
        }
        this.aStack = HeapTrackingCollections.newStack((MemoryTracker)this.memoryTracker);
        for (Object o : this.objArray) {
            this.aStack.push(o);
        }
    }

    @AfterEach
    void tearDown() {
        this.objArray = null;
        this.aStack.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void pop() {
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
        int i = 99;
        while (this.aStack.notEmpty()) {
            Assertions.assertEquals((Object)i--, (Object)this.aStack.pop());
        }
        Assertions.assertEquals((int)-1, (int)i);
        Assertions.assertEquals((int)0, (int)this.aStack.size(), (String)"Returned incorrect size for modified list");
    }

    @Test
    void peek() {
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
        Assertions.assertEquals((Object)99, (Object)this.aStack.peek());
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
    }

    @Test
    void push() {
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
        this.aStack.push((Object)42);
        Assertions.assertEquals((Object)42, (Object)this.aStack.peek());
        Assertions.assertEquals((int)101, (int)this.aStack.size(), (String)"Returned incorrect size for modified list");
    }
}

