/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.assertj.core.api.Assertions;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingUnifiedMapTest {
    private static final long INTEGER_SIZE = HeapEstimator.shallowSizeOfInstance(Integer.class);
    private final MemoryMeter meter = new MemoryMeter();
    private MemoryPool memoryPool;
    private MemoryTracker memoryTracker;

    HeapTrackingUnifiedMapTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker(this.memoryPool);
    }

    @Test
    void calculateEmptySize() {
        HeapTrackingUnifiedMap map = HeapTrackingUnifiedMap.createUnifiedMap((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(map);
        map.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void reactToGrowth() {
        long totalBytesIntegers = 0L;
        HeapTrackingUnifiedMap map = HeapTrackingUnifiedMap.createUnifiedMap((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(map);
        long emptySize = this.memoryTracker.estimatedHeapMemory();
        for (int i = 0; i < 128; ++i) {
            totalBytesIntegers += INTEGER_SIZE;
            this.memoryTracker.allocateHeap(INTEGER_SIZE);
            map.put((Object)i, (Object)i);
        }
        this.assertExactEstimation(map);
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isGreaterThan(emptySize);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThanOrEqualTo(this.memoryTracker.estimatedHeapMemory());
        map.close();
        this.memoryTracker.releaseHeap(totalBytesIntegers);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedHeap());
    }

    @Test
    void handleLargeArraysWithoutOverflowing() {
        Assertions.assertThat((long)HeapTrackingUnifiedMap.arrayHeapSize((int)0x20000000)).isGreaterThan(0L);
    }

    private void assertExactEstimation(HeapTrackingUnifiedMap<?, ?> map) {
        org.junit.jupiter.api.Assertions.assertEquals((long)(this.meter.measureDeep(map) - this.meter.measureDeep((Object)this.memoryTracker)), (long)this.memoryTracker.estimatedHeapMemory());
    }
}

