/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.configuration.database.readonly.ConfigReadOnlyDatabaseListener;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@ExtendWith(value={LifeExtension.class})
class ReadOnlyDatabasesTest {
    @Inject
    private LifeSupport life;

    ReadOnlyDatabasesTest() {
    }

    @Test
    void globalReadOnlyConfigHasHigherPriorityThanReadOnlyDatabaseList() {
        NamedDatabaseId fooDb = DatabaseIdFactory.from((String)"foo1234", (UUID)UUID.randomUUID());
        Map configValues = Map.of(GraphDatabaseSettings.read_only_database_default, true, GraphDatabaseSettings.read_only_databases, Set.of());
        Config config = Config.defaults(configValues);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("foo12345")).thenReturn(Optional.of(fooDb));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases checker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        ConfigReadOnlyDatabaseListener listener = new ConfigReadOnlyDatabaseListener(checker, config);
        this.life.add((Lifecycle)listener);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checker.isReadOnly(fooDb));
    }

    @Test
    void readOnlyDatabaseShouldBeTakenIntoAccountWhenGlobalReadOnlyConfigIsOff() {
        NamedDatabaseId fooDb = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        Map<Setting, Set<String>> configValues = Map.of(GraphDatabaseSettings.read_only_database_default, false, GraphDatabaseSettings.read_only_databases, Set.of(fooDb.name()));
        Config config = Config.defaults(configValues);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("foo")).thenReturn(Optional.of(fooDb));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases checker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        ConfigReadOnlyDatabaseListener listener = new ConfigReadOnlyDatabaseListener(checker, config);
        this.life.add((Lifecycle)listener);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checker.isReadOnly(fooDb));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)checker.isReadOnly(DatabaseIdFactory.from((String)"test12356", (UUID)UUID.randomUUID())));
    }

    @Test
    void shouldBeNotPossibleToMakeSystemDbReadOnly() {
        Map<Setting, Set<String>> configValues = Map.of(GraphDatabaseSettings.read_only_database_default, false, GraphDatabaseSettings.read_only_databases, Set.of("system"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.defaults((Map)configValues));
    }

    @Test
    void systemDatabaseCantBeSetReadOnlyDynamically() {
        NamedDatabaseId defaultDatabase = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        Map<Setting, Set<String>> configValues = Map.of(GraphDatabaseSettings.read_only_database_default, false, GraphDatabaseSettings.read_only_databases, Set.of("neo4j"));
        Config config = Config.defaults(configValues);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("neo4j")).thenReturn(Optional.of(defaultDatabase));
        Mockito.when((Object)databaseIdRepository.getByName("system")).thenReturn(Optional.of(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases checker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)checker.isReadOnly(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> config.setDynamic(GraphDatabaseSettings.read_only_databases, Set.of("neo4j", "system"), this.getClass().getSimpleName()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)checker.isReadOnly(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID));
    }

    @Test
    void readOnlyConfigsShouldBeDynamic() {
        Map<Setting, Set<String>> configValues = Map.of(GraphDatabaseSettings.read_only_database_default, false, GraphDatabaseSettings.read_only_databases, Set.of("neo4j"));
        Config config = Config.defaults(configValues);
        Set<String> roDatabaseList = Set.of("neo4j", "foo");
        Set<String> writableDatabaseList = Set.of("bar", "baz");
        config.setDynamic(GraphDatabaseSettings.read_only_database_default, (Object)true, this.getClass().getSimpleName());
        config.setDynamic(GraphDatabaseSettings.read_only_databases, roDatabaseList, this.getClass().getSimpleName());
        config.setDynamic(GraphDatabaseSettings.writable_databases, writableDatabaseList, this.getClass().getSimpleName());
        org.junit.jupiter.api.Assertions.assertEquals(roDatabaseList, (Object)config.get(GraphDatabaseSettings.read_only_databases));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)config.get(GraphDatabaseSettings.read_only_database_default)));
        org.junit.jupiter.api.Assertions.assertEquals(writableDatabaseList, (Object)config.get(GraphDatabaseSettings.writable_databases));
    }

    @Test
    void writableShouldOverrideReadOnlyDefault() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        Set<NamedDatabaseId> databases = Set.of(foo, bar);
        Map<Setting, Set<String>> configValues = Map.of(GraphDatabaseSettings.read_only_database_default, true, GraphDatabaseSettings.writable_databases, Set.of(foo.name()));
        Config config = Config.defaults(configValues);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("foo")).thenReturn(Optional.of(foo));
        Mockito.when((Object)databaseIdRepository.getByName("bar")).thenReturn(Optional.of(bar));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases checker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        ConfigReadOnlyDatabaseListener listener = new ConfigReadOnlyDatabaseListener(checker, config);
        this.life.add((Lifecycle)listener);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checker.isReadOnly(bar));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)checker.isReadOnly(foo));
    }

    @Test
    void explicitReadOnlyShouldOverrideExplicitWritable() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        NamedDatabaseId baz = DatabaseIdFactory.from((String)"baz", (UUID)UUID.randomUUID());
        Set<NamedDatabaseId> databases = Set.of(foo, bar, baz);
        Map<Setting, Set<String>> configValues = Map.of(GraphDatabaseSettings.read_only_databases, Set.of(foo.name(), bar.name()), GraphDatabaseSettings.writable_databases, Set.of(bar.name(), baz.name()));
        Config config = Config.defaults(configValues);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("foo")).thenReturn(Optional.of(foo));
        Mockito.when((Object)databaseIdRepository.getByName("bar")).thenReturn(Optional.of(bar));
        Mockito.when((Object)databaseIdRepository.getByName("baz")).thenReturn(Optional.of(baz));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        ReadOnlyDatabases checker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        ConfigReadOnlyDatabaseListener listener = new ConfigReadOnlyDatabaseListener(checker, config);
        this.life.add((Lifecycle)listener);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checker.isReadOnly(bar));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)checker.isReadOnly(baz));
    }

    @Test
    void refreshShouldReloadReadOnlyFromLookups() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        HashSet<NamedDatabaseId> readOnlyDatabaseNames = new HashSet<NamedDatabaseId>();
        readOnlyDatabaseNames.add(foo);
        ReadOnlyDatabases readOnly = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{() -> {
            Set snapshot = Set.copyOf(readOnlyDatabaseNames);
            return snapshot::contains;
        }});
        readOnly.refresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readOnly.isReadOnly(foo));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)readOnly.isReadOnly(bar));
        readOnlyDatabaseNames.add(bar);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)readOnly.isReadOnly(bar));
        readOnly.refresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readOnly.isReadOnly(bar));
    }

    @Test
    void refreshShouldIncrementUpdateId() {
        ReadOnlyDatabases readOnlyDatabases = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[0]);
        long originalUpdateId = readOnlyDatabases.updateId();
        readOnlyDatabases.refresh();
        Assertions.assertThat((long)readOnlyDatabases.updateId()).isEqualTo(originalUpdateId + 1L);
    }
}

