/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.ArrayList;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;

class NotificationCodeTest {
    NotificationCodeTest() {
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE_for_node_index() {
        NotificationDetail indexDetail = NotificationDetail.Factory.nodeAnyIndex((String)"person", (String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The request (directly or indirectly) referred to an index that does not exist.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientError.Schema.IndexNotFound");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted index does not exist, please check the schema (index is: INDEX FOR (`person`:`Person`) ON (`person`.`name`))");
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE_for_node_btree_index() {
        NotificationDetail indexDetail = NotificationDetail.Factory.nodeBtreeIndex((String)"person", (String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The request (directly or indirectly) referred to an index that does not exist.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientError.Schema.IndexNotFound");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted index does not exist, please check the schema (index is: BTREE INDEX FOR (`person`:`Person`) ON (`person`.`name`))");
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE_for_node_text_index() {
        NotificationDetail indexDetail = NotificationDetail.Factory.nodeTextIndex((String)"person", (String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The request (directly or indirectly) referred to an index that does not exist.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientError.Schema.IndexNotFound");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted index does not exist, please check the schema (index is: TEXT INDEX FOR (`person`:`Person`) ON (`person`.`name`))");
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE_for_rel_index() {
        NotificationDetail indexDetail = NotificationDetail.Factory.relationshipAnyIndex((String)"person", (String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The request (directly or indirectly) referred to an index that does not exist.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientError.Schema.IndexNotFound");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted index does not exist, please check the schema (index is: INDEX FOR ()-[`person`:`Person`]-() ON (`person`.`name`))");
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE_for_rel_btree_index() {
        NotificationDetail indexDetail = NotificationDetail.Factory.relationshipBtreeIndex((String)"person", (String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The request (directly or indirectly) referred to an index that does not exist.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientError.Schema.IndexNotFound");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted index does not exist, please check the schema (index is: BTREE INDEX FOR ()-[`person`:`Person`]-() ON (`person`.`name`))");
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE_for_rel_text_index() {
        NotificationDetail indexDetail = NotificationDetail.Factory.relationshipTextIndex((String)"person", (String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The request (directly or indirectly) referred to an index that does not exist.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientError.Schema.IndexNotFound");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted index does not exist, please check the schema (index is: TEXT INDEX FOR ()-[`person`:`Person`]-() ON (`person`.`name`))");
    }

    @Test
    void shouldConstructNotificationFor_CARTESIAN_PRODUCT() {
        TreeSet<String> idents = new TreeSet<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail identifierDetail = NotificationDetail.Factory.cartesianProduct(idents);
        NotificationCode.Notification notification = NotificationCode.CARTESIAN_PRODUCT.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("This query builds a cartesian product between disconnected patterns.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientNotification.Statement.CartesianProductWarning");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH (identifiers are: (n, node2))");
    }

    @Test
    void shouldConstructNotificationsFor_JOIN_HINT_UNFULFILLABLE() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail identifierDetail = NotificationDetail.Factory.joinKey(idents);
        NotificationCode.Notification notification = NotificationCode.JOIN_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("The database was unable to plan a hinted join.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientNotification.Statement.JoinHintUnfulfillableWarning");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The hinted join was not planned. This could happen because no generated plan contained the join key, please try using a different join key or restructure your query. (hinted join key identifiers are: n, node2)");
    }

    @Test
    void shouldConstructNotificationsFor_DEPRECATED_PROCEDURE() {
        NotificationDetail identifierDetail = NotificationDetail.Factory.deprecatedName((String)"oldName", (String)"newName");
        NotificationCode.Notification notification = NotificationCode.DEPRECATED_PROCEDURE.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("This feature is deprecated and will be removed in future versions.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientNotification.Statement.FeatureDeprecationWarning");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The query used a deprecated procedure. ('oldName' has been replaced by 'newName')");
    }

    @Test
    void shouldConstructNotificationsFor_DEPRECATED_PROCEDURE_with_no_newName() {
        NotificationDetail identifierDetail = NotificationDetail.Factory.deprecatedName((String)"oldName", (String)"");
        NotificationCode.Notification notification = NotificationCode.DEPRECATED_PROCEDURE.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        Assertions.assertThat((String)notification.getTitle()).isEqualTo("This feature is deprecated and will be removed in future versions.");
        Assertions.assertThat((Comparable)notification.getSeverity()).isEqualTo((Object)SeverityLevel.WARNING);
        Assertions.assertThat((String)notification.getCode()).isEqualTo("Neo.ClientNotification.Statement.FeatureDeprecationWarning");
        Assertions.assertThat((Object)notification.getPosition()).isEqualTo((Object)InputPosition.empty);
        Assertions.assertThat((String)notification.getDescription()).isEqualTo("The query used a deprecated procedure. ('oldName' is no longer supported)");
    }
}

