/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class IndexEntryConflictExceptionTest {
    private static final int labelId = 1;
    private static final Value value = Values.of((Object)"hi");
    private static final InMemoryTokens tokens = new InMemoryTokens().label(1, "label1").propertyKey(2, "p2").propertyKey(3, "p3").propertyKey(4, "p4");

    IndexEntryConflictExceptionTest() {
    }

    @Test
    void shouldMakeEntryConflicts() {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)1, (int[])new int[]{2});
        IndexEntryConflictException e = new IndexEntryConflictException(0L, 1L, new Value[]{value});
        Assertions.assertThat((String)e.evidenceMessage((TokenNameLookup)tokens, (SchemaDescriptor)schema)).isEqualTo("Both Node(0) and Node(1) have the label `label1` and property `p2` = 'hi'");
    }

    @Test
    void shouldMakeEntryConflictsForOneNode() {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)1, (int[])new int[]{2});
        IndexEntryConflictException e = new IndexEntryConflictException(0L, -1L, new Value[]{value});
        Assertions.assertThat((String)e.evidenceMessage((TokenNameLookup)tokens, (SchemaDescriptor)schema)).isEqualTo("Node(0) already exists with label `label1` and property `p2` = 'hi'");
    }

    @Test
    void shouldMakeCompositeEntryConflicts() {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)1, (int[])new int[]{2, 3, 4});
        ValueTuple values = ValueTuple.of((Object[])new Object[]{true, "hi", new long[]{6L, 4L}});
        IndexEntryConflictException e = new IndexEntryConflictException(0L, 1L, values);
        Assertions.assertThat((String)e.evidenceMessage((TokenNameLookup)tokens, (SchemaDescriptor)schema)).isEqualTo("Both Node(0) and Node(1) have the label `label1` and properties `p2` = true, `p3` = 'hi', `p4` = [6, 4]");
    }
}

