/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.test.InMemoryTokens;

class IndexPopulationFailedKernelExceptionTest {
    private static final TokenNameLookup TOKEN_NAME_LOOKUP = new InMemoryTokens().label(0, "label0").propertyKey(42, "p42").propertyKey(43, "p43").propertyKey(44, "p44");

    IndexPopulationFailedKernelExceptionTest() {
    }

    @Test
    void shouldHandleMultiplePropertiesInConstructor1() {
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)0, (int[])new int[]{42, 43, 44});
        IndexPopulationFailedKernelException index = new IndexPopulationFailedKernelException(descriptor.userDescription(TOKEN_NAME_LOOKUP), (Throwable)new RuntimeException());
        Assertions.assertThat((String)index.getUserMessage(TOKEN_NAME_LOOKUP)).isEqualTo("Failed to populate index (:label0 {p42, p43, p44})");
    }

    @Test
    void shouldHandleMultiplePropertiesInConstructor2() {
        LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)0, (int[])new int[]{42, 43, 44});
        IndexPopulationFailedKernelException index = new IndexPopulationFailedKernelException(descriptor.userDescription(TOKEN_NAME_LOOKUP), "an act of pure evil occurred");
        Assertions.assertThat((String)index.getUserMessage(TOKEN_NAME_LOOKUP)).isEqualTo("Failed to populate index (:label0 {p42, p43, p44}), due to an act of pure evil occurred");
    }
}

