/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJobFactory;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
class LuceneIndexSamplerReleaseTaskControlUnderFusionTest {
    private static final int indexId = 1;
    private static final IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withName("index_1").materialise(1L);
    private static final IndexProviderDescriptor providerDescriptor = IndexProviderDescriptor.UNDECIDED;
    private static final DirectoryFactory.InMemoryDirectoryFactory luceneDirectoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private static final Config config = Config.defaults();
    private static final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
    private static final RuntimeException sampleException = new RuntimeException("Killroy messed with your index sample.");
    private static final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory dir;
    private IndexDirectoryStructure.Factory directoryFactory;

    LuceneIndexSamplerReleaseTaskControlUnderFusionTest() {
    }

    @BeforeEach
    void setup() {
        this.directoryFactory = IndexDirectoryStructure.directoriesByProvider((Path)this.dir.homePath());
    }

    @Test
    void failedIndexSamplingMustNotPreventIndexDrop() throws IOException, IndexEntryConflictException {
        LuceneIndexProvider luceneProvider = this.luceneProvider();
        LuceneIndexSamplerReleaseTaskControlUnderFusionTest.makeSureIndexHasSomeData((IndexProvider)luceneProvider);
        IndexProvider failingProvider = this.failingProvider();
        FusionIndexProvider fusionProvider = this.createFusionProvider(luceneProvider, failingProvider);
        try (IndexAccessor fusionAccessor = fusionProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);){
            IndexSamplingJob indexSamplingJob = LuceneIndexSamplerReleaseTaskControlUnderFusionTest.createIndexSamplingJob(fusionAccessor);
            try {
                indexSamplingJob.run(new AtomicBoolean());
            }
            catch (RuntimeException e) {
                Assertions.assertSame((Object)sampleException, (Object)e);
            }
            fusionAccessor.drop();
        }
    }

    private static void makeSureIndexHasSomeData(IndexProvider provider) throws IOException, IndexEntryConflictException {
        try (IndexAccessor accessor = provider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);
             IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)"some string")}));
        }
    }

    private FusionIndexProvider createFusionProvider(LuceneIndexProvider luceneProvider, IndexProvider failingProvider) {
        SlotSelector slotSelector = SlotSelector.nullInstance;
        return new FusionIndexProvider(failingProvider, (IndexProvider)luceneProvider, slotSelector, providerDescriptor, this.directoryFactory, this.fs, false, DatabaseReadOnlyChecker.writable());
    }

    private static IndexSamplingJob createIndexSamplingJob(final IndexAccessor fusionAccessor) {
        IndexProxyAdapter indexProxy = new IndexProxyAdapter(){

            @Override
            public IndexDescriptor getDescriptor() {
                return descriptor;
            }

            @Override
            public ValueIndexReader newValueReader() {
                return fusionAccessor.newValueReader();
            }
        };
        OnlineIndexSamplingJobFactory onlineIndexSamplingJobFactory = new OnlineIndexSamplingJobFactory(null, SchemaTestUtil.SIMPLE_NAME_LOOKUP, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL);
        return onlineIndexSamplingJobFactory.create(1L, (IndexProxy)indexProxy);
    }

    private LuceneIndexProvider luceneProvider() {
        return new LuceneIndexProvider(this.fs, (DirectoryFactory)luceneDirectoryFactory, this.directoryFactory, new Monitors(), config, DatabaseReadOnlyChecker.writable());
    }

    private IndexProvider failingProvider() {
        return new IndexProvider.Adaptor(providerDescriptor, this.directoryFactory){

            public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) {
                return LuceneIndexSamplerReleaseTaskControlUnderFusionTest.failingIndexAccessor();
            }
        };
    }

    private static IndexAccessor failingIndexAccessor() {
        return new IndexAccessor.Adapter(){

            public ValueIndexReader newValueReader() {
                return new ValueIndexReader(){

                    public void close() {
                    }

                    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
                        return 0L;
                    }

                    public IndexSampler createSampler() {
                        return (cursorContext, stopped) -> {
                            throw sampleException;
                        };
                    }

                    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
                    }

                    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

