/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.labelscan;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.kernel.impl.index.schema.EntityTokenRangeImpl;

class EntityTokenRangeTest {
    EntityTokenRangeTest() {
    }

    @Test
    void shouldTransposeNodeIdsAndLabelIds() {
        long[][] labelsPerNode = new long[][]{{1L}, {1L, 3L}, {3L, 5L, 7L}, new long[0], {1L, 5L, 7L}, new long[0], new long[0], {1L, 2L, 3L, 4L}};
        EntityTokenRangeImpl range = new EntityTokenRangeImpl(0L, (long[][])labelsPerNode, EntityType.NODE);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L}, (long[])range.entities());
        for (int i = 0; i < labelsPerNode.length; ++i) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((long[])labelsPerNode[i], (long[])range.tokens((long)i));
        }
    }

    @Test
    void shouldRebaseOnRangeId() {
        long[][] labelsPerNode = new long[][]{{1L}, {1L, 3L}, {3L, 5L, 7L}, new long[0], {1L, 5L, 7L}, new long[0], new long[0], {1L, 2L, 3L, 4L}};
        EntityTokenRangeImpl range = new EntityTokenRangeImpl(10L, (long[][])labelsPerNode, EntityType.NODE);
        long baseNodeId = range.id() * (long)labelsPerNode.length;
        long[] expectedNodeIds = new long[labelsPerNode.length];
        for (int i = 0; i < expectedNodeIds.length; ++i) {
            expectedNodeIds[i] = baseNodeId + (long)i;
        }
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])expectedNodeIds, (long[])range.entities());
    }

    @Test
    void shouldAdaptToStringToEntityTypeNode() {
        EntityTokenRangeImpl nodeLabelRange = new EntityTokenRangeImpl(0L, (long[][])new long[0][], EntityType.NODE);
        Assertions.assertThat((String)nodeLabelRange.toString()).contains(new CharSequence[]{"NodeLabelRange"});
    }

    @Test
    void shouldAdaptToStringToEntityTypeRelationship() {
        EntityTokenRangeImpl relationshipTypeRange = new EntityTokenRangeImpl(0L, (long[][])new long[0][], EntityType.RELATIONSHIP);
        Assertions.assertThat((String)relationshipTypeRange.toString()).contains(new CharSequence[]{"RelationshipTypeRange"});
    }
}

