/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.net;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.net.DefaultNetworkConnectionTracker;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;

class DefaultNetworkConnectionTrackerTest {
    private final TrackedNetworkConnection connection1 = DefaultNetworkConnectionTrackerTest.connectionMock("1");
    private final TrackedNetworkConnection connection2 = DefaultNetworkConnectionTrackerTest.connectionMock("2");
    private final TrackedNetworkConnection connection3 = DefaultNetworkConnectionTrackerTest.connectionMock("3");
    private final NetworkConnectionTracker tracker = new DefaultNetworkConnectionTracker();

    DefaultNetworkConnectionTrackerTest() {
    }

    @Test
    void shouldCreateIds() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bolt-0", (Object)this.tracker.newConnectionId("bolt"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bolt-1", (Object)this.tracker.newConnectionId("bolt"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bolt-2", (Object)this.tracker.newConnectionId("bolt"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http-3", (Object)this.tracker.newConnectionId("http"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http-4", (Object)this.tracker.newConnectionId("http"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https-5", (Object)this.tracker.newConnectionId("https"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https-6", (Object)this.tracker.newConnectionId("https"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https-7", (Object)this.tracker.newConnectionId("https"));
    }

    @Test
    void shouldAllowAddingOfConnections() {
        this.tracker.add(this.connection1);
        this.tracker.add(this.connection2);
        this.tracker.add(this.connection3);
        Assertions.assertThat((List)this.tracker.activeConnections()).contains((Object[])new TrackedNetworkConnection[]{this.connection1, this.connection2, this.connection3});
    }

    @Test
    void shouldFailWhenAddingConnectionWithSameId() {
        this.tracker.add(this.connection1);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.tracker.add(this.connection1));
    }

    @Test
    void shouldRemoveConnections() {
        this.tracker.add(this.connection1);
        this.tracker.add(this.connection2);
        this.tracker.add(this.connection3);
        this.tracker.remove(this.connection2);
        Assertions.assertThat((List)this.tracker.activeConnections()).contains((Object[])new TrackedNetworkConnection[]{this.connection1, this.connection3});
        this.tracker.remove(this.connection1);
        Assertions.assertThat((List)this.tracker.activeConnections()).contains((Object[])new TrackedNetworkConnection[]{this.connection3});
    }

    @Test
    void shouldDoNothingWhenRemovingUnknownConnection() {
        this.tracker.add(this.connection1);
        this.tracker.add(this.connection3);
        Assertions.assertThat((List)this.tracker.activeConnections()).contains((Object[])new TrackedNetworkConnection[]{this.connection1, this.connection3});
        this.tracker.remove(this.connection2);
        Assertions.assertThat((List)this.tracker.activeConnections()).contains((Object[])new TrackedNetworkConnection[]{this.connection1, this.connection3});
    }

    @Test
    void shouldGetKnownConnectionById() {
        this.tracker.add(this.connection1);
        this.tracker.add(this.connection2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.connection1, (Object)this.tracker.get(this.connection1.id()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.connection2, (Object)this.tracker.get(this.connection2.id()));
    }

    @Test
    void shouldReturnNullForUnknownId() {
        this.tracker.add(this.connection1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.tracker.get(this.connection1.id()));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.tracker.get(this.connection2.id()));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.tracker.get(this.connection3.id()));
    }

    @Test
    void shouldListActiveConnectionsWhenEmpty() {
        Assertions.assertThat((List)this.tracker.activeConnections()).isEmpty();
    }

    private static TrackedNetworkConnection connectionMock(String id) {
        TrackedNetworkConnection connection = (TrackedNetworkConnection)Mockito.mock(TrackedNetworkConnection.class);
        Mockito.when((Object)connection.id()).thenReturn((Object)id);
        return connection;
    }
}

