/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaProcessor;

class SchemaProcessorTest {
    private static final int LABEL_ID = 0;
    private static final int REL_TYPE_ID = 0;

    SchemaProcessorTest() {
    }

    @Test
    void shouldHandleCorrectDescriptorVersions() {
        final ArrayList callHistory = new ArrayList();
        SchemaProcessor processor = new SchemaProcessor(){

            public void processSpecific(LabelSchemaDescriptor schema) {
                callHistory.add("LabelSchemaDescriptor");
            }

            public void processSpecific(RelationTypeSchemaDescriptor schema) {
                callHistory.add("RelationTypeSchemaDescriptor");
            }

            public void processSpecific(SchemaDescriptor schemaDescriptor) {
                callHistory.add("SchemaDescriptor");
            }
        };
        SchemaProcessorTest.disguisedLabel().processWith(processor);
        SchemaProcessorTest.disguisedLabel().processWith(processor);
        SchemaProcessorTest.disguisedRelType().processWith(processor);
        SchemaProcessorTest.disguisedLabel().processWith(processor);
        SchemaProcessorTest.disguisedRelType().processWith(processor);
        SchemaProcessorTest.disguisedRelType().processWith(processor);
        Assertions.assertThat(callHistory).containsExactly((Object[])new String[]{"LabelSchemaDescriptor", "LabelSchemaDescriptor", "RelationTypeSchemaDescriptor", "LabelSchemaDescriptor", "RelationTypeSchemaDescriptor", "RelationTypeSchemaDescriptor"});
    }

    private static SchemaDescriptor disguisedLabel() {
        return SchemaDescriptors.forLabel((int)0, (int[])new int[]{1});
    }

    private static SchemaDescriptor disguisedRelType() {
        return SchemaDescriptors.forRelType((int)0, (int[])new int[]{1});
    }
}

