/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.availability;

import java.time.Clock;
import java.util.UUID;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@ExtendWith(value={LifeExtension.class})
class CompositeDatabaseAvailabilityGuardTest {
    private final DescriptiveAvailabilityRequirement requirement = new DescriptiveAvailabilityRequirement("testRequirement");
    private CompositeDatabaseAvailabilityGuard compositeGuard;
    private DatabaseAvailabilityGuard defaultGuard;
    private DatabaseAvailabilityGuard systemGuard;
    private Clock mockClock;
    @Inject
    private LifeSupport life;

    CompositeDatabaseAvailabilityGuardTest() {
    }

    @BeforeEach
    void setUp() throws Throwable {
        this.mockClock = (Clock)Mockito.mock(Clock.class);
        this.compositeGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        this.defaultGuard = this.createDatabaseAvailabilityGuard(DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()), this.mockClock, this.compositeGuard);
        this.systemGuard = this.createDatabaseAvailabilityGuard(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, this.mockClock, this.compositeGuard);
        this.defaultGuard.start();
        this.systemGuard.start();
        this.compositeGuard.start();
    }

    @Test
    void availabilityRequirementOnMultipleGuards() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.systemGuard.isAvailable());
        this.compositeGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("testRequirement"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.defaultGuard.isAvailable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void availabilityFulfillmentOnMultipleGuards() {
        this.compositeGuard.require((AvailabilityRequirement)this.requirement);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.defaultGuard.isAvailable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
        this.compositeGuard.fulfill((AvailabilityRequirement)this.requirement);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void availableWhenAllGuardsAreAvailable() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.compositeGuard.isAvailable());
        this.defaultGuard.require((AvailabilityRequirement)this.requirement);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.compositeGuard.isAvailable());
    }

    @Test
    void compositeGuardDoesNotSupportListeners() {
        AvailabilityListener listener = (AvailabilityListener)Mockito.mock(AvailabilityListener.class);
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeGuard.addListener(listener));
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> this.compositeGuard.removeListener(listener));
    }

    @Test
    void availabilityTimeoutSharedAcrossAllGuards() {
        this.compositeGuard.require((AvailabilityRequirement)this.requirement);
        MutableLong counter = new MutableLong();
        Mockito.when((Object)this.mockClock.millis()).thenAnswer(invocation -> {
            if (counter.longValue() == 7L) {
                this.defaultGuard.fulfill((AvailabilityRequirement)this.requirement);
            }
            return counter.incrementAndGet();
        });
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.compositeGuard.isAvailable(10L));
        Assertions.assertThat((Long)counter.getValue()).isLessThan(20L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void awaitCheckTimeoutSharedAcrossAllGuards() {
        this.compositeGuard.require((AvailabilityRequirement)this.requirement);
        MutableLong counter = new MutableLong();
        Mockito.when((Object)this.mockClock.millis()).thenAnswer(invocation -> {
            if (counter.longValue() == 7L) {
                this.defaultGuard.fulfill((AvailabilityRequirement)this.requirement);
            }
            return counter.incrementAndGet();
        });
        org.junit.jupiter.api.Assertions.assertThrows(UnavailableException.class, () -> this.compositeGuard.await(10L));
        Assertions.assertThat((Long)counter.getValue()).isLessThan(20L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.defaultGuard.isAvailable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.systemGuard.isAvailable());
    }

    @Test
    void stopOfAvailabilityGuardDeregisterItInCompositeParent() throws Exception {
        int initialGuards = this.compositeGuard.getGuards().size();
        DatabaseAvailabilityGuard firstGuard = this.createDatabaseAvailabilityGuard(DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID()), this.mockClock, this.compositeGuard);
        DatabaseAvailabilityGuard secondGuard = this.createDatabaseAvailabilityGuard(DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID()), this.mockClock, this.compositeGuard);
        firstGuard.start();
        secondGuard.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.countNewGuards(initialGuards));
        new Lifespan(new Lifecycle[]{firstGuard}).close();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countNewGuards(initialGuards));
        new Lifespan(new Lifecycle[]{secondGuard}).close();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countNewGuards(initialGuards));
    }

    @Test
    void compositeGuardIsAvailableByDefault() {
        CompositeDatabaseAvailabilityGuard testGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testGuard.isAvailable());
    }

    @Test
    void guardIsShutdownStateAfterStop() throws Throwable {
        CompositeDatabaseAvailabilityGuard testGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        testGuard.start();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testGuard.isShutdown());
        testGuard.stop();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testGuard.isShutdown());
    }

    @Test
    void stoppedGuardIsNotAvailableInAwait() throws Throwable {
        CompositeDatabaseAvailabilityGuard testGuard = new CompositeDatabaseAvailabilityGuard(this.mockClock);
        testGuard.start();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> testGuard.await(0L));
        testGuard.stop();
        org.junit.jupiter.api.Assertions.assertThrows(UnavailableException.class, () -> testGuard.await(0L));
    }

    private int countNewGuards(int initialGuards) {
        return this.compositeGuard.getGuards().size() - initialGuards;
    }

    private DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(NamedDatabaseId namedDatabaseId, Clock clock, CompositeDatabaseAvailabilityGuard compositeGuard) {
        DatabaseAvailabilityGuard availabilityGuard = new DatabaseAvailabilityGuard(namedDatabaseId, clock, (Log)NullLog.getInstance(), 0L, compositeGuard);
        this.life.add((Lifecycle)availabilityGuard);
        return availabilityGuard;
    }
}

