/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

class MapCachingDatabaseIdRepositoryTest {
    private final DatabaseIdRepository delegate = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
    private final NamedDatabaseId randomNamedDbId = DatabaseIdFactory.from((String)"randomDb", (UUID)UUID.randomUUID());
    private final String randomDbName = this.randomNamedDbId.name();
    private final DatabaseId randomDbId = this.randomNamedDbId.databaseId();
    private DatabaseIdRepository.Caching databaseIdRepository;

    MapCachingDatabaseIdRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.delegate.getByName(this.randomDbName)).thenReturn(Optional.of(this.randomNamedDbId));
        Mockito.when((Object)this.delegate.getById(this.randomDbId)).thenReturn(Optional.of(this.randomNamedDbId));
        this.databaseIdRepository = new MapCachingDatabaseIdRepository(this.delegate);
    }

    @Test
    void shouldDelegateGetByName() {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository.getByName(this.randomDbName).get();
        Assertions.assertThat((Comparable)namedDatabaseId).isEqualTo((Object)this.randomNamedDbId);
    }

    @Test
    void shouldDelegateGetByUuid() {
        NamedDatabaseId databaseId = (NamedDatabaseId)this.databaseIdRepository.getById(this.randomDbId).get();
        Assertions.assertThat((Comparable)databaseId).isEqualTo((Object)this.randomNamedDbId);
    }

    @Test
    void shouldCacheDbByName() {
        this.databaseIdRepository.getByName(this.randomDbName).get();
        this.databaseIdRepository.getByName(this.randomDbName).get();
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getByName(this.randomDbName);
    }

    @Test
    void shouldCacheDbByUuid() {
        this.databaseIdRepository.getById(this.randomDbId).get();
        this.databaseIdRepository.getById(this.randomDbId).get();
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getById(this.randomDbId);
    }

    @Test
    void shouldCacheBoth() {
        NamedDatabaseId otherNamedDbId = DatabaseIdFactory.from((String)"otherDb", (UUID)UUID.randomUUID());
        Mockito.when((Object)this.delegate.getByName(otherNamedDbId.name())).thenReturn(Optional.of(otherNamedDbId));
        Mockito.when((Object)this.delegate.getById(otherNamedDbId.databaseId())).thenReturn(Optional.of(otherNamedDbId));
        this.databaseIdRepository.getByName(this.randomDbName).get();
        this.databaseIdRepository.getByName(this.randomDbName).get();
        this.databaseIdRepository.getById(this.randomDbId).get();
        this.databaseIdRepository.getById(otherNamedDbId.databaseId()).get();
        this.databaseIdRepository.getById(otherNamedDbId.databaseId()).get();
        this.databaseIdRepository.getByName(otherNamedDbId.name()).get();
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getByName(this.randomDbName);
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).getById(this.randomDbId);
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getById(otherNamedDbId.databaseId());
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).getByName(otherNamedDbId.name());
    }

    @Test
    void shouldReturnSystemDatabaseIdDirectlyByName() {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository.getByName(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.name()).get();
        Assertions.assertThat((Comparable)namedDatabaseId).isEqualTo((Object)NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    void shouldReturnSystemDatabaseIdDirectlyByUuid() {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository.getById(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.databaseId()).get();
        Assertions.assertThat((Comparable)namedDatabaseId).isEqualTo((Object)NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    void shouldInvalidateAll() {
        NamedDatabaseId otherNamedDbId = DatabaseIdFactory.from((String)"otherDb", (UUID)UUID.randomUUID());
        this.databaseIdRepository.getByName(otherNamedDbId.name());
        this.databaseIdRepository.getById(this.randomDbId);
        this.databaseIdRepository.invalidateAll();
        this.databaseIdRepository.getByName(otherNamedDbId.name());
        this.databaseIdRepository.getById(this.randomDbId);
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)2))).getByName(otherNamedDbId.name());
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)2))).getById(this.randomDbId);
    }
}

