/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.MapCachingDatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseReferenceRepositoryTest {
    private final DatabaseReferenceRepository delegate = (DatabaseReferenceRepository)Mockito.mock(DatabaseReferenceRepository.class);
    private final NamedDatabaseId dbId = DatabaseIdFactory.from((String)"random", (UUID)UUID.randomUUID());
    private final NormalizedDatabaseName name = new NormalizedDatabaseName(this.dbId.name());
    private final NormalizedDatabaseName aliasName = new NormalizedDatabaseName("foo");
    private final DatabaseReference ref = new DatabaseReference.Internal(this.name, this.dbId);
    private final DatabaseReference aliasRef = new DatabaseReference.Internal(this.aliasName, this.dbId);
    private DatabaseReferenceRepository.Caching databaseRefRepo;

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.delegate.getByName(this.aliasName)).thenReturn(Optional.of(this.aliasRef));
        Mockito.when((Object)this.delegate.getByName(this.name)).thenReturn(Optional.of(this.ref));
        this.databaseRefRepo = new MapCachingDatabaseReferenceRepository(this.delegate);
    }

    @Test
    void shouldLookupByName() {
        Optional lookup = this.databaseRefRepo.getByName(this.name);
        Optional lookupAlias = this.databaseRefRepo.getByName(this.aliasName);
        Optional lookupUnknown = this.databaseRefRepo.getByName(new NormalizedDatabaseName("unknown"));
        Assertions.assertThat((Optional)lookup).contains((Object)this.ref);
        Assertions.assertThat((Optional)lookupAlias).contains((Object)this.aliasRef);
        Assertions.assertThat((Optional)lookupUnknown).isEmpty();
    }

    @Test
    void shouldCacheByByName() {
        Optional lookup = this.databaseRefRepo.getByName(this.name);
        Optional lookup2 = this.databaseRefRepo.getByName(this.name);
        Assertions.assertThat((Optional)lookup).contains((Object)this.ref);
        Assertions.assertThat((Optional)lookup).isEqualTo((Object)lookup2);
        ((DatabaseReferenceRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getByName(this.name);
    }

    @Test
    void shouldNotCacheGetAllLookups() {
        this.databaseRefRepo.getAllDatabaseReferences();
        this.databaseRefRepo.getInternalDatabaseReferences();
        this.databaseRefRepo.getExternalDatabaseReferences();
        this.databaseRefRepo.getAllDatabaseReferences();
        this.databaseRefRepo.getInternalDatabaseReferences();
        this.databaseRefRepo.getExternalDatabaseReferences();
        ((DatabaseReferenceRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atLeast((int)2))).getAllDatabaseReferences();
        ((DatabaseReferenceRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atLeast((int)2))).getInternalDatabaseReferences();
        ((DatabaseReferenceRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atLeast((int)2))).getExternalDatabaseReferences();
    }
}

