/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public final class TestDatabaseReferenceRepository {
    public static DatabaseReference randomAnyDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.anyDatabaseReference(databaseName);
    }

    public static DatabaseReference anyDatabaseReference(String databaseName) {
        boolean internal = ThreadLocalRandom.current().nextBoolean();
        return internal ? TestDatabaseReferenceRepository.internalDatabaseReference(databaseName) : TestDatabaseReferenceRepository.externalDatabaseReference(databaseName);
    }

    public static DatabaseReference.Internal randomInternalDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.internalDatabaseReference(databaseName);
    }

    public static DatabaseReference.External randomExternalDatabaseReference() {
        String databaseName = RandomStringUtils.randomAlphabetic((int)10);
        return TestDatabaseReferenceRepository.externalDatabaseReference(databaseName);
    }

    public static DatabaseReference.Internal internalDatabaseReference(String databaseName) {
        return TestDatabaseReferenceRepository.internalDatabaseReference(databaseName, databaseName);
    }

    public static DatabaseReference.Internal internalDatabaseReference(String databaseName, String aliasName) {
        NormalizedDatabaseName normalizedAlias = new NormalizedDatabaseName(aliasName);
        NamedDatabaseId dbId = DatabaseIdFactory.from((String)databaseName, (UUID)UUID.nameUUIDFromBytes(databaseName.getBytes(StandardCharsets.UTF_8)));
        return new DatabaseReference.Internal(normalizedAlias, dbId);
    }

    public static DatabaseReference.External externalDatabaseReference(String databaseName) {
        return TestDatabaseReferenceRepository.externalDatabaseReference(databaseName, databaseName);
    }

    public static DatabaseReference.External externalDatabaseReference(String localAliasName, String targetDatabaseName) {
        NormalizedDatabaseName normalizedAlias = new NormalizedDatabaseName(localAliasName);
        NormalizedDatabaseName normalizedTarget = new NormalizedDatabaseName(targetDatabaseName);
        SocketAddress addr = SocketAddressParser.socketAddress((URI)URI.create("my.neo4j.com"), (int)7687, SocketAddress::new);
        RemoteUri uri = new RemoteUri("neo4j", List.of(addr), null);
        UUID uuid = UUID.randomUUID();
        return new DatabaseReference.External(normalizedTarget, normalizedAlias, uri, uuid);
    }

    public static class Fixed
    implements DatabaseReferenceRepository {
        private static final DatabaseReference SYSTEM_DATABASE_REFERENCE = new DatabaseReference.Internal(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        private final Map<NormalizedDatabaseName, DatabaseReference> databaseReferences;

        public Fixed(Collection<DatabaseReference> databaseReferences) {
            this.databaseReferences = databaseReferences.stream().collect(Collectors.toMap(DatabaseReference::alias, Function.identity()));
        }

        public Fixed(DatabaseReference ... databaseReferences) {
            this.databaseReferences = Arrays.stream(databaseReferences).collect(Collectors.toMap(DatabaseReference::alias, Function.identity()));
        }

        public Optional<DatabaseReference> getByName(NormalizedDatabaseName databaseName) {
            if (Objects.equals("system", databaseName.name())) {
                return Optional.of(SYSTEM_DATABASE_REFERENCE);
            }
            return Optional.ofNullable(this.databaseReferences.get(databaseName));
        }

        public Set<DatabaseReference> getAllDatabaseReferences() {
            return Set.copyOf(this.databaseReferences.values());
        }

        public Set<DatabaseReference.Internal> getInternalDatabaseReferences() {
            return this.getDatabaseReferences(DatabaseReference.Internal.class);
        }

        public Set<DatabaseReference.External> getExternalDatabaseReferences() {
            return this.getDatabaseReferences(DatabaseReference.External.class);
        }

        private <T extends DatabaseReference> Set<T> getDatabaseReferences(Class<T> type) {
            return this.databaseReferences.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
        }

        public void setDatabaseReference(NormalizedDatabaseName databaseName, DatabaseReference databaseRef) {
            this.databaseReferences.put(databaseName, databaseRef);
        }

        public void removeDatabaseReference(NormalizedDatabaseName databaseName) {
            this.databaseReferences.remove(databaseName);
        }
    }
}

