/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.InnerTransactionHandlerImpl;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.test.Race;

class InnerTransactionHandlerImplTest {
    KernelTransactions kernelTransactions = (KernelTransactions)Mockito.mock(KernelTransactions.class);

    InnerTransactionHandlerImplTest() {
    }

    @Test
    void testRaceConditionRegisterTerminate() throws Throwable {
        for (int i = 0; i < 100; ++i) {
            KernelTransactionHandle innerHandle = (KernelTransactionHandle)Mockito.mock(KernelTransactionHandle.class);
            long innerTransactionId = 42L;
            Mockito.when((Object)innerHandle.getUserTransactionId()).thenReturn((Object)innerTransactionId);
            Mockito.when((Object)this.kernelTransactions.executingTransactions()).thenReturn(Collections.singleton(innerHandle));
            InnerTransactionHandlerImpl terminationHandler = new InnerTransactionHandlerImpl(this.kernelTransactions);
            Race race = new Race();
            race.addContestant(() -> terminationHandler.registerInnerTransaction(innerTransactionId));
            race.addContestants(3, () -> terminationHandler.terminateInnerTransactions((Status)Status.Transaction.Terminated));
            race.shuffleContestants();
            race.go();
            ((KernelTransactionHandle)Mockito.verify((Object)innerHandle, (VerificationMode)Mockito.atLeastOnce())).markForTermination((Status)ArgumentMatchers.any());
        }
    }

    @Test
    void testRegisterInnerTransactionBeforeTerminate() {
        KernelTransactionHandle innerHandle = (KernelTransactionHandle)Mockito.mock(KernelTransactionHandle.class);
        long innerTransactionId = 42L;
        Mockito.when((Object)innerHandle.getUserTransactionId()).thenReturn((Object)innerTransactionId);
        Mockito.when((Object)this.kernelTransactions.executingTransactions()).thenReturn(Collections.singleton(innerHandle));
        InnerTransactionHandlerImpl terminationHandler = new InnerTransactionHandlerImpl(this.kernelTransactions);
        terminationHandler.registerInnerTransaction(innerTransactionId);
        terminationHandler.terminateInnerTransactions((Status)Status.Transaction.Terminated);
        ((KernelTransactionHandle)Mockito.verify((Object)innerHandle, (VerificationMode)Mockito.atLeastOnce())).markForTermination((Status)ArgumentMatchers.any());
    }

    @Test
    void testRegisterAfterTerminate() {
        KernelTransactionHandle innerHandle = (KernelTransactionHandle)Mockito.mock(KernelTransactionHandle.class);
        long innerTransactionId = 42L;
        Mockito.when((Object)innerHandle.getUserTransactionId()).thenReturn((Object)innerTransactionId);
        Mockito.when((Object)this.kernelTransactions.executingTransactions()).thenReturn(Collections.singleton(innerHandle));
        InnerTransactionHandlerImpl terminationHandler = new InnerTransactionHandlerImpl(this.kernelTransactions);
        terminationHandler.terminateInnerTransactions((Status)Status.Transaction.Terminated);
        terminationHandler.registerInnerTransaction(innerTransactionId);
        ((KernelTransactionHandle)Mockito.verify((Object)innerHandle, (VerificationMode)Mockito.atLeastOnce())).markForTermination((Status)ArgumentMatchers.any());
    }

    @Test
    void testRegisterWithoutClose() {
        KernelTransactionHandle innerHandle = (KernelTransactionHandle)Mockito.mock(KernelTransactionHandle.class);
        long innerTransactionId = 42L;
        Mockito.when((Object)innerHandle.getUserTransactionId()).thenReturn((Object)innerTransactionId);
        Mockito.when((Object)this.kernelTransactions.executingTransactions()).thenReturn(Collections.singleton(innerHandle));
        InnerTransactionHandlerImpl terminationHandler = new InnerTransactionHandlerImpl(this.kernelTransactions);
        terminationHandler.registerInnerTransaction(innerTransactionId);
        ((KernelTransactionHandle)Mockito.verify((Object)innerHandle, (VerificationMode)Mockito.never())).markForTermination((Status)ArgumentMatchers.any());
    }
}

