/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ThreadTestUtils;

class ContractCheckingIndexProxyTest {
    private static final long TEST_TIMEOUT = 20000L;

    ContractCheckingIndexProxyTest() {
    }

    @Test
    void shouldNotCreateIndexTwice() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).start());
    }

    @Test
    void shouldNotCloseIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.close(CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotCloseIndexTwice$0((IndexProxy)outer));
    }

    @Test
    void shouldNotDropIndexTwice() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.drop();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).drop());
    }

    @Test
    void shouldNotDropAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.close(CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).drop());
    }

    @Test
    void shouldDropAfterCreate() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.drop();
    }

    @Test
    void shouldCloseAfterCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close(CursorContext.NULL);
    }

    @Test
    void shouldNotUpdateBeforeCreate() {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotUpdateBeforeCreate$1((IndexProxy)outer));
    }

    @Test
    void shouldNotUpdateAfterClose() throws Exception {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close(CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotUpdateAfterClose$2((IndexProxy)outer));
    }

    @Test
    void shouldNotForceBeforeCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.force(CursorContext.NULL);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{inner});
    }

    @Test
    void shouldNotForceAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close(CursorContext.NULL);
        outer.force(CursorContext.NULL);
        ((IndexProxy)Mockito.verify((Object)inner)).start();
        ((IndexProxy)Mockito.verify((Object)inner)).close((CursorContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{inner});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotCloseWhileCreating() {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndWaitForAllToStartAndFinish();
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        ContractCheckingIndexProxyTest.runInSeparateThread(() -> ((IndexProxy)outer).start());
        try {
            latch.waitForAllToStart();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ContractCheckingIndexProxyTest.lambda$shouldNotCloseWhileCreating$3((IndexProxy)outer));
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotDropWhileCreating() {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndWaitForAllToStartAndFinish();
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        ContractCheckingIndexProxyTest.runInSeparateThread(() -> ((IndexProxy)outer).start());
        try {
            latch.waitForAllToStart();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexProxy)outer).drop());
        }
        finally {
            latch.finish();
        }
    }

    @Test
    void closeWaitForUpdateToFinish() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
                return super.newUpdater(mode, cursorContext);
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        Thread actionThread = ContractCheckingIndexProxyTest.createActionThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForUpdateToFinish$4((IndexProxy)outer));
        outer.start();
        Thread updaterThread = ContractCheckingIndexProxyTest.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForUpdateToFinish$5((IndexProxy)outer, actionThread, latch));
        ThreadTestUtils.awaitThreadState((Thread)actionThread, (long)20000L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        latch.countDown();
        updaterThread.join();
        actionThread.join();
    }

    @Test
    void closeWaitForForceToComplete() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Thread> actionThreadReference = new AtomicReference<Thread>();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void force(CursorContext cursorContext) {
                try {
                    ((Thread)actionThreadReference.get()).start();
                    latch.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(inner);
        Thread actionThread = ContractCheckingIndexProxyTest.createActionThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForForceToComplete$6((IndexProxy)outer));
        actionThreadReference.set(actionThread);
        outer.start();
        Thread thread = ContractCheckingIndexProxyTest.runInSeparateThread(() -> ContractCheckingIndexProxyTest.lambda$closeWaitForForceToComplete$7((IndexProxy)outer));
        ThreadTestUtils.awaitThreadState((Thread)actionThread, (long)20000L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        latch.countDown();
        thread.join();
        actionThread.join();
    }

    @Test
    void exceptionFromNewUpdaterDoesNotAddOpenCalls() {
        ContractCheckingIndexProxy outer = ContractCheckingIndexProxyTest.newContractCheckingIndexProxy(new IndexProxyAdapter(){

            @Override
            public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
                throw new IllegalStateException("Can't create updater");
            }
        });
        outer.start();
        Assertions.assertThatThrownBy(() -> {
            IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
            if (updater != null) {
                updater.close();
            }
        }).isInstanceOf(IllegalStateException.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)outer.getOpenCalls()).as("Failure to create updater should result in zero open calls", new Object[0])).isZero();
    }

    private static Thread runInSeparateThread(ThrowingRunnable action) {
        Thread thread = ContractCheckingIndexProxyTest.createActionThread(action);
        thread.start();
        return thread;
    }

    private static Thread createActionThread(ThrowingRunnable action) {
        return new Thread(() -> {
            try {
                action.run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static ContractCheckingIndexProxy newContractCheckingIndexProxy(IndexProxy inner) {
        return new ContractCheckingIndexProxy(inner);
    }

    private static /* synthetic */ void lambda$closeWaitForForceToComplete$7(IndexProxy outer) throws IOException {
        outer.force(CursorContext.NULL);
    }

    private static /* synthetic */ void lambda$closeWaitForForceToComplete$6(IndexProxy outer) throws IOException {
        outer.close(CursorContext.NULL);
    }

    private static /* synthetic */ void lambda$closeWaitForUpdateToFinish$5(IndexProxy outer, Thread actionThread, CountDownLatch latch) throws IOException {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)((ValueIndexEntryUpdate)null));
            try {
                actionThread.start();
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$closeWaitForUpdateToFinish$4(IndexProxy outer) throws IOException {
        outer.close(CursorContext.NULL);
    }

    private static /* synthetic */ void lambda$shouldNotCloseWhileCreating$3(IndexProxy outer) throws Throwable {
        outer.close(CursorContext.NULL);
    }

    private static /* synthetic */ void lambda$shouldNotUpdateAfterClose$2(IndexProxy outer) throws Throwable {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)((ValueIndexEntryUpdate)null));
        }
    }

    private static /* synthetic */ void lambda$shouldNotUpdateBeforeCreate$1(IndexProxy outer) throws Throwable {
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)((ValueIndexEntryUpdate)null));
        }
    }

    private static /* synthetic */ void lambda$shouldNotCloseIndexTwice$0(IndexProxy outer) throws Throwable {
        outer.close(CursorContext.NULL);
    }

    private static interface ThrowingRunnable {
        public void run() throws IOException;
    }
}

